/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.blocks;

import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1100;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_793;
import org.jetbrains.annotations.Nullable;
import ru.bclib.blocks.BaseBlockNotFull;
import ru.bclib.client.models.BasePatterns;
import ru.bclib.client.models.BlockModelProvider;
import ru.bclib.client.models.ModelsHelper;
import ru.bclib.client.models.PatternsHelper;
import ru.bclib.client.render.BCLRenderLayer;
import ru.bclib.interfaces.IRenderTyped;
import ru.bclib.util.BlocksHelper;

public class BaseLadderBlock
extends BaseBlockNotFull
implements IRenderTyped,
BlockModelProvider {
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    protected static final class_265 EAST_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final class_265 WEST_SHAPE = class_2248.method_9541((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 SOUTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final class_265 NORTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);

    public BaseLadderBlock(class_2248 block) {
        super(FabricBlockSettings.copyOf((class_4970)block).method_22488());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{FACING});
        stateManager.method_11667(new class_2769[]{WATERLOGGED});
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 ePos) {
        switch ((class_2350)state.method_11654((class_2769)FACING)) {
            case field_11035: {
                return SOUTH_SHAPE;
            }
            case field_11039: {
                return WEST_SHAPE;
            }
            case field_11034: {
                return EAST_SHAPE;
            }
        }
        return NORTH_SHAPE;
    }

    private boolean canPlaceOn(class_1922 world, class_2338 pos, class_2350 side) {
        class_2680 blockState = world.method_8320(pos);
        return !blockState.method_26219() && blockState.method_26206(world, pos, side);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        return this.canPlaceOn((class_1922)world, pos.method_10093(direction.method_10153()), direction);
    }

    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (facing.method_10153() == state.method_11654((class_2769)FACING) && !state.method_26184((class_4538)world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_8405().method_8676(pos, (Object)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, facing, neighborState, world, pos, neighborPos);
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350[] directions;
        class_2680 blockState;
        if (!ctx.method_7717() && (blockState = ctx.method_8045().method_8320(ctx.method_8037().method_10093(ctx.method_8038().method_10153()))).method_26204() == this && blockState.method_11654((class_2769)FACING) == ctx.method_8038()) {
            return null;
        }
        blockState = this.method_9564();
        class_1937 worldView = ctx.method_8045();
        class_2338 blockPos = ctx.method_8037();
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        for (class_2350 direction : directions = ctx.method_7718()) {
            if (!direction.method_10166().method_10179() || !(blockState = (class_2680)blockState.method_11657((class_2769)FACING, (Comparable)direction.method_10153())).method_26184((class_4538)worldView, blockPos)) continue;
            return (class_2680)blockState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        }
        return null;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (class_2769<class_2350>)FACING);
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (class_2769<class_2350>)FACING);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_793 getItemModel(class_2960 blockId) {
        return ModelsHelper.createBlockItem(blockId);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public class_793 getBlockModel(class_2960 blockId, class_2680 blockState) {
        Optional<String> pattern = PatternsHelper.createJson(BasePatterns.BLOCK_LADDER, blockId);
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_1100 getModelVariant(class_2960 stateId, class_2680 blockState, Map<class_2960, class_1100> modelCache) {
        class_2960 modelId = new class_2960(stateId.method_12836(), "block/" + stateId.method_12832());
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        return ModelsHelper.createFacingModel(modelId, (class_2350)blockState.method_11654((class_2769)FACING), false, true);
    }
}

