/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.world.biomes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1143;
import net.minecraft.class_1299;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3133;
import net.minecraft.class_3414;
import net.minecraft.class_3504;
import net.minecraft.class_3523;
import net.minecraft.class_3527;
import net.minecraft.class_3531;
import net.minecraft.class_3532;
import net.minecraft.class_4761;
import net.minecraft.class_4763;
import net.minecraft.class_4967;
import net.minecraft.class_4968;
import net.minecraft.class_5195;
import net.minecraft.class_5312;
import net.minecraft.class_5471;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import ru.bclib.config.IdConfig;
import ru.bclib.util.ColorUtil;
import ru.bclib.world.features.BCLFeature;
import ru.bclib.world.structures.BCLStructureFeature;
import ru.bclib.world.surface.DoubleBlockSurfaceBuilder;

public class BCLBiomeDef {
    public static final int DEF_FOLIAGE_OVERWORLD = ColorUtil.color(110, 143, 64);
    public static final int DEF_FOLIAGE_NETHER = ColorUtil.color(117, 10, 10);
    public static final int DEF_FOLIAGE_END = ColorUtil.color(197, 210, 112);
    private final List<class_5312<?, ?>> structures = Lists.newArrayList();
    private final List<FeatureInfo> features = Lists.newArrayList();
    private final List<CarverInfo> carvers = Lists.newArrayList();
    private final List<SpawnInfo> mobs = Lists.newArrayList();
    private final List<class_5483.class_1964> spawns = Lists.newArrayList();
    private final Map<String, Object> customData = Maps.newHashMap();
    private final class_2960 id;
    private class_4761 particleConfig;
    private class_4967 additions;
    private class_4968 mood;
    private class_3414 music;
    private class_3414 loop;
    private int foliageColor = DEF_FOLIAGE_OVERWORLD;
    private int grassColor = DEF_FOLIAGE_OVERWORLD;
    private int waterFogColor = 329011;
    private int waterColor = 4159204;
    private int fogColor = 0xA080A0;
    private float fogDensity = 1.0f;
    private float depth = 0.1f;
    private class_1959.class_1963 precipitation = class_1959.class_1963.field_9384;
    private class_1959.class_1961 category = class_1959.class_1961.field_9371;
    private float temperature = 1.0f;
    private float genChance = 1.0f;
    private float downfall = 0.0f;
    private int edgeSize = 32;
    private class_3504<?> surface;

    public BCLBiomeDef(class_2960 id) {
        this.id = id;
    }

    public BCLBiomeDef netherBiome() {
        this.foliageColor = DEF_FOLIAGE_NETHER;
        this.grassColor = DEF_FOLIAGE_NETHER;
        this.setCategory(class_1959.class_1961.field_9366);
        return this;
    }

    public BCLBiomeDef endBiome() {
        this.foliageColor = DEF_FOLIAGE_END;
        this.grassColor = DEF_FOLIAGE_END;
        this.setCategory(class_1959.class_1961.field_9360);
        return this;
    }

    public BCLBiomeDef loadConfigValues(IdConfig config) {
        this.fogDensity = config.getFloat(this.id, "fog_density", this.fogDensity);
        this.genChance = config.getFloat(this.id, "generation_chance", this.genChance);
        this.edgeSize = config.getInt(this.id, "edge_size", this.edgeSize);
        return this;
    }

    public BCLBiomeDef setCategory(class_1959.class_1961 category) {
        this.category = category;
        return this;
    }

    public BCLBiomeDef setPrecipitation(class_1959.class_1963 precipitation) {
        this.precipitation = precipitation;
        return this;
    }

    public BCLBiomeDef setSurface(class_2248 block) {
        this.setSurface(class_3523.field_15701.method_30478((class_3531)new class_3527(block.method_9564(), class_2246.field_10471.method_9564(), class_2246.field_10471.method_9564())));
        return this;
    }

    public BCLBiomeDef setSurface(class_2248 block1, class_2248 block2) {
        this.setSurface(DoubleBlockSurfaceBuilder.register("bclib_" + this.id.method_12832() + "_surface").setBlock1(block1).setBlock2(block2).configured());
        return this;
    }

    public BCLBiomeDef setSurface(class_3504<?> builder) {
        this.surface = builder;
        return this;
    }

    public BCLBiomeDef setParticles(class_2394 particle, float probability) {
        this.particleConfig = new class_4761(particle, probability);
        return this;
    }

    public BCLBiomeDef setGenChance(float genChance) {
        this.genChance = genChance;
        return this;
    }

    public BCLBiomeDef setDepth(float depth) {
        this.depth = depth;
        return this;
    }

    public BCLBiomeDef setTemperature(float temperature) {
        this.temperature = temperature;
        return this;
    }

    public BCLBiomeDef setDownfall(float downfall) {
        this.downfall = downfall;
        return this;
    }

    public BCLBiomeDef setEdgeSize(int edgeSize) {
        this.edgeSize = edgeSize;
        return this;
    }

    public BCLBiomeDef addMobSpawn(class_1299<?> type, int weight, int minGroupSize, int maxGroupSize) {
        class_2960 eID = class_2378.field_11145.method_10221(type);
        if (eID != class_2378.field_11145.method_10137()) {
            SpawnInfo info = new SpawnInfo();
            info.type = type;
            info.weight = weight;
            info.minGroupSize = minGroupSize;
            info.maxGroupSize = maxGroupSize;
            this.mobs.add(info);
        }
        return this;
    }

    public BCLBiomeDef addMobSpawn(class_5483.class_1964 entry) {
        this.spawns.add(entry);
        return this;
    }

    public BCLBiomeDef addStructureFeature(class_5312<?, ?> feature) {
        this.structures.add(feature);
        return this;
    }

    public BCLBiomeDef addStructureFeature(BCLStructureFeature feature) {
        this.structures.add(feature.getFeatureConfigured());
        return this;
    }

    public BCLBiomeDef addFeature(BCLFeature feature) {
        FeatureInfo info = new FeatureInfo();
        info.featureStep = feature.getFeatureStep();
        info.feature = feature.getFeatureConfigured();
        this.features.add(info);
        return this;
    }

    public BCLBiomeDef addFeature(class_2893.class_2895 featureStep, class_2975<?, ?> feature) {
        FeatureInfo info = new FeatureInfo();
        info.featureStep = featureStep;
        info.feature = feature;
        this.features.add(info);
        return this;
    }

    private int getColor(int r, int g, int b) {
        r = class_3532.method_15340((int)r, (int)0, (int)255);
        g = class_3532.method_15340((int)g, (int)0, (int)255);
        b = class_3532.method_15340((int)b, (int)0, (int)255);
        return ColorUtil.color(r, g, b);
    }

    public BCLBiomeDef setFogColor(int r, int g, int b) {
        this.fogColor = this.getColor(r, g, b);
        return this;
    }

    public BCLBiomeDef setFogDensity(float density) {
        this.fogDensity = density;
        return this;
    }

    public BCLBiomeDef setWaterColor(int r, int g, int b) {
        this.waterColor = this.getColor(r, g, b);
        return this;
    }

    public BCLBiomeDef setWaterFogColor(int r, int g, int b) {
        this.waterFogColor = this.getColor(r, g, b);
        return this;
    }

    public BCLBiomeDef setWaterAndFogColor(int r, int g, int b) {
        return this.setWaterColor(r, g, b).setWaterFogColor(r, g, b);
    }

    public BCLBiomeDef setFoliageColor(int r, int g, int b) {
        this.foliageColor = this.getColor(r, g, b);
        return this;
    }

    public BCLBiomeDef setGrassColor(int r, int g, int b) {
        this.grassColor = this.getColor(r, g, b);
        return this;
    }

    public BCLBiomeDef setPlantsColor(int r, int g, int b) {
        return this.setFoliageColor(r, g, b).setGrassColor(r, g, b);
    }

    public BCLBiomeDef setLoop(class_3414 loop) {
        this.loop = loop;
        return this;
    }

    public BCLBiomeDef setMood(class_3414 mood) {
        this.mood = new class_4968(mood, 6000, 8, 2.0);
        return this;
    }

    public BCLBiomeDef setAdditions(class_3414 additions) {
        this.additions = new class_4967(additions, 0.0111);
        return this;
    }

    public BCLBiomeDef setMusic(class_3414 music) {
        this.music = music;
        return this;
    }

    public class_1959 build() {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        class_5485.class_5495 generationSettings = new class_5485.class_5495();
        class_4763.class_4764 effects = new class_4763.class_4764();
        this.mobs.forEach(spawn -> spawnSettings.method_31011(spawn.type.method_5891(), new class_5483.class_1964(spawn.type, spawn.weight, spawn.minGroupSize, spawn.maxGroupSize)));
        this.spawns.forEach(entry -> spawnSettings.method_31011(entry.field_9389.method_5891(), entry));
        generationSettings.method_30996(this.surface == null ? class_5471.field_26322 : this.surface);
        this.structures.forEach(structure -> generationSettings.method_30995(structure));
        this.features.forEach(info -> generationSettings.method_30992(info.featureStep, info.feature));
        this.carvers.forEach(info -> generationSettings.method_30991(info.carverStep, info.carver));
        effects.method_30820(0).method_24395(this.waterColor).method_24397(this.waterFogColor).method_24392(this.fogColor).method_30821(this.foliageColor).method_30822(this.grassColor);
        if (this.loop != null) {
            effects.method_24942(this.loop);
        }
        if (this.mood != null) {
            effects.method_24943(this.mood);
        }
        if (this.additions != null) {
            effects.method_24944(this.additions);
        }
        if (this.particleConfig != null) {
            effects.method_24393(this.particleConfig);
        }
        effects.method_27346(this.music != null ? new class_5195(this.music, 600, 2400, true) : class_1143.field_5583);
        return new class_1959.class_1960().method_8735(this.precipitation).method_8738(this.category).method_8740(this.depth).method_8743(0.2f).method_8747(this.temperature).method_8727(this.downfall).method_24379(effects.method_24391()).method_30974(spawnSettings.method_31007()).method_30973(generationSettings.method_30987()).method_30972();
    }

    public class_2960 getID() {
        return this.id;
    }

    public float getFodDensity() {
        return this.fogDensity;
    }

    public float getGenChance() {
        return this.genChance;
    }

    public int getEdgeSize() {
        return this.edgeSize;
    }

    public BCLBiomeDef addCarver(class_2893.class_2894 carverStep, class_2922<class_3133> carver) {
        CarverInfo info = new CarverInfo();
        info.carverStep = carverStep;
        info.carver = carver;
        this.carvers.add(info);
        return this;
    }

    public BCLBiomeDef addCustomData(String name, Object value) {
        this.customData.put(name, value);
        return this;
    }

    public <T> T getCustomData(String name, Object defaultValue) {
        return (T)this.customData.getOrDefault(name, defaultValue);
    }

    protected Map<String, Object> getCustomData() {
        return this.customData;
    }

    private static final class SpawnInfo {
        class_1299<?> type;
        int weight;
        int minGroupSize;
        int maxGroupSize;

        private SpawnInfo() {
        }
    }

    private static final class FeatureInfo {
        class_2893.class_2895 featureStep;
        class_2975<?, ?> feature;

        private FeatureInfo() {
        }
    }

    private static final class CarverInfo {
        class_2893.class_2894 carverStep;
        class_2922<class_3133> carver;

        private CarverInfo() {
        }
    }
}

