/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.slottype;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypeInfo;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.common.slottype.SlotType;
import top.theillusivec4.curios.server.CurioArgumentType;
import top.theillusivec4.curios.server.CuriosConfig;

public class SlotTypeManager {
    private static Map<String, SlotType.Builder> queueBuilders = new HashMap<String, SlotType.Builder>();
    private static Map<String, SlotType.Builder> configBuilders = new HashMap<String, SlotType.Builder>();

    public static Map<String, SlotType.Builder> getQueuedSlotTypes() {
        return queueBuilders;
    }

    public static void buildQueuedSlotTypes() {
        queueBuilders.clear();
        for (class_3545<SlotTypeInfo.BuildScheme, SlotTypeInfo> pair : CuriosApi.getSlotTypeQueue()) {
            SlotTypeInfo presetInfo;
            SlotTypeInfo info = (SlotTypeInfo)pair.method_15441();
            String id = info.getIdentifier();
            SlotType.Builder builder = queueBuilders.get(id);
            if (builder == null && pair.method_15442() == SlotTypeInfo.BuildScheme.REGISTER) {
                builder = new SlotType.Builder(id);
                queueBuilders.put(id, builder);
            }
            if (builder == null) continue;
            builder.size(info.getSize()).locked(info.isLocked()).visible(info.isVisible()).hasCosmetic(info.hasCosmetic());
            SlotTypeInfo.Builder preset = SlotTypePreset.findPreset(id).map(SlotTypePreset::getInfoBuilder).orElse(null);
            SlotTypeInfo slotTypeInfo = presetInfo = preset != null ? preset.build() : null;
            if (info.getIcon() == null && presetInfo != null) {
                builder.icon(presetInfo.getIcon());
            } else {
                builder.icon(info.getIcon());
            }
            if (info.getPriority() == null && presetInfo != null) {
                builder.priority(presetInfo.getPriority());
                continue;
            }
            builder.priority(info.getPriority());
        }
    }

    public static void buildConfigSlotTypes() {
        configBuilders.clear();
        Map<String, CuriosConfig.CurioSetting> settings = CuriosConfig.curios;
        if (settings == null) {
            return;
        }
        settings.forEach((identifier, setting) -> {
            boolean force;
            SlotType.Builder builder = queueBuilders.get(identifier);
            boolean bl = force = setting.override != null ? setting.override : false;
            if (builder == null) {
                builder = new SlotType.Builder((String)identifier);
                SlotTypeInfo.Builder preset = SlotTypePreset.findPreset(identifier).map(SlotTypePreset::getInfoBuilder).orElse(null);
                if (preset != null) {
                    SlotTypeInfo msg = preset.build();
                    builder.icon(msg.getIcon()).priority(msg.getPriority()).size(msg.getSize()).locked(msg.isLocked()).visible(msg.isVisible()).hasCosmetic(msg.hasCosmetic());
                }
            } else {
                builder = new SlotType.Builder((String)identifier).copyFrom(builder);
            }
            configBuilders.putIfAbsent((String)identifier, builder);
            if (setting.priority != null) {
                builder.priority(setting.priority, force);
            }
            if (setting.icon != null && !setting.icon.isEmpty()) {
                builder.icon(new class_2960(setting.icon));
            }
            if (setting.size != null) {
                builder.size(setting.size, force);
            }
            if (setting.locked != null) {
                builder.locked(setting.locked, force);
            }
            if (setting.visible != null) {
                builder.visible(setting.visible, force);
            }
            if (setting.hasCosmetic != null) {
                builder.hasCosmetic(setting.hasCosmetic, force);
            }
        });
        queueBuilders.forEach((key, builder) -> configBuilders.putIfAbsent((String)key, (SlotType.Builder)builder));
    }

    public static void buildSlotTypes() {
        Map<String, SlotType.Builder> builders = !configBuilders.isEmpty() ? configBuilders : queueBuilders;
        builders.values().forEach(builder -> CuriosApi.getSlotHelper().addSlotType(builder.build()));
        CurioArgumentType.slotIds = CuriosApi.getSlotHelper().getSlotTypeIds();
    }
}

