/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.block;

import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class CatTreeBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    protected final VoxelShape voxelShape;

    public CatTreeBlock(VoxelShape axisAlignedBB) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n));
        this.voxelShape = axisAlignedBB;
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return entity instanceof SimplyCatEntity;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return this.voxelShape;
    }

    public static class Bed
    extends Facing {
        protected static final VoxelShape AABB_BOTTOM = Bed.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

        public Bed(VoxelShape voxelShape) {
            super(voxelShape);
        }

        @Override
        public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
            return AABB_BOTTOM;
        }
    }

    public static class Box
    extends Facing {
        private static final VoxelShape INSIDE_NS = Box.func_208617_a((double)2.0, (double)1.0, (double)1.0, (double)14.0, (double)14.0, (double)15.0);
        public static final VoxelShape INSIDE_EW = Box.func_208617_a((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0);
        protected static final VoxelShape NORTH_SHAPE = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Box.func_208617_a((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), (VoxelShape)INSIDE_NS), (IBooleanFunction)IBooleanFunction.field_223234_e_);
        protected static final VoxelShape EAST_SHAPE = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Box.func_208617_a((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)INSIDE_EW), (IBooleanFunction)IBooleanFunction.field_223234_e_);
        protected static final VoxelShape SOUTH_SHAPE = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Box.func_208617_a((double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)INSIDE_NS), (IBooleanFunction)IBooleanFunction.field_223234_e_);
        protected static final VoxelShape WEST_SHAPE = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Box.func_208617_a((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), (VoxelShape)INSIDE_EW), (IBooleanFunction)IBooleanFunction.field_223234_e_);

        public Box() {
            super(VoxelShapes.func_197868_b());
        }

        @Override
        public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext context) {
            Direction direction = (Direction)state.func_177229_b((Property)FACING);
            switch (direction) {
                default: {
                    return NORTH_SHAPE;
                }
                case EAST: {
                    return EAST_SHAPE;
                }
                case SOUTH: {
                    return SOUTH_SHAPE;
                }
                case WEST: 
            }
            return WEST_SHAPE;
        }

        public VoxelShape func_199600_g(BlockState state, IBlockReader blockReader, BlockPos pos) {
            Direction direction = (Direction)state.func_177229_b((Property)FACING);
            return direction.func_176740_k() == Direction.Axis.X ? INSIDE_NS : INSIDE_EW;
        }
    }

    public static class Facing
    extends CatTreeBlock {
        public Facing(VoxelShape axisAlignedBB) {
            super(axisAlignedBB);
            this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
        }

        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            Direction direction = context.func_195992_f().func_176734_d();
            return (BlockState)super.func_196258_a(context).func_206870_a((Property)FACING, (Comparable)direction);
        }

        public BlockState func_185499_a(BlockState state, Rotation rotation) {
            return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> blockStateBuilder) {
            blockStateBuilder.func_206894_a(new Property[]{FACING});
        }
    }
}

