/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.client.gui;

import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CatBookScreen
extends Screen {
    private static final int bookImageHeight = 182;
    private static final int bookImageWidth = 281;
    private static final ResourceLocation BG_TEXTURE = new ResourceLocation("simplycats", "textures/gui/cat_book.png");
    private World world;
    private int currPage;
    private final ListNBT bookPages = new ListNBT();
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    public SimplyCatEntity cat;
    protected int catHealth;

    public CatBookScreen(CompoundNBT bookTag, World world, int catInList) {
        this(bookTag, world);
        this.currPage = catInList;
    }

    public CatBookScreen(CompoundNBT bookTag, World world) {
        super(NarratorChatListener.field_216868_a);
        if (bookTag != null && !bookTag.isEmpty()) {
            ListNBT pages = bookTag.func_150295_c("pages", 10).func_74737_b();
            this.bookPages.addAll((Collection)pages);
            this.world = world;
        }
    }

    protected void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        int centerX = (this.field_230708_k_ - 281) / 2;
        this.buttonNextPage = (NextPageButton)this.func_230480_a_((Widget)new NextPageButton(centerX + 236, 157, true, button -> this.pageForward()));
        this.buttonPreviousPage = (NextPageButton)this.func_230480_a_((Widget)new NextPageButton(centerX + 25, 157, false, button -> this.pageBack()));
        this.updateButtons();
    }

    private void updateButtons() {
        this.cat = (SimplyCatEntity)EntityType.func_220335_a((CompoundNBT)this.bookPages.func_150305_b(this.currPage), (World)this.world, entity1 -> entity1);
        this.buttonNextPage.field_230694_p_ = this.currPage < this.bookPages.size() - 1;
        this.buttonPreviousPage.field_230694_p_ = this.currPage > 0;
    }

    private void pageBack() {
        if (this.currPage > 0) {
            --this.currPage;
        }
        this.updateButtons();
    }

    private void pageForward() {
        if (this.currPage < this.bookPages.size() - 1) {
            ++this.currPage;
        }
        this.updateButtons();
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int leftX = (this.field_230708_k_ - 281) / 2;
        int leftCenterX = leftX + 70;
        this.field_230706_i_.func_110434_K().func_110577_a(BG_TEXTURE);
        CatBookScreen.func_238463_a_((MatrixStack)matrixStack, (int)leftX, (int)2, (float)0.0f, (float)0.0f, (int)281, (int)182, (int)288, (int)256);
        if (this.bookPages.get(this.currPage) != null || !this.bookPages.func_150305_b(this.currPage).isEmpty() || this.cat != null) {
            InventoryScreen.func_228187_a_((int)(leftX + 40), (int)74, (int)50, (float)(leftX + 51 - mouseX), (float)(50 - mouseY), (LivingEntity)this.cat);
            int nameWidth = this.field_230712_o_.func_238414_a_((ITextProperties)this.cat.func_200200_C_());
            this.field_230712_o_.func_243248_b(matrixStack, this.cat.func_200200_C_(), (float)(leftCenterX - nameWidth / 2), 14.0f, 0);
            StringTextComponent sex = new StringTextComponent(new TranslationTextComponent(this.cat.isFixed() ? "cat.fixed.name" : "cat.intact.name").getString() + " " + Genetics.Sex.getPrettyName(this.bookPages.func_150305_b(this.currPage).func_74779_i("Phaeomelanin")).getString());
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)sex, (float)(leftX + 66), 28.0f, 0);
            this.renderCatHealth(matrixStack, leftX + 66, 42);
            if (this.cat.func_70909_n()) {
                String ownerName = this.cat.getOwnerName().getString();
                this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("tooltip.pet_carrier.owner", new Object[]{ownerName}), (float)(leftX + 16), 84.0f, 0);
            } else {
                this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("entity.simplycats.cat.untamed"), (float)(leftX + 16), 84.0f, 0);
            }
            this.field_230712_o_.func_238418_a_((ITextProperties)Genetics.getPhenotypeDescription(this.bookPages.func_150305_b(this.currPage), false), leftX + 16, 98, 120, 0);
            String eyeColor = TextFormatting.GRAY + this.bookPages.func_150305_b(this.currPage).func_74779_i("EyeColor");
            String furLength = TextFormatting.GRAY + this.bookPages.func_150305_b(this.currPage).func_74779_i("FurLength");
            String eumelanin = TextFormatting.GRAY + this.bookPages.func_150305_b(this.currPage).func_74779_i("Eumelanin");
            String phaeomelanin = TextFormatting.GRAY + this.bookPages.func_150305_b(this.currPage).func_74779_i("Phaeomelanin");
            String dilution = TextFormatting.GRAY + this.bookPages.func_150305_b(this.currPage).func_74779_i("Dilution");
            String diluteMod = TextFormatting.GRAY + this.bookPages.func_150305_b(this.currPage).func_74779_i("DiluteMod");
            String agouti = TextFormatting.GRAY + this.bookPages.func_150305_b(this.currPage).func_74779_i("Agouti");
            String tabby = TextFormatting.GRAY + this.bookPages.func_150305_b(this.currPage).func_74779_i("Tabby");
            String spotted = TextFormatting.GRAY + this.bookPages.func_150305_b(this.currPage).func_74779_i("Spotted");
            String ticked = TextFormatting.GRAY + this.bookPages.func_150305_b(this.currPage).func_74779_i("Ticked");
            String colorpoint = TextFormatting.GRAY + this.bookPages.func_150305_b(this.currPage).func_74779_i("Colorpoint");
            String white = TextFormatting.GRAY + this.bookPages.func_150305_b(this.currPage).func_74779_i("White");
            String bobtail = TextFormatting.GRAY + this.bookPages.func_150305_b(this.currPage).func_74779_i("Bobtail");
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("book.genetics.eye_color", new Object[]{eyeColor}), (float)(leftX + 152), 24.0f, 0);
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("book.genetics.fur_length", new Object[]{furLength}), (float)(leftX + 152), 34.0f, 0);
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("book.genetics.eumelanin", new Object[]{eumelanin}), (float)(leftX + 152), 44.0f, 0);
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("book.genetics.phaeomelanin", new Object[]{phaeomelanin}), (float)(leftX + 152), 54.0f, 0);
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("book.genetics.dilute", new Object[]{dilution}), (float)(leftX + 152), 64.0f, 0);
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("book.genetics.dilute_modifier", new Object[]{diluteMod}), (float)(leftX + 152), 74.0f, 0);
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("book.genetics.agouti", new Object[]{agouti}), (float)(leftX + 152), 84.0f, 0);
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("book.genetics.tabby", new Object[]{tabby}), (float)(leftX + 152), 94.0f, 0);
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("book.genetics.spotted", new Object[]{spotted}), (float)(leftX + 152), 104.0f, 0);
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("book.genetics.ticked", new Object[]{ticked}), (float)(leftX + 152), 114.0f, 0);
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("book.genetics.colorpoint", new Object[]{colorpoint}), (float)(leftX + 152), 124.0f, 0);
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("book.genetics.white", new Object[]{white}), (float)(leftX + 152), 134.0f, 0);
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("book.genetics.bobtail", new Object[]{bobtail}), (float)(leftX + 152), 144.0f, 0);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void renderCatHealth(MatrixStack matrixStack, int x, int y) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(field_230665_h_);
        this.catHealth = MathHelper.func_76123_f((float)this.cat.func_110143_aJ());
        float maxHealth = (float)this.cat.func_233637_b_(Attributes.field_233818_a_);
        int l1 = MathHelper.func_76123_f((float)(maxHealth / 2.0f / 10.0f));
        int i2 = Math.max(10 - (l1 - 2), 3);
        for (int wholeHearts = MathHelper.func_76123_f((float)(maxHealth / 2.0f)) - 1; wholeHearts >= 0; --wholeHearts) {
            int textureX = 16;
            int textureY = 0;
            int j4 = MathHelper.func_76123_f((float)((float)(wholeHearts + 1) / 10.0f)) - 1;
            int guiX = x + wholeHearts % 10 * 8;
            int guiY = y - j4 * i2;
            this.func_238474_b_(matrixStack, guiX, guiY, 16 + textureY * 9, 9 * textureY, 9, 9);
            if (wholeHearts * 2 + 1 < this.catHealth) {
                this.func_238474_b_(matrixStack, guiX, guiY, textureX + 36, 9 * textureY, 9, 9);
            }
            if (wholeHearts * 2 + 1 != this.catHealth) continue;
            this.func_238474_b_(matrixStack, guiX, guiY, textureX + 45, 9 * textureY, 9, 9);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class NextPageButton
    extends Button {
        private final boolean isNextButton;

        NextPageButton(int x, int y, boolean nextButton, Button.IPressable pressable) {
            super(x, y, 20, 12, StringTextComponent.field_240750_d_, pressable);
            this.isNextButton = nextButton;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.field_230694_p_) {
                boolean isButtonPressed = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(BG_TEXTURE);
                int textureX = 2;
                int textureY = 193;
                if (isButtonPressed) {
                    textureX += 23;
                }
                if (!this.isNextButton) {
                    textureY += 13;
                }
                NextPageButton.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)textureX, (float)textureY, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)288, (int)256);
            }
        }

        public void func_230988_a_(SoundHandler soundHandler) {
            soundHandler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219617_ah, (float)1.0f));
        }
    }
}

