/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.client.render.entity;

import com.github.mnesikos.simplycats.SCReference;
import com.github.mnesikos.simplycats.client.model.entity.SimplyCatModel;
import com.github.mnesikos.simplycats.client.render.entity.LayeredTexture;
import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public class SimplyCatRenderer
extends MobRenderer<SimplyCatEntity, SimplyCatModel<SimplyCatEntity>> {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();

    public SimplyCatRenderer(EntityRendererManager manager) {
        super(manager, new SimplyCatModel(), 0.4f);
    }

    public void render(SimplyCatEntity cat, float v, float v1, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int i) {
        ((SimplyCatModel)this.field_77045_g).isBobtail = cat.isBobtail();
        ((SimplyCatModel)this.field_77045_g).isLongFur = cat.isLongFur();
        ((SimplyCatModel)this.field_77045_g).ageScale = cat.getAgeScale();
        super.func_225623_a_((MobEntity)cat, v, v1, matrixStack, renderTypeBuffer, i);
    }

    protected void scale(SimplyCatEntity entity, MatrixStack matrixStack, float partialTickTime) {
        matrixStack.func_227862_a_(0.8f, 0.9f, 0.8f);
        super.func_225620_a_((LivingEntity)entity, matrixStack, partialTickTime);
    }

    public ResourceLocation getTextureLocation(SimplyCatEntity entity) {
        String name;
        if (entity.func_145818_k_() && entity.func_200201_e() != null && entity.func_184753_b() != null && (name = SCReference.getCustomCats().get(entity.func_184753_b())) != null && name.equalsIgnoreCase(entity.func_200201_e().getString())) {
            return new ResourceLocation("simplycats", "textures/entity/cat/custom/" + name + ".png");
        }
        String s = entity.getCatTexture();
        ResourceLocation resourceLocation = LAYERED_LOCATION_CACHE.get(s);
        if (resourceLocation == null) {
            resourceLocation = new ResourceLocation(s);
            Minecraft.func_71410_x().func_110434_K().func_229263_a_(resourceLocation, (Texture)new LayeredTexture(entity.getTexturePaths()));
            LAYERED_LOCATION_CACHE.put(s, resourceLocation);
        }
        return resourceLocation;
    }

    protected void renderNameTag(SimplyCatEntity cat, ITextComponent textComponent, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int p_225629_5_) {
        super.func_225629_a_((Entity)cat, textComponent, matrixStack, renderTypeBuffer, p_225629_5_);
        double distance = this.field_76990_c.func_229099_b_((Entity)cat);
        if (ForgeHooksClient.isNameplateInRenderDistance((Entity)cat, (double)distance) && this.field_76990_c.field_217783_c.func_216773_g().func_225608_bj_() && !cat.isFixed() && !cat.func_70631_g_()) {
            boolean catNotSneaking = !cat.func_226273_bm_();
            float height = cat.func_213302_cg() + 0.62f;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, (double)height, 0.0);
            matrixStack.func_227863_a_(this.field_76990_c.func_229098_b_());
            matrixStack.func_227862_a_(-0.012f, -0.012f, 0.012f);
            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
            float backgroundOpacity = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
            int j = (int)(backgroundOpacity * 255.0f) << 24;
            TranslationTextComponent info = new TranslationTextComponent(cat.getSex() == Genetics.Sex.FEMALE ? (cat.getBreedingStatus("inheat") ? "chat.info.in_heat" : "chat.info.not_in_heat") : "chat.info.male", new Object[]{cat.getMateTimer()});
            if (cat.getBreedingStatus("ispregnant")) {
                info = new TranslationTextComponent(cat.getBreedingStatus("inheat") ? "chat.info.pregnant_heat" : "chat.info.pregnant", new Object[]{cat.getMateTimer()});
            }
            FontRenderer fontRenderer = this.func_76983_a();
            float centeredPos = -fontRenderer.func_238414_a_((ITextProperties)info) / 2;
            fontRenderer.func_243247_a((ITextComponent)info, centeredPos, 0.0f, 0x20FFFFFF, false, matrix4f, renderTypeBuffer, catNotSneaking, j, p_225629_5_);
            if (catNotSneaking) {
                fontRenderer.func_243247_a((ITextComponent)info, centeredPos, 0.0f, -1, false, matrix4f, renderTypeBuffer, false, 0, p_225629_5_);
            }
            matrixStack.func_227865_b_();
        }
    }
}

