/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.entity;

import com.github.mnesikos.simplycats.SCReference;
import com.github.mnesikos.simplycats.SimplyCats;
import com.github.mnesikos.simplycats.configuration.SCConfig;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import com.github.mnesikos.simplycats.entity.goal.CatAttackGoal;
import com.github.mnesikos.simplycats.entity.goal.CatBirthGoal;
import com.github.mnesikos.simplycats.entity.goal.CatFollowParentGoal;
import com.github.mnesikos.simplycats.entity.goal.CatMateGoal;
import com.github.mnesikos.simplycats.entity.goal.CatSitGoal;
import com.github.mnesikos.simplycats.entity.goal.CatSitOnBlockGoal;
import com.github.mnesikos.simplycats.entity.goal.CatWanderGoal;
import com.github.mnesikos.simplycats.event.SCEvents;
import com.github.mnesikos.simplycats.item.SCItems;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SimplyCatEntity
extends TameableEntity {
    private static final DataParameter<String> EYE_COLOR = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> FUR_LENGTH = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> EUMELANIN = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> PHAEOMELANIN = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> DILUTION = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> DILUTE_MOD = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> AGOUTI = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> TABBY = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> SPOTTED = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> TICKED = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> COLORPOINT = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> WHITE = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> BOBTAIL = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> WHITE_0 = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> WHITE_1 = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> WHITE_2 = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> WHITE_PAWS_0 = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> WHITE_PAWS_1 = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> WHITE_PAWS_2 = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> WHITE_PAWS_3 = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private final String[] whiteTexturesArray = new String[3];
    private final String[] whitePawTexturesArray = new String[4];
    private String texturePrefix;
    private final String[] catTexturesArray = new String[12];
    private static final DataParameter<Optional<BlockPos>> HOME_POSITION = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    public static final DataParameter<String> OWNER_NAME = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Byte> FIXED = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> IN_HEAT = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> IS_PREGNANT = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> MATE_TIMER = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> KITTENS = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>> MOTHER = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Optional<UUID>> FATHER = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> AGE_TRACKER = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> MATURE_TIMER = EntityDataManager.func_187226_a(SimplyCatEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private SimplyCatEntity followParent;
    private Vector3d nearestLaser;

    public SimplyCatEntity(EntityType<? extends TameableEntity> type, World world) {
        super(type, world);
    }

    protected void func_184651_r() {
        TemptGoal temptGoal = new TemptGoal((CreatureEntity)this, 1.2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)SCItems.CATNIP.get(), (IItemProvider)SCItems.TREAT_BAG.get()}), false);
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new CatSitGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)temptGoal);
        this.field_70714_bg.func_75776_a(4, (Goal)new CatFollowParentGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new CatSitOnBlockGoal(this, 1.0, 8));
        this.field_70714_bg.func_75776_a(6, (Goal)new CatBirthGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(8, (Goal)new CatAttackGoal((MobEntity)this));
        if (!this.isFixed()) {
            this.field_70714_bg.func_75776_a(9, (Goal)new CatMateGoal(this, 1.2));
        }
        this.field_70714_bg.func_75776_a(10, (Goal)new CatWanderGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 7.0f));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 14.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233820_c_, 0.7).func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EYE_COLOR, (Object)Genetics.EyeColor.COPPER.toString());
        this.field_70180_af.func_187214_a(FUR_LENGTH, (Object)"L-L");
        this.field_70180_af.func_187214_a(EUMELANIN, (Object)"B-B");
        this.field_70180_af.func_187214_a(PHAEOMELANIN, (Object)"Xo-Xo");
        this.field_70180_af.func_187214_a(DILUTION, (Object)"D-D");
        this.field_70180_af.func_187214_a(DILUTE_MOD, (Object)"dm-dm");
        this.field_70180_af.func_187214_a(AGOUTI, (Object)"a-a");
        this.field_70180_af.func_187214_a(TABBY, (Object)"Mc-Mc");
        this.field_70180_af.func_187214_a(SPOTTED, (Object)"sp-sp");
        this.field_70180_af.func_187214_a(TICKED, (Object)"ta-ta");
        this.field_70180_af.func_187214_a(COLORPOINT, (Object)"C-C");
        this.field_70180_af.func_187214_a(WHITE, (Object)"w-w");
        this.field_70180_af.func_187214_a(BOBTAIL, (Object)"Jb-Jb");
        this.field_70180_af.func_187214_a(WHITE_0, (Object)"");
        this.field_70180_af.func_187214_a(WHITE_1, (Object)"");
        this.field_70180_af.func_187214_a(WHITE_2, (Object)"");
        this.field_70180_af.func_187214_a(WHITE_PAWS_0, (Object)"");
        this.field_70180_af.func_187214_a(WHITE_PAWS_1, (Object)"");
        this.field_70180_af.func_187214_a(WHITE_PAWS_2, (Object)"");
        this.field_70180_af.func_187214_a(WHITE_PAWS_3, (Object)"");
        this.field_70180_af.func_187214_a(HOME_POSITION, Optional.empty());
        this.field_70180_af.func_187214_a(OWNER_NAME, (Object)"");
        this.field_70180_af.func_187214_a(FIXED, (Object)0);
        this.field_70180_af.func_187214_a(IN_HEAT, (Object)0);
        this.field_70180_af.func_187214_a(IS_PREGNANT, (Object)0);
        this.field_70180_af.func_187214_a(MATE_TIMER, (Object)0);
        this.field_70180_af.func_187214_a(KITTENS, (Object)0);
        this.field_70180_af.func_187214_a(MOTHER, Optional.empty());
        this.field_70180_af.func_187214_a(FATHER, Optional.empty());
        this.field_70180_af.func_187214_a(AGE_TRACKER, (Object)0);
        this.field_70180_af.func_187214_a(MATURE_TIMER, (Object)Float.valueOf(168000.0f));
    }

    protected void func_70619_bc() {
        if (this.func_70605_aq().func_75640_a()) {
            double d0 = this.func_70605_aq().func_75638_b();
            if (d0 == 0.6) {
                this.func_213301_b(Pose.CROUCHING);
                this.func_70031_b(false);
            } else if (d0 == 1.33) {
                this.func_213301_b(Pose.STANDING);
                this.func_70031_b(true);
            } else {
                this.func_213301_b(Pose.STANDING);
                this.func_70031_b(false);
            }
        } else {
            this.func_213301_b(Pose.STANDING);
            this.func_70031_b(false);
        }
    }

    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason spawnReason, @Nullable ILivingEntityData entityData, @Nullable CompoundNBT compound) {
        entityData = super.func_213386_a(world, difficulty, spawnReason, entityData, compound);
        this.setPhenotype();
        if (!this.field_70170_p.field_72995_K && this.func_70909_n()) {
            this.func_233687_w_(!this.func_233685_eM_());
        }
        if (this.getSex() == Genetics.Sex.FEMALE && !this.isFixed()) {
            this.setTimeCycle("end", this.field_70146_Z.nextInt((Integer)SCConfig.Common.heat_cooldown.get()));
        }
        return entityData;
    }

    public float func_213355_cm() {
        return this.func_70631_g_() ? 0.7f : 1.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getNearestLaser() != null) {
            if (this.func_233685_eM_()) {
                this.func_233687_w_(false);
            }
            this.func_70661_as().func_75492_a(this.getNearestLaser().field_72450_a, this.getNearestLaser().field_72448_b, this.getNearestLaser().field_72449_c, 1.2);
            this.func_70671_ap().func_75650_a(this.getNearestLaser().field_72450_a, this.getNearestLaser().field_72448_b, this.getNearestLaser().field_72449_c, 10.0f, (float)this.func_213396_dB());
        }
        if (!(this.field_70170_p.field_72995_K || this.func_70631_g_() || this.isFixed() || this.getSex() != Genetics.Sex.FEMALE)) {
            if (this.getBreedingStatus("inheat") && this.getMateTimer() <= 0) {
                if (!this.getBreedingStatus("ispregnant")) {
                    this.setTimeCycle("end", (Integer)SCConfig.Common.heat_cooldown.get());
                } else {
                    this.setTimeCycle("pregnant", (Integer)SCConfig.Common.pregnancy_timer.get());
                    this.setBreedingStatus("inheat", false);
                }
            }
            if (!this.getBreedingStatus("inheat") && this.getMateTimer() >= 0 && !this.getBreedingStatus("ispregnant")) {
                this.setTimeCycle("start", (Integer)SCConfig.Common.heat_timer.get());
            }
        }
        if (this.field_70173_aa % 40 == 0 && !this.field_70170_p.field_72995_K && this.func_70902_q() != null) {
            this.setOwnerName(this.func_70902_q().func_145748_c_().getString());
        }
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.resetTexturePrefix();
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.func_70631_g_() && !this.isFixed()) {
            int mateTimer = this.getMateTimer();
            if (this.getSex() == Genetics.Sex.FEMALE) {
                if (this.getBreedingStatus("inheat") || this.getBreedingStatus("ispregnant")) {
                    if (this.getBreedingStatus("inheat") && --mateTimer % 10 == 0) {
                        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
                    }
                } else if (!this.getBreedingStatus("inheat") && !this.getBreedingStatus("ispregnant")) {
                    ++mateTimer;
                }
            } else if (this.getSex() == Genetics.Sex.MALE) {
                if (mateTimer > 0) {
                    --mateTimer;
                } else if (mateTimer <= 0) {
                    mateTimer = 0;
                }
            }
            this.setMateTimer(mateTimer);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.isAngry()) {
            this.setAngry(false);
        }
        if (this.func_110143_aJ() <= 0.0f && this.func_70909_n() && this.func_70902_q() == null) {
            this.field_70725_aQ = 0;
            this.func_70606_j(1.0f);
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source) || this.func_70909_n() && this.func_70902_q() == null) {
            return false;
        }
        this.func_233687_w_(false);
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entity) {
        float damage = (int)this.func_233637_b_(Attributes.field_233823_f_);
        if (SCEvents.isRatEntity(entity)) {
            damage *= 3.0f;
        }
        if (this.func_213453_ef() || this.func_70051_ag()) {
            damage *= 2.0f;
        }
        return entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage);
    }

    public void func_70624_b(@Nullable LivingEntity entity) {
        super.func_70624_b(entity);
        if (entity == null) {
            this.setAngry(false);
        } else if (!this.func_70909_n()) {
            this.setAngry(true);
        }
    }

    public Team func_96124_cp() {
        return super.func_96124_cp();
    }

    public boolean func_184191_r(Entity entity) {
        TameableEntity tameable;
        if (entity instanceof TameableEntity && (tameable = (TameableEntity)entity).func_70909_n() && tameable.func_184753_b() != null && this.func_70909_n() && this.func_184753_b() != null && this.func_184753_b().equals(tameable.func_184753_b())) {
            return true;
        }
        return super.func_184191_r(entity);
    }

    public void setPhenotype() {
        this.setGenotype(FUR_LENGTH, Genetics.FurLength.init(this.field_70146_Z) + "-" + Genetics.FurLength.init(this.field_70146_Z));
        this.setGenotype(EUMELANIN, Genetics.Eumelanin.init(this.field_70146_Z) + "-" + Genetics.Eumelanin.init(this.field_70146_Z));
        this.setGenotype(PHAEOMELANIN, Genetics.Phaeomelanin.init(this.field_70146_Z));
        this.setGenotype(DILUTION, Genetics.Dilution.init(this.field_70146_Z) + "-" + Genetics.Dilution.init(this.field_70146_Z));
        this.setGenotype(DILUTE_MOD, Genetics.DiluteMod.init(this.field_70146_Z) + "-" + Genetics.DiluteMod.init(this.field_70146_Z));
        this.setGenotype(AGOUTI, Genetics.Agouti.init(this.field_70146_Z) + "-" + Genetics.Agouti.init(this.field_70146_Z));
        this.setGenotype(TABBY, Genetics.Tabby.init(this.field_70146_Z) + "-" + Genetics.Tabby.init(this.field_70146_Z));
        this.setGenotype(SPOTTED, Genetics.Spotted.init(this.field_70146_Z) + "-" + Genetics.Spotted.init(this.field_70146_Z));
        this.setGenotype(TICKED, Genetics.Ticked.init(this.field_70146_Z) + "-" + Genetics.Ticked.init(this.field_70146_Z));
        this.setGenotype(COLORPOINT, Genetics.Colorpoint.init(this.field_70146_Z) + "-" + Genetics.Colorpoint.init(this.field_70146_Z));
        this.setGenotype(WHITE, Genetics.White.init(this.field_70146_Z) + "-" + Genetics.White.init(this.field_70146_Z));
        this.setGenotype(BOBTAIL, Genetics.Bobtail.init(this.field_70146_Z) + "-" + Genetics.Bobtail.init(this.field_70146_Z));
        this.selectWhiteMarkings();
        this.setGenotype(EYE_COLOR, this.selectEyeColor());
    }

    private String selectEyeColor() {
        String color = Genetics.EyeColor.init(this.field_70146_Z.nextInt(4));
        if (this.getGenotype(WHITE).contains(Genetics.White.DOMINANT.getAllele())) {
            color = Genetics.EyeColor.init(this.field_70146_Z.nextInt(5));
        }
        if (Genetics.Colorpoint.getPhenotype(this.getGenotype(COLORPOINT)).equalsIgnoreCase(Genetics.Colorpoint.COLORPOINT.toString())) {
            color = Genetics.EyeColor.init(4);
        }
        return color;
    }

    void selectWhiteMarkings() {
        int base;
        int body = 0;
        int face = 0;
        int tail = 0;
        for (int j = 0; j <= 3; ++j) {
            this.whitePawTexturesArray[j] = "";
            this.setWhitePawTextures(j, "");
        }
        switch (this.getGenotype(WHITE)) {
            case "Wd-Wd": 
            case "Wd-w": 
            case "Wd-Ws": 
            case "w-Wd": 
            case "Ws-Wd": {
                base = 6;
                body = 1;
                face = 0;
                tail = 0;
                break;
            }
            default: {
                base = 0;
                body = 0;
                face = 0;
                tail = 0;
                break;
            }
            case "Ws-Ws": {
                base = this.field_70146_Z.nextInt(2) + 4;
                if (base == 5) {
                    body = this.field_70146_Z.nextInt(4) + 1;
                    face = this.field_70146_Z.nextInt(6) + 1;
                    if (body > 1) {
                        tail = this.field_70146_Z.nextInt(3) + 1;
                    }
                } else if (base == 4) {
                    body = 1;
                    face = this.field_70146_Z.nextInt(5) + 1;
                }
                if (this.field_70146_Z.nextInt(10) != 0) break;
                base = 6;
                body = 1;
                face = 0;
                tail = 0;
                break;
            }
            case "Ws-w": 
            case "w-Ws": {
                base = this.field_70146_Z.nextInt(3) + 1;
                body = 1;
                if (base == 2 || base == 3) {
                    this.selectWhitePaws(base);
                }
                if (base != 3) break;
                face = this.field_70146_Z.nextInt(5) + 1;
            }
        }
        this.whiteTexturesArray[0] = body == 0 ? "" : "white_" + base + "_body" + body;
        this.setWhiteTextures(0, this.whiteTexturesArray[0]);
        this.whiteTexturesArray[1] = face == 0 ? "" : "white_" + (base == 3 || base == 4 ? 34 : base) + "_face" + face;
        this.setWhiteTextures(1, this.whiteTexturesArray[1]);
        this.whiteTexturesArray[2] = tail == 0 ? "" : "white_" + base + "_tail" + tail;
        this.setWhiteTextures(2, this.whiteTexturesArray[2]);
    }

    private void selectWhitePaws(int base) {
        boolean all;
        boolean bl = all = this.field_70146_Z.nextInt(4) <= 2;
        if (all || this.field_70146_Z.nextInt(4) <= 2) {
            this.whitePawTexturesArray[0] = "white_" + base + "_paw1";
            this.setWhitePawTextures(0, this.whitePawTexturesArray[0]);
        }
        if (all || this.field_70146_Z.nextInt(4) <= 2) {
            this.whitePawTexturesArray[1] = "white_" + base + "_paw2";
            this.setWhitePawTextures(1, this.whitePawTexturesArray[1]);
        }
        if (all || this.field_70146_Z.nextInt(4) <= 2) {
            this.whitePawTexturesArray[2] = "white_" + base + "_paw3";
            this.setWhitePawTextures(2, this.whitePawTexturesArray[2]);
        }
        if (all || this.field_70146_Z.nextInt(4) <= 2) {
            this.whitePawTexturesArray[3] = "white_" + base + "_paw4";
            this.setWhitePawTextures(3, this.whitePawTexturesArray[3]);
        }
    }

    private String getWhiteTextures(int i) {
        switch (i) {
            case 0: {
                if (((String)this.field_70180_af.func_187225_a(WHITE_0)).isEmpty() && !this.getGenotype(WHITE).equals("w-w")) {
                    this.selectWhiteMarkings();
                }
                return (String)this.field_70180_af.func_187225_a(WHITE_0);
            }
            case 1: {
                return (String)this.field_70180_af.func_187225_a(WHITE_1);
            }
            case 2: {
                return (String)this.field_70180_af.func_187225_a(WHITE_2);
            }
        }
        return "";
    }

    private void setWhiteTextures(int i, String value) {
        switch (i) {
            case 0: {
                this.field_70180_af.func_187227_b(WHITE_0, (Object)value);
                break;
            }
            case 1: {
                this.field_70180_af.func_187227_b(WHITE_1, (Object)value);
                break;
            }
            case 2: {
                this.field_70180_af.func_187227_b(WHITE_2, (Object)value);
            }
        }
    }

    private String getWhitePawTextures(int i) {
        switch (i) {
            case 0: {
                return (String)this.field_70180_af.func_187225_a(WHITE_PAWS_0);
            }
            case 1: {
                return (String)this.field_70180_af.func_187225_a(WHITE_PAWS_1);
            }
            case 2: {
                return (String)this.field_70180_af.func_187225_a(WHITE_PAWS_2);
            }
            case 3: {
                return (String)this.field_70180_af.func_187225_a(WHITE_PAWS_3);
            }
        }
        return "";
    }

    private void setWhitePawTextures(int i, String value) {
        switch (i) {
            case 0: {
                this.field_70180_af.func_187227_b(WHITE_PAWS_0, (Object)value);
                break;
            }
            case 1: {
                this.field_70180_af.func_187227_b(WHITE_PAWS_1, (Object)value);
                break;
            }
            case 2: {
                this.field_70180_af.func_187227_b(WHITE_PAWS_2, (Object)value);
                break;
            }
            case 3: {
                this.field_70180_af.func_187227_b(WHITE_PAWS_3, (Object)value);
            }
        }
    }

    protected String getGenotype(DataParameter<String> parameter) {
        if (((String)this.field_70180_af.func_187225_a(parameter)).isEmpty()) {
            this.fixEmptyGenes(parameter);
        }
        return (String)this.field_70180_af.func_187225_a(parameter);
    }

    void setGenotype(DataParameter<String> parameter, String value) {
        this.field_70180_af.func_187227_b(parameter, (Object)value);
    }

    private void fixEmptyGenes(DataParameter<String> dataParameter) {
        if (dataParameter == FUR_LENGTH) {
            this.setGenotype(FUR_LENGTH, "L-L");
        } else if (dataParameter == EUMELANIN) {
            this.setGenotype(EUMELANIN, "B-B");
        } else if (dataParameter == PHAEOMELANIN) {
            this.setGenotype(PHAEOMELANIN, "Xo-" + (this.field_70146_Z.nextBoolean() ? Genetics.Phaeomelanin.NOT_RED.getAllele() : Genetics.Phaeomelanin.MALE.getAllele()));
        } else if (dataParameter == DILUTION) {
            this.setGenotype(DILUTION, "D-D");
        } else if (dataParameter == DILUTE_MOD) {
            this.setGenotype(DILUTE_MOD, "dm-dm");
        } else if (dataParameter == AGOUTI) {
            this.setGenotype(AGOUTI, "a-a");
        } else if (dataParameter == TABBY) {
            this.setGenotype(TABBY, "Mc-Mc");
        } else if (dataParameter == SPOTTED) {
            this.setGenotype(SPOTTED, "sp-sp");
        } else if (dataParameter == TICKED) {
            this.setGenotype(TICKED, "ta-ta");
        } else if (dataParameter == COLORPOINT) {
            this.setGenotype(COLORPOINT, "C-C");
        } else if (dataParameter == WHITE) {
            this.setGenotype(WHITE, "w-w");
        } else if (dataParameter == BOBTAIL) {
            this.setGenotype(BOBTAIL, "Jb-Jb");
        } else {
            this.setGenotype(EYE_COLOR, this.selectEyeColor());
        }
    }

    public Genetics.Sex getSex() {
        String phaeomelanin = (String)this.field_70180_af.func_187225_a(PHAEOMELANIN);
        return !phaeomelanin.isEmpty() && phaeomelanin.contains(Genetics.Phaeomelanin.MALE.getAllele()) ? Genetics.Sex.MALE : Genetics.Sex.FEMALE;
    }

    public boolean isBobtail() {
        String bobtail = (String)this.field_70180_af.func_187225_a(BOBTAIL);
        return !bobtail.isEmpty() && Genetics.Bobtail.isBobtail(bobtail);
    }

    public boolean isLongFur() {
        String furLength = (String)this.field_70180_af.func_187225_a(FUR_LENGTH);
        return !furLength.isEmpty() && Genetics.FurLength.getPhenotype(furLength).equalsIgnoreCase(Genetics.FurLength.LONG.toString());
    }

    public Optional<BlockPos> getHomePos() {
        return (Optional)this.field_70180_af.func_187225_a(HOME_POSITION);
    }

    public void setHomePos(BlockPos position) {
        this.field_70180_af.func_187227_b(HOME_POSITION, Optional.of(position));
    }

    public void resetHomePos() {
        this.field_70180_af.func_187227_b(HOME_POSITION, Optional.empty());
    }

    public ITextComponent getOwnerName() {
        if (this.func_70902_q() != null) {
            return this.func_70902_q().func_145748_c_();
        }
        if (!((String)this.field_70180_af.func_187225_a(OWNER_NAME)).isEmpty()) {
            return new StringTextComponent((String)this.field_70180_af.func_187225_a(OWNER_NAME));
        }
        if (this.func_184753_b() != null) {
            return new TranslationTextComponent("entity.simplycats.cat.unknown_owner");
        }
        return new TranslationTextComponent("entity.simplycats.cat.untamed");
    }

    public void setOwnerName(String name) {
        this.field_70180_af.func_187227_b(OWNER_NAME, (Object)name);
    }

    public void onBagShake(PlayerEntity player) {
        if (!this.func_70909_n() || this.func_70902_q() == player && !this.func_233685_eM_()) {
            this.func_70671_ap().func_75651_a((Entity)player, 10.0f, (float)this.func_213396_dB());
            this.func_70661_as().func_75497_a((Entity)player, 1.8);
        }
    }

    public Vector3d getNearestLaser() {
        return this.nearestLaser;
    }

    public void setNearestLaser(Vector3d vec) {
        this.nearestLaser = vec;
        if (vec == null) {
            this.func_70661_as().func_75499_g();
        }
    }

    public final float getAgeScale() {
        return (float)this.getAgeTracker() / this.getMatureTimer() + 1.0f;
    }

    public float getMatureTimer() {
        return ((Float)this.field_70180_af.func_187225_a(MATURE_TIMER)).floatValue();
    }

    public void setMatureTimer(float maxAge) {
        this.field_70180_af.func_187227_b(MATURE_TIMER, (Object)Float.valueOf(maxAge));
    }

    public int getAgeTracker() {
        return (Integer)this.field_70180_af.func_187225_a(AGE_TRACKER);
    }

    public void func_70873_a(int age) {
        this.field_70180_af.func_187227_b(AGE_TRACKER, (Object)age);
        super.func_70873_a(age);
    }

    public SimplyCatEntity getFollowParent() {
        return this.followParent;
    }

    public void setFollowParent(SimplyCatEntity followParent) {
        this.followParent = followParent;
    }

    public void setMother(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(MOTHER, Optional.ofNullable(uuid));
    }

    public UUID getMother() {
        return ((Optional)this.field_70180_af.func_187225_a(MOTHER)).orElse(null);
    }

    public void setFather(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(FATHER, Optional.ofNullable(uuid));
    }

    public UUID getFather() {
        return ((Optional)this.field_70180_af.func_187225_a(FATHER)).orElse(null);
    }

    public void setFixed(byte fixed) {
        this.field_70180_af.func_187227_b(FIXED, (Object)fixed);
    }

    public boolean isFixed() {
        return (Byte)this.field_70180_af.func_187225_a(FIXED) == 1;
    }

    public byte getIsFixed() {
        return (Byte)this.field_70180_af.func_187225_a(FIXED);
    }

    public void setTimeCycle(String s, int time) {
        if (s.equals("start")) {
            this.setBreedingStatus("inheat", true);
            this.setMateTimer(time);
        }
        if (s.equals("end")) {
            this.setBreedingStatus("inheat", false);
            this.setMateTimer(-time);
        }
        if (s.equals("pregnancy")) {
            this.setMateTimer(time);
        }
    }

    public void setBreedingStatus(String string, boolean parTrue) {
        if (string.equals("inheat")) {
            if (parTrue) {
                this.field_70180_af.func_187227_b(IN_HEAT, (Object)1);
            } else {
                this.field_70180_af.func_187227_b(IN_HEAT, (Object)0);
            }
        } else if (string.equals("ispregnant")) {
            if (parTrue) {
                this.field_70180_af.func_187227_b(IS_PREGNANT, (Object)1);
            } else {
                this.field_70180_af.func_187227_b(IS_PREGNANT, (Object)0);
            }
        }
    }

    public boolean getBreedingStatus(String string) {
        if (string.equals("inheat")) {
            return (Byte)this.field_70180_af.func_187225_a(IN_HEAT) == 1;
        }
        if (string.equals("ispregnant")) {
            return (Byte)this.field_70180_af.func_187225_a(IS_PREGNANT) == 1;
        }
        return false;
    }

    public void setMateTimer(int time) {
        this.field_70180_af.func_187227_b(MATE_TIMER, (Object)time);
    }

    public int getMateTimer() {
        return (Integer)this.field_70180_af.func_187225_a(MATE_TIMER);
    }

    public void setKittens(int kittens) {
        if (this.getKittens() <= 0 || kittens == 0) {
            this.field_70180_af.func_187227_b(KITTENS, (Object)kittens);
        } else if (this.getKittens() > 0) {
            this.field_70180_af.func_187227_b(KITTENS, (Object)(this.getKittens() + kittens));
        }
    }

    public int getKittens() {
        return (Integer)this.field_70180_af.func_187225_a(KITTENS);
    }

    public void addFather(SimplyCatEntity father, int size) {
        for (int i = 0; i < size; ++i) {
            if (this.getPersistentData().func_74764_b("Father" + i) && (!this.getPersistentData().func_74764_b("Father" + i) || !this.getPersistentData().func_74775_l("Father" + i).isEmpty())) continue;
            this.getPersistentData().func_218657_a("Father" + i, (INBT)father.func_189511_e(new CompoundNBT()));
        }
    }

    private void setFather(int i, INBT father) {
        if (this.getPersistentData().func_74764_b("Father" + i)) {
            this.getPersistentData().func_218657_a("Father" + i, father);
        }
    }

    public CompoundNBT getFather(int i) {
        return this.getPersistentData().func_74775_l("Father" + i);
    }

    public void func_213281_b(CompoundNBT compound) {
        int i;
        super.func_213281_b(compound);
        compound.func_74778_a("EyeColor", this.getGenotype(EYE_COLOR));
        compound.func_74778_a("FurLength", this.getGenotype(FUR_LENGTH));
        compound.func_74778_a("Eumelanin", this.getGenotype(EUMELANIN));
        compound.func_74778_a("Phaeomelanin", this.getGenotype(PHAEOMELANIN));
        compound.func_74778_a("Dilution", this.getGenotype(DILUTION));
        compound.func_74778_a("DiluteMod", this.getGenotype(DILUTE_MOD));
        compound.func_74778_a("Agouti", this.getGenotype(AGOUTI));
        compound.func_74778_a("Tabby", this.getGenotype(TABBY));
        compound.func_74778_a("Spotted", this.getGenotype(SPOTTED));
        compound.func_74778_a("Ticked", this.getGenotype(TICKED));
        compound.func_74778_a("Colorpoint", this.getGenotype(COLORPOINT));
        compound.func_74778_a("White", this.getGenotype(WHITE));
        compound.func_74778_a("Bobtail", this.getGenotype(BOBTAIL));
        for (i = 0; i <= 2; ++i) {
            compound.func_74778_a("White_" + i, this.getWhiteTextures(i));
        }
        for (i = 0; i <= 3; ++i) {
            compound.func_74778_a("WhitePaws_" + i, this.getWhitePawTextures(i));
        }
        compound.func_74778_a("OwnerName", (String)this.field_70180_af.func_187225_a(OWNER_NAME));
        compound.func_74774_a("Fixed", this.getIsFixed());
        if (this.getSex() == Genetics.Sex.FEMALE) {
            compound.func_74757_a("InHeat", this.getBreedingStatus("inheat"));
            compound.func_74757_a("IsPregnant", this.getBreedingStatus("ispregnant"));
            compound.func_74768_a("Kittens", this.getKittens());
            for (i = 0; i < 5; ++i) {
                compound.func_218657_a("Father" + i, (INBT)this.getFather(i));
            }
        }
        compound.func_74768_a("Timer", this.getMateTimer());
        if (this.getMother() == null) {
            compound.func_74778_a("Mother", "");
        } else {
            compound.func_74778_a("Mother", this.getMother().toString());
        }
        if (this.getFather() == null) {
            compound.func_74778_a("Father", "");
        } else {
            compound.func_74778_a("Father", this.getFather().toString());
        }
        if (this.func_70631_g_()) {
            compound.func_74768_a("AgeTracker", this.getAgeTracker());
            compound.func_74776_a("MatureTimer", this.getMatureTimer());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        String s;
        int i;
        super.func_70037_a(compound);
        this.setGenotype(EYE_COLOR, compound.func_74779_i("EyeColor"));
        this.setGenotype(FUR_LENGTH, compound.func_74779_i("FurLength"));
        this.setGenotype(EUMELANIN, compound.func_74779_i("Eumelanin"));
        this.setGenotype(PHAEOMELANIN, compound.func_74779_i("Phaeomelanin"));
        this.setGenotype(DILUTION, compound.func_74779_i("Dilution"));
        this.setGenotype(DILUTE_MOD, compound.func_74779_i("DiluteMod"));
        this.setGenotype(AGOUTI, compound.func_74779_i("Agouti"));
        this.setGenotype(TABBY, compound.func_74779_i("Tabby"));
        this.setGenotype(SPOTTED, compound.func_74779_i("Spotted"));
        this.setGenotype(TICKED, compound.func_74779_i("Ticked"));
        this.setGenotype(COLORPOINT, compound.func_74779_i("Colorpoint"));
        this.setGenotype(WHITE, compound.func_74779_i("White"));
        this.setGenotype(BOBTAIL, compound.func_74779_i("Bobtail"));
        for (i = 0; i <= 2; ++i) {
            this.setWhiteTextures(i, compound.func_74779_i("White_" + i));
        }
        for (i = 0; i <= 3; ++i) {
            this.setWhitePawTextures(i, compound.func_74779_i("WhitePaws_" + i));
        }
        this.setOwnerName(compound.func_74779_i("OwnerName"));
        this.setFixed(compound.func_74771_c("Fixed"));
        if (this.getSex() == Genetics.Sex.FEMALE && !this.isFixed()) {
            this.setBreedingStatus("inheat", compound.func_74767_n("InHeat"));
            this.setBreedingStatus("ispregnant", compound.func_74767_n("IsPregnant"));
            this.setKittens(compound.func_74762_e("Kittens"));
            for (i = 0; i < 5; ++i) {
                this.setFather(i, compound.func_74781_a("Father" + i));
            }
        }
        if (!this.isFixed()) {
            this.setMateTimer(compound.func_74762_e("Timer"));
        }
        if (compound.func_150297_b("Mother", 8) && !(s = compound.func_74779_i("Mother")).isEmpty()) {
            this.setMother(UUID.fromString(s));
        }
        if (compound.func_150297_b("Father", 8) && !(s = compound.func_74779_i("Father")).isEmpty()) {
            this.setFather(UUID.fromString(s));
        }
        if (this.func_70631_g_()) {
            this.func_70873_a(compound.func_74762_e("AgeTracker"));
            this.setMatureTimer(compound.func_74760_g("MatureTimer"));
        }
    }

    private void resetTexturePrefix() {
        this.texturePrefix = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setCatTexturePaths() {
        String solid = Genetics.Eumelanin.getPhenotype(this.getGenotype(EUMELANIN));
        if (Genetics.Phaeomelanin.getPhenotype(this.getGenotype(PHAEOMELANIN)).equalsIgnoreCase(Genetics.Phaeomelanin.RED.toString().toLowerCase())) {
            solid = Genetics.Phaeomelanin.getPhenotype(this.getGenotype(PHAEOMELANIN));
        }
        if (Genetics.Dilution.getPhenotype(this.getGenotype(DILUTION)).equalsIgnoreCase(Genetics.Dilution.DILUTE.toString().toLowerCase())) {
            solid = solid + "_" + Genetics.Dilution.getPhenotype(this.getGenotype(DILUTION));
            if (Genetics.DiluteMod.getPhenotype(this.getGenotype(DILUTE_MOD)).equalsIgnoreCase(Genetics.DiluteMod.CARAMELIZED.toString().toLowerCase())) {
                solid = solid + "_" + Genetics.DiluteMod.getPhenotype(this.getGenotype(DILUTE_MOD));
            }
        }
        String tabby = Genetics.Tabby.getPhenotype(this.getGenotype(TABBY)) + "_" + solid;
        if (this.getGenotype(SPOTTED).contains(Genetics.Spotted.SPOTTED.getAllele())) {
            tabby = Genetics.Spotted.getPhenotype(this.getGenotype(SPOTTED)) + "_" + tabby;
        }
        if (Genetics.Ticked.getPhenotype(this.getGenotype(TICKED)).equalsIgnoreCase(Genetics.Ticked.TICKED.toString().toLowerCase())) {
            tabby = Genetics.Ticked.getPhenotype(this.getGenotype(TICKED)) + (this.getGenotype(TICKED).contains(Genetics.Ticked.NON_TICKED.getAllele()) ? "_residual" : "") + "_" + solid;
        }
        String tortie = "";
        if (Genetics.Phaeomelanin.getPhenotype(this.getGenotype(PHAEOMELANIN)).equalsIgnoreCase(Genetics.Phaeomelanin.TORTOISESHELL.toString().toLowerCase())) {
            tortie = Genetics.Phaeomelanin.getPhenotype(this.getGenotype(PHAEOMELANIN)) + "_" + tabby.replace("_" + solid, "");
            if (Genetics.Dilution.getPhenotype(this.getGenotype(DILUTION)).equalsIgnoreCase(Genetics.Dilution.DILUTE.toString().toLowerCase())) {
                tortie = tortie + "_" + Genetics.Dilution.getPhenotype(this.getGenotype(DILUTION));
                if (Genetics.DiluteMod.getPhenotype(this.getGenotype(DILUTE_MOD)).equalsIgnoreCase(Genetics.DiluteMod.CARAMELIZED.toString().toLowerCase())) {
                    tortie = tortie + "_" + Genetics.DiluteMod.getPhenotype(this.getGenotype(DILUTE_MOD));
                }
            }
        }
        if (!Genetics.Phaeomelanin.getPhenotype(this.getGenotype(PHAEOMELANIN)).equalsIgnoreCase(Genetics.Phaeomelanin.RED.toString()) && Genetics.Agouti.getPhenotype(this.getGenotype(AGOUTI)).equalsIgnoreCase(Genetics.Agouti.SOLID.toString().toLowerCase())) {
            tabby = "";
        }
        String colorpoint = "";
        if (!Genetics.Colorpoint.getPhenotype(this.getGenotype(COLORPOINT)).equalsIgnoreCase(Genetics.Colorpoint.NOT_POINTED.toString().toLowerCase())) {
            colorpoint = Genetics.Colorpoint.getPhenotype(this.getGenotype(COLORPOINT));
            if (!tabby.equals("") && !Genetics.Phaeomelanin.getPhenotype(this.getGenotype(PHAEOMELANIN)).equalsIgnoreCase(Genetics.Phaeomelanin.RED.toString())) {
                colorpoint = colorpoint + "_tabby";
            } else if (solid.equalsIgnoreCase(Genetics.Eumelanin.BLACK.toString())) {
                colorpoint = colorpoint + "_" + solid;
            } else if (Genetics.Phaeomelanin.getPhenotype(this.getGenotype(PHAEOMELANIN)).equalsIgnoreCase(Genetics.Phaeomelanin.RED.toString())) {
                colorpoint = colorpoint + "_red";
            }
            if (!tortie.equals("")) {
                tortie = tortie + "_point";
            }
        }
        this.catTexturesArray[0] = "simplycats:textures/entity/cat/solid/" + solid + ".png";
        this.catTexturesArray[1] = tabby.equals("") ? null : "simplycats:textures/entity/cat/tabby/" + tabby + ".png";
        this.catTexturesArray[2] = tortie.equals("") ? null : "simplycats:textures/entity/cat/tortie/" + tortie + ".png";
        this.catTexturesArray[3] = colorpoint.equals("") ? null : "simplycats:textures/entity/cat/colorpoint/" + colorpoint + ".png";
        this.catTexturesArray[4] = this.getWhiteTextures(0).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhiteTextures(0) + ".png";
        this.catTexturesArray[5] = this.getWhiteTextures(1).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhiteTextures(1) + ".png";
        this.catTexturesArray[6] = this.getWhiteTextures(2).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhiteTextures(2) + ".png";
        this.catTexturesArray[7] = this.getWhitePawTextures(0).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhitePawTextures(0) + ".png";
        this.catTexturesArray[8] = this.getWhitePawTextures(1).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhitePawTextures(1) + ".png";
        this.catTexturesArray[9] = this.getWhitePawTextures(2).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhitePawTextures(2) + ".png";
        this.catTexturesArray[10] = this.getWhitePawTextures(3).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhitePawTextures(3) + ".png";
        this.catTexturesArray[11] = "simplycats:textures/entity/cat/eyes/" + Genetics.EyeColor.getPhenotype(this.getGenotype(EYE_COLOR)) + ".png";
        this.texturePrefix = "cat/" + solid + tabby + tortie + colorpoint + this.getWhiteTextures(0) + this.getWhiteTextures(1) + this.getWhiteTextures(2) + this.getWhitePawTextures(0) + this.getWhitePawTextures(1) + this.getWhitePawTextures(2) + this.getWhitePawTextures(3) + Genetics.EyeColor.getPhenotype(this.getGenotype(EYE_COLOR));
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getCatTexture() {
        if (this.texturePrefix == null) {
            this.setCatTexturePaths();
        }
        return this.texturePrefix;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String[] getTexturePaths() {
        if (this.texturePrefix == null) {
            this.setCatTexturePaths();
        }
        return this.catTexturesArray;
    }

    public boolean canBeTamed(PlayerEntity player) {
        return ((Integer)SCConfig.Common.tamed_limit.get() == 0 || player.getPersistentData().func_74762_e("CatCount") < (Integer)SCConfig.Common.tamed_limit.get()) && !this.func_70909_n();
    }

    public void setTamed(boolean tamed, PlayerEntity owner) {
        this.func_70903_f(tamed);
        int catCount = owner.getPersistentData().func_74762_e("CatCount");
        if (tamed) {
            this.setOwnerName(owner.func_145748_c_().getString());
            this.func_184754_b(owner.func_110124_au());
            if (owner instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193136_w.func_193178_a((ServerPlayerEntity)owner, (AnimalEntity)this);
            }
        } else {
            this.setOwnerName("");
        }
    }

    public boolean func_70878_b(AnimalEntity target) {
        if (target == this) {
            return false;
        }
        if (!(target instanceof SimplyCatEntity)) {
            return false;
        }
        if (target.func_70631_g_() || this.func_70631_g_()) {
            return false;
        }
        if (this.func_233685_eM_() || ((SimplyCatEntity)target).func_233685_eM_()) {
            return false;
        }
        SimplyCatEntity mate = (SimplyCatEntity)target;
        if (mate.isFixed() || this.isFixed()) {
            return false;
        }
        if (this.getSex() == Genetics.Sex.MALE && this.getMateTimer() == 0) {
            return mate.getSex() == Genetics.Sex.FEMALE && mate.getBreedingStatus("inheat");
        }
        return false;
    }

    public boolean func_70877_b(ItemStack item) {
        return SCReference.catFoodItems(item);
    }

    private String inheritGene(String motherAlleles, String fatherAlleles) {
        if (motherAlleles.isEmpty()) {
            return "";
        }
        if (fatherAlleles.isEmpty()) {
            return "";
        }
        String[] maternal = motherAlleles.split("-");
        String[] paternal = fatherAlleles.split("-");
        return maternal[this.field_70146_Z.nextInt(2)] + "-" + paternal[this.field_70146_Z.nextInt(2)];
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity parFather) {
        PlayerEntity owner;
        int eyesMax;
        int eyesMin;
        int patEye;
        EntityDataManager father = parFather.func_184212_Q();
        EntityDataManager mother = this.func_184212_Q();
        SimplyCatEntity child = (SimplyCatEntity)((EntityType)SimplyCats.CAT.get()).func_200721_a(this.field_70170_p);
        ImmutableList parameters = ImmutableList.of(FUR_LENGTH, EUMELANIN, PHAEOMELANIN, DILUTION, DILUTE_MOD, AGOUTI, TABBY, SPOTTED, TICKED, COLORPOINT, WHITE, BOBTAIL, (Object[])new DataParameter[0]);
        for (DataParameter geneParameter : parameters) {
            String inherited = this.inheritGene((String)mother.func_187225_a(geneParameter), (String)father.func_187225_a(geneParameter));
            child.setGenotype((DataParameter<String>)geneParameter, inherited);
        }
        child.selectWhiteMarkings();
        int matEye = !((String)mother.func_187225_a(EYE_COLOR)).isEmpty() ? Genetics.EyeColor.valueOf(((String)mother.func_187225_a(EYE_COLOR)).toUpperCase()).ordinal() : 2;
        int n = patEye = !((String)father.func_187225_a(EYE_COLOR)).isEmpty() ? Genetics.EyeColor.valueOf(((String)father.func_187225_a(EYE_COLOR)).toUpperCase()).ordinal() : 2;
        if (matEye > patEye) {
            eyesMin = patEye - 1;
            eyesMax = matEye;
        } else {
            eyesMin = matEye - 1;
            eyesMax = patEye;
        }
        eyesMin = eyesMin < 0 ? 0 : eyesMin;
        String white = child.getGenotype(WHITE);
        eyesMax = white.contains(Genetics.White.DOMINANT.getAllele()) ? 4 : (eyesMax >= 4 ? (eyesMin < 3 ? eyesMin + 1 : 3) : eyesMax);
        int eyes = this.field_70146_Z.nextInt(eyesMax - eyesMin + 1) + eyesMin;
        String eye = Genetics.EyeColor.init(matEye == 4 && patEye == 4 ? (eyesMax == 4 ? 4 : this.field_70146_Z.nextInt(4)) : eyes);
        String point = child.getGenotype(COLORPOINT);
        if (point.contentEquals(Genetics.Colorpoint.COLORPOINT.getAllele() + "-" + Genetics.Colorpoint.COLORPOINT.getAllele())) {
            eye = Genetics.EyeColor.init(4);
        }
        child.setGenotype(EYE_COLOR, eye);
        if (this.func_70909_n() && this.func_184753_b() != null && (owner = this.field_70170_p.func_217371_b(this.func_184753_b())) != null && child.canBeTamed(owner)) {
            child.setTamed(this.func_70909_n(), owner);
            if (this.getHomePos().isPresent()) {
                child.setHomePos(this.getHomePos().get());
            }
        }
        return child;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (this.field_70170_p.field_72995_K) {
            if (this.func_70909_n() && this.func_152114_e((LivingEntity)player)) {
                return ActionResultType.SUCCESS;
            }
            if (item == Items.field_151103_aS || item == SCItems.TREAT_BAG.get() && !this.func_70909_n()) {
                return ActionResultType.SUCCESS;
            }
            return !this.func_70877_b(stack) || !(this.func_110143_aJ() < this.func_110138_aP()) && this.func_70909_n() ? ActionResultType.PASS : ActionResultType.SUCCESS;
        }
        if (!stack.func_190926_b()) {
            if (item == Items.field_151065_br && player.func_226273_bm_() && this.func_70909_n() && this.func_152114_e((LivingEntity)player)) {
                if (this.func_70631_g_()) {
                    this.func_175505_a(player, stack);
                    this.func_175501_a((int)((float)(-this.func_70874_b() / 20) * 0.8f), true);
                } else if (!this.isFixed() && this.getMateTimer() != 0) {
                    this.func_175505_a(player, stack);
                    this.setMateTimer(this.getMateTimer() / 2);
                }
                return ActionResultType.CONSUME;
            }
            if (this.func_70877_b(stack) && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_175505_a(player, stack);
                this.func_70691_i(1.0f);
                return ActionResultType.CONSUME;
            }
            if (item == Items.field_151103_aS && player.func_226273_bm_()) {
                if (this.getSex() == Genetics.Sex.FEMALE && this.getBreedingStatus("ispregnant")) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.info.kitten_count", new Object[]{this.getKittens()}), true);
                }
                if (this.func_70631_g_()) {
                    player.func_146105_b((ITextComponent)new StringTextComponent(this.func_70874_b() + " // " + this.getAgeTracker() + " // " + this.getMatureTimer()), true);
                }
                return ActionResultType.CONSUME;
            }
            if (item == SCItems.TREAT_BAG.get() && player.func_70068_e((Entity)this) < 9.0 && (!this.func_70909_n() || this.func_152114_e((LivingEntity)player))) {
                if (player.func_226273_bm_()) {
                    if (this.getHomePos().isPresent()) {
                        this.resetHomePos();
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.info.remove_home", new Object[]{this.func_200200_C_()}), true);
                    } else {
                        this.setHomePos(this.func_226268_ag_());
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.info.set_home", new Object[]{this.func_200200_C_(), this.getHomePos().get().func_177958_n(), this.getHomePos().get().func_177956_o(), this.getHomePos().get().func_177952_p()}), true);
                    }
                    return ActionResultType.SUCCESS;
                }
                if (this.getHomePos().isPresent()) {
                    player.func_146105_b((ITextComponent)new StringTextComponent(this.getHomePos().get().func_177958_n() + ", " + this.getHomePos().get().func_177956_o() + ", " + this.getHomePos().get().func_177952_p()), true);
                }
            }
        }
        if (this.func_152114_e((LivingEntity)player) && !player.func_226273_bm_()) {
            this.func_233687_w_(!this.func_233685_eM_());
            this.func_70661_as().func_75499_g();
            this.func_70624_b(null);
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean isAngry() {
        return ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 2) != 0;
    }

    public void setAngry(boolean angry) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (angry) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 | 2)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 & 0xFFFFFFFD)));
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.isAngry()) {
            return this.field_70146_Z.nextInt(10) == 0 ? SoundEvents.field_189106_R : null;
        }
        if (this.func_70880_s()) {
            return SoundEvents.field_187645_R;
        }
        if (this.func_70909_n()) {
            return this.field_70146_Z.nextInt(10) == 0 ? SoundEvents.field_187648_S : SoundEvents.field_187636_O;
        }
        return SoundEvents.field_219606_aE;
    }

    public int func_70627_aG() {
        return 240;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187642_Q;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187639_P;
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        String key;
        if (this.func_184753_b() != null && (key = SCReference.getCustomCats().get(this.func_184753_b())) != null && key.equalsIgnoreCase(name.getString())) {
            SimplyCatEntity cat = this;
            switch (name.getString().toLowerCase()) {
                case "penny": {
                    cat.setGenotype(FUR_LENGTH, "L-l");
                    cat.setGenotype(EUMELANIN, "B-B");
                    cat.setGenotype(PHAEOMELANIN, "XO-Xo");
                    cat.setGenotype(DILUTION, "D-d");
                    cat.setGenotype(DILUTE_MOD, "dm-dm");
                    cat.setGenotype(AGOUTI, "A-a");
                    cat.setGenotype(TABBY, "mc-mc");
                    cat.setGenotype(SPOTTED, "sp-sp");
                    cat.setGenotype(TICKED, "ta-ta");
                    cat.setGenotype(COLORPOINT, "C-cs");
                    cat.setGenotype(WHITE, "Ws-w");
                    cat.setGenotype(BOBTAIL, "Jb-Jb");
                    cat.selectWhiteMarkings();
                    cat.setGenotype(EYE_COLOR, "green");
                    cat.setFixed((byte)1);
                }
                case "spinny": {
                    cat.setGenotype(FUR_LENGTH, "L-l");
                    cat.setGenotype(EUMELANIN, "B-B");
                    cat.setGenotype(PHAEOMELANIN, "Xo-Xo");
                    cat.setGenotype(DILUTION, "D-d");
                    cat.setGenotype(DILUTE_MOD, "dm-dm");
                    cat.setGenotype(AGOUTI, "a-a");
                    cat.setGenotype(TABBY, "mc-mc");
                    cat.setGenotype(SPOTTED, "sp-sp");
                    cat.setGenotype(TICKED, "ta-ta");
                    cat.setGenotype(COLORPOINT, "C-cs");
                    cat.setGenotype(WHITE, "w-w");
                    cat.setGenotype(BOBTAIL, "Jb-Jb");
                    cat.selectWhiteMarkings();
                    cat.setGenotype(EYE_COLOR, "gold");
                }
            }
        }
        super.func_200203_b(name);
    }
}

