/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.entity.core;

import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class Genetics {
    public static StringTextComponent getPhenotypeDescription(CompoundNBT nbt, boolean includeSex) {
        boolean red;
        ITextComponent sex = Sex.getPrettyName(nbt.func_74779_i("Phaeomelanin"));
        String eumelanin = Eumelanin.getPhenotype(nbt.func_74779_i("Eumelanin"));
        String phaeomelanin = Phaeomelanin.getPhenotype(nbt.func_74779_i("Phaeomelanin"));
        String dilution = Dilution.getPhenotype(nbt.func_74779_i("Dilution"));
        String diluteMod = DiluteMod.getPhenotype(nbt.func_74779_i("DiluteMod"));
        TranslationTextComponent base = new TranslationTextComponent("cat.base." + eumelanin + (phaeomelanin.equals(Phaeomelanin.NOT_RED.toString().toLowerCase()) ? "" : "_" + phaeomelanin) + ".name");
        boolean dilute = dilution.equals(Dilution.DILUTE.toString().toLowerCase());
        boolean caramelized = diluteMod.equals(DiluteMod.CARAMELIZED.toString().toLowerCase());
        if (dilute) {
            base = new TranslationTextComponent("cat.base." + eumelanin + "_" + phaeomelanin + "_" + dilution + ".name");
            if (caramelized) {
                base = new TranslationTextComponent("cat.base." + eumelanin + "_" + phaeomelanin + "_" + diluteMod + ".name");
            }
        }
        if (red = phaeomelanin.equals(Phaeomelanin.RED.toString().toLowerCase())) {
            base = new TranslationTextComponent("cat.base." + phaeomelanin + ".name");
            if (dilute) {
                base = new TranslationTextComponent("cat.base." + phaeomelanin + "_" + dilution + ".name");
                if (caramelized) {
                    base = new TranslationTextComponent("cat.base." + phaeomelanin + "_" + diluteMod + ".name");
                }
            }
        }
        String agouti = Agouti.getPhenotype(nbt.func_74779_i("Agouti"));
        String tabby1 = Tabby.getPhenotype(nbt.func_74779_i("Tabby"));
        String spotted = Spotted.getPhenotype(nbt.func_74779_i("Spotted"));
        String ticked = Ticked.getPhenotype(nbt.func_74779_i("Ticked"));
        TranslationTextComponent tabby = new TranslationTextComponent("");
        if (agouti.equals(Agouti.TABBY.toString().toLowerCase()) || red) {
            tabby = new TranslationTextComponent("cat.tabby." + tabby1 + ".name");
            if (spotted.equals(Spotted.BROKEN.toString().toLowerCase()) || spotted.equals(Spotted.SPOTTED.toString().toLowerCase())) {
                tabby = new TranslationTextComponent("cat.tabby." + spotted + ".name");
            }
            if (ticked.equals(Ticked.TICKED.toString().toLowerCase())) {
                tabby = new TranslationTextComponent("cat.tabby." + ticked + ".name");
            }
        }
        String colorpoint = Colorpoint.getPhenotype(nbt.func_74779_i("Colorpoint"));
        TranslationTextComponent point = new TranslationTextComponent("");
        if (!colorpoint.equals(Colorpoint.NOT_POINTED.toString().toLowerCase())) {
            point = new TranslationTextComponent("cat.point." + colorpoint + ".name");
        }
        String white = White.getPhenotype(nbt.func_74779_i("White"));
        TranslationTextComponent whiteText = new TranslationTextComponent("");
        if (!white.equals(White.NONE.toString().toLowerCase())) {
            if (white.equals(White.DOMINANT.toString().toLowerCase()) || nbt.func_74779_i("White_0").contains("6")) {
                whiteText = new TranslationTextComponent("cat.white.solid_white.name");
                return new StringTextComponent(whiteText.getString() + (includeSex ? " " + sex.getString() : ""));
            }
            if (nbt.func_74779_i("White_0").contains("5")) {
                whiteText = new TranslationTextComponent("cat.white.mostly_white.name");
                return new StringTextComponent(whiteText.getString() + " " + base.getString() + (tabby.getString().equals("") ? "" : " " + tabby.getString()) + (point.getString().equals("") ? "" : " " + point.getString()) + (includeSex ? " " + sex.getString() : ""));
            }
            whiteText = new TranslationTextComponent("cat.white.some_white.name");
        }
        return new StringTextComponent(base.getString() + (tabby.getString().equals("") ? "" : " " + tabby.getString()) + (point.getString().equals("") ? "" : " " + point.getString()) + " " + whiteText.getString() + (includeSex ? " " + sex.getString() : ""));
    }

    public static enum Bobtail {
        FULL("Jb"),
        BOBTAIL("jb");

        private String allele;

        private Bobtail(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(Random rand) {
            float chance = rand.nextFloat();
            if (chance <= 0.98f) {
                return FULL.getAllele();
            }
            return BOBTAIL.getAllele();
        }

        public static boolean isBobtail(String alleles) {
            return !alleles.isEmpty() && alleles.equals("jb-jb");
        }
    }

    public static enum White {
        NONE("w"),
        SPOTTING("Ws"),
        DOMINANT("Wd");

        private String allele;

        private White(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(Random rand) {
            float chance = rand.nextFloat();
            if (chance <= 0.49f) {
                return NONE.getAllele();
            }
            if (chance > 0.49f && chance <= 0.98f) {
                return SPOTTING.getAllele();
            }
            return DOMINANT.getAllele();
        }

        public static String getPhenotype(String alleles) {
            switch (alleles) {
                case "Wd-Wd": 
                case "Wd-w": 
                case "Wd-Ws": 
                case "w-Wd": 
                case "Ws-Wd": {
                    return DOMINANT.toString().toLowerCase();
                }
                case "Ws-Ws": 
                case "Ws-w": 
                case "w-Ws": {
                    return SPOTTING.toString().toLowerCase();
                }
            }
            return NONE.toString().toLowerCase();
        }
    }

    public static enum Colorpoint {
        NOT_POINTED("C"),
        COLORPOINT("cs"),
        SEPIA("cb"),
        MINK;

        private String allele;

        private Colorpoint(String allele) {
            this.allele = allele;
        }

        private Colorpoint() {
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(Random rand) {
            float chance = rand.nextFloat();
            if (chance <= 0.8f) {
                return NOT_POINTED.getAllele();
            }
            if (chance > 0.8f && chance <= 0.96f) {
                return COLORPOINT.getAllele();
            }
            return SEPIA.getAllele();
        }

        public static String getPhenotype(String alleles) {
            switch (alleles) {
                default: {
                    return NOT_POINTED.toString().toLowerCase();
                }
                case "cs-cs": {
                    return COLORPOINT.toString().toLowerCase();
                }
                case "cs-cb": 
                case "cb-cs": {
                    return MINK.toString().toLowerCase();
                }
                case "cb-cb": 
            }
            return SEPIA.toString().toLowerCase();
        }
    }

    public static enum SilverInhibitor {
        SILVER("I"),
        NON_SILVER("i");

        private String allele;

        private SilverInhibitor(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(Random rand) {
            float chance = rand.nextFloat();
            if (chance <= 0.96f) {
                return NON_SILVER.getAllele();
            }
            return SILVER.getAllele();
        }

        public static String getPhenotype(String alleles) {
            if (alleles.isEmpty()) {
                return NON_SILVER.toString().toLowerCase();
            }
            String[] value = alleles.split("-");
            if (value[0].equals("I") || value[1].equals("I")) {
                return SILVER.toString().toLowerCase();
            }
            return NON_SILVER.toString().toLowerCase();
        }
    }

    public static enum Ticked {
        NON_TICKED("ta"),
        TICKED("Ta");

        private String allele;

        private Ticked(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(Random rand) {
            float chance = rand.nextFloat();
            if (chance <= 0.96f) {
                return NON_TICKED.getAllele();
            }
            return TICKED.getAllele();
        }

        public static String getPhenotype(String alleles) {
            if (alleles.isEmpty()) {
                return NON_TICKED.toString().toLowerCase();
            }
            String[] value = alleles.split("-");
            if (value[0].equals("Ta") || value[1].equals("Ta")) {
                return TICKED.toString().toLowerCase();
            }
            return NON_TICKED.toString().toLowerCase();
        }
    }

    public static enum Spotted {
        NON_SPOTTED("sp"),
        SPOTTED("Sp"),
        BROKEN;

        private String allele;

        private Spotted(String allele) {
            this.allele = allele;
        }

        private Spotted() {
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(Random rand) {
            float chance = rand.nextFloat();
            if (chance <= 0.8f) {
                return NON_SPOTTED.getAllele();
            }
            return SPOTTED.getAllele();
        }

        public static String getPhenotype(String alleles) {
            switch (alleles) {
                case "Sp-Sp": {
                    return SPOTTED.toString().toLowerCase();
                }
                case "Sp-sp": 
                case "sp-Sp": {
                    return BROKEN.toString().toLowerCase();
                }
            }
            return NON_SPOTTED.toString().toLowerCase();
        }
    }

    public static enum Tabby {
        MACKEREL("Mc"),
        CLASSIC("mc");

        private String allele;

        private Tabby(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(Random rand) {
            float chance = rand.nextFloat();
            if (chance <= 0.5f) {
                return MACKEREL.getAllele();
            }
            return CLASSIC.getAllele();
        }

        public static String getPhenotype(String alleles) {
            if (alleles.isEmpty()) {
                return MACKEREL.toString().toLowerCase();
            }
            String[] value = alleles.split("-");
            if (value[0].equals("Mc") || value[1].equals("Mc")) {
                return MACKEREL.toString().toLowerCase();
            }
            return CLASSIC.toString().toLowerCase();
        }
    }

    public static enum Agouti {
        SOLID("a"),
        TABBY("A");

        private String allele;

        private Agouti(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(Random rand) {
            float chance = rand.nextFloat();
            if (chance <= 0.8f) {
                return SOLID.getAllele();
            }
            return TABBY.getAllele();
        }

        public static String getPhenotype(String alleles) {
            if (alleles.isEmpty()) {
                return SOLID.toString().toLowerCase();
            }
            String[] value = alleles.split("-");
            if (value[0].equals("A") || value[1].equals("A")) {
                return TABBY.toString().toLowerCase();
            }
            return SOLID.toString().toLowerCase();
        }
    }

    public static enum DiluteMod {
        NON_CARAMEL("dm"),
        CARAMELIZED("Dm");

        private String allele;

        private DiluteMod(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(Random rand) {
            float chance = rand.nextFloat();
            if (chance <= 0.96f) {
                return NON_CARAMEL.getAllele();
            }
            return CARAMELIZED.getAllele();
        }

        public static String getPhenotype(String alleles) {
            if (alleles.isEmpty()) {
                return NON_CARAMEL.toString().toLowerCase();
            }
            String[] value = alleles.split("-");
            if (value[0].equals("Dm") || value[1].equals("Dm")) {
                return CARAMELIZED.toString().toLowerCase();
            }
            return NON_CARAMEL.toString().toLowerCase();
        }
    }

    public static enum Dilution {
        NON_DILUTE("D"),
        DILUTE("d");

        private String allele;

        private Dilution(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(Random rand) {
            float chance = rand.nextFloat();
            if (chance <= 0.6f) {
                return NON_DILUTE.getAllele();
            }
            return DILUTE.getAllele();
        }

        public static String getPhenotype(String alleles) {
            if (alleles.isEmpty()) {
                return NON_DILUTE.toString().toLowerCase();
            }
            String[] value = alleles.split("-");
            if (value[0].equals("D") || value[1].equals("D")) {
                return NON_DILUTE.toString().toLowerCase();
            }
            return DILUTE.toString().toLowerCase();
        }
    }

    public static enum Phaeomelanin {
        NOT_RED("Xo"),
        RED("XO"),
        MALE("Y"),
        TORTOISESHELL;

        private String allele;

        private Phaeomelanin(String allele) {
            this.allele = allele;
        }

        private Phaeomelanin() {
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(Random rand) {
            float chance1 = rand.nextFloat();
            String allele1 = chance1 <= 0.75f ? NOT_RED.getAllele() : RED.getAllele();
            float chance2 = rand.nextFloat();
            String allele2 = allele1.equals(NOT_RED.getAllele()) ? (chance2 <= 0.75f ? NOT_RED.getAllele() : RED.getAllele()) : (chance2 <= 0.75f ? RED.getAllele() : NOT_RED.getAllele());
            return allele1 + "-" + (rand.nextInt(2) == 0 ? MALE.getAllele() : allele2);
        }

        public static String getPhenotype(String alleles) {
            switch (alleles) {
                case "XO-Y": 
                case "XO-XO": {
                    return RED.toString().toLowerCase();
                }
                default: {
                    return NOT_RED.toString().toLowerCase();
                }
                case "XO-Xo": 
                case "Xo-XO": 
            }
            return TORTOISESHELL.toString().toLowerCase();
        }
    }

    public static enum Eumelanin {
        BLACK("B"),
        CHOCOLATE("b"),
        CINNAMON("b1");

        private String allele;

        private Eumelanin(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(Random rand) {
            float chance = rand.nextFloat();
            if (chance <= 0.8f) {
                return BLACK.getAllele();
            }
            if (chance > 0.8f && chance <= 0.96f) {
                return CHOCOLATE.getAllele();
            }
            return CINNAMON.getAllele();
        }

        public static String getPhenotype(String alleles) {
            if (alleles.isEmpty()) {
                return BLACK.toString().toLowerCase();
            }
            String[] value = alleles.split("-");
            if (value[0].equals("B") || value[1].equals("B")) {
                return BLACK.toString().toLowerCase();
            }
            if (value[0].equals("b") || value[1].equals("b")) {
                return CHOCOLATE.toString().toLowerCase();
            }
            return CINNAMON.toString().toLowerCase();
        }
    }

    public static enum FurLength {
        SHORT("L"),
        LONG("l");

        private String allele;

        private FurLength(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(Random rand) {
            float chance = rand.nextFloat();
            if (chance <= 0.75f) {
                return SHORT.getAllele();
            }
            return LONG.getAllele();
        }

        public static String getPhenotype(String alleles) {
            if (alleles.isEmpty()) {
                return SHORT.toString().toLowerCase();
            }
            String[] value = alleles.split("-");
            if (value[0].equals("L") || value[1].equals("L")) {
                return SHORT.toString().toLowerCase();
            }
            return LONG.toString().toLowerCase();
        }
    }

    public static enum EyeColor {
        COPPER,
        GOLD,
        HAZEL,
        GREEN,
        BLUE,
        ODD_LEFT,
        ODD_RIGHT;


        public static String init(int value) {
            switch (value) {
                case 0: {
                    return COPPER.toString().toLowerCase();
                }
                case 1: {
                    return GOLD.toString().toLowerCase();
                }
                default: {
                    return HAZEL.toString().toLowerCase();
                }
                case 3: {
                    return GREEN.toString().toLowerCase();
                }
                case 4: 
            }
            return BLUE.toString().toLowerCase();
        }

        public static String getPhenotype(String eyes) {
            switch (eyes) {
                case "copper": {
                    return COPPER.toString().toLowerCase();
                }
                case "gold": {
                    return GOLD.toString().toLowerCase();
                }
                default: {
                    return HAZEL.toString().toLowerCase();
                }
                case "green": {
                    return GREEN.toString().toLowerCase();
                }
                case "blue": 
            }
            return BLUE.toString().toLowerCase();
        }
    }

    public static enum Sex {
        MALE("male"),
        FEMALE("female");

        private String name;

        private Sex(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static ITextComponent getPrettyName(String phaeomelanin) {
            if (phaeomelanin.contains(Phaeomelanin.MALE.getAllele())) {
                return new TranslationTextComponent("cat.sex.male.name");
            }
            if (!phaeomelanin.contains(Phaeomelanin.MALE.getAllele())) {
                return new TranslationTextComponent("cat.sex.female.name");
            }
            return new StringTextComponent(phaeomelanin);
        }
    }
}

