/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.entity.goal;

import com.github.mnesikos.simplycats.configuration.SCConfig;
import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;

public class CatWanderGoal
extends Goal {
    protected final SimplyCatEntity cat;
    protected double x;
    protected double y;
    protected double z;
    protected final double speed;
    protected int interval;

    public CatWanderGoal(SimplyCatEntity cat, double speed) {
        this.cat = cat;
        this.speed = speed;
        this.interval = 45;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (this.cat.func_70654_ax() >= 100) {
            return false;
        }
        if (this.cat.func_70681_au().nextInt(this.interval) != 0) {
            return false;
        }
        Vector3d vector3d = this.getPosition();
        if (vector3d == null) {
            return false;
        }
        this.x = vector3d.field_72450_a;
        this.y = vector3d.field_72448_b;
        this.z = vector3d.field_72449_c;
        return true;
    }

    @Nullable
    private Vector3d getPosition() {
        double wanderRange;
        double homePosDist;
        PathNavigator pathNavigator = this.cat.func_70661_as();
        Random random = this.cat.func_70681_au();
        int xzRange = 10;
        int yRange = 3;
        boolean outsideBounds = this.cat.getHomePos().isPresent() ? (homePosDist = this.cat.getHomePos().get().func_218140_a((double)MathHelper.func_76128_c((double)this.cat.func_226277_ct_()), (double)MathHelper.func_76128_c((double)this.cat.func_226278_cu_()), (double)MathHelper.func_76128_c((double)this.cat.func_226281_cx_()), true) + 4.0) < (wanderRange = (Double)SCConfig.Common.wander_area_limit.get() + (double)xzRange) * wanderRange : false;
        boolean flag1 = false;
        double d0 = Double.NEGATIVE_INFINITY;
        BlockPos blockPos = this.cat.func_233580_cy_();
        for (int i = 0; i < 10; ++i) {
            float d1;
            PathNodeType pathNodeType;
            BlockPos blockPos3;
            int j = random.nextInt(2 * xzRange + 1) - xzRange;
            int k = random.nextInt(2 * yRange + 1) - yRange;
            int l = random.nextInt(2 * xzRange + 1) - xzRange;
            if (this.cat.getHomePos().isPresent()) {
                BlockPos blockPos2 = this.cat.getHomePos().get();
                j = this.cat.func_226277_ct_() > (double)blockPos2.func_177958_n() ? (j -= random.nextInt(xzRange / 2)) : (j += random.nextInt(xzRange / 2));
                l = this.cat.func_226281_cx_() > (double)blockPos2.func_177952_p() ? (l -= random.nextInt(xzRange / 2)) : (l += random.nextInt(xzRange / 2));
            }
            if ((blockPos3 = new BlockPos((double)j + this.cat.func_226277_ct_(), (double)k + this.cat.func_226278_cu_(), (double)l + this.cat.func_226281_cx_())).func_177956_o() < 0 || blockPos3.func_177956_o() > this.cat.field_70170_p.func_217301_I() || outsideBounds && !(this.cat.getHomePos().get().func_177951_i((Vector3i)blockPos3) < (Double)SCConfig.Common.wander_area_limit.get() * (Double)SCConfig.Common.wander_area_limit.get()) || !pathNavigator.func_188555_b(blockPos3) || this.cat.field_70170_p.func_204610_c(blockPos3 = CatWanderGoal.moveAboveSolid(blockPos3, this.cat.field_70170_p.func_217301_I(), block -> this.cat.field_70170_p.func_180495_p(block).func_185904_a().func_76220_a())).func_206884_a((ITag)FluidTags.field_206959_a) || this.cat.func_184643_a(pathNodeType = WalkNodeProcessor.func_237231_a_((IBlockReader)this.cat.field_70170_p, (BlockPos.Mutable)blockPos3.func_239590_i_())) != 0.0f || !((double)(d1 = this.cat.func_180484_a(blockPos3)) > d0)) continue;
            d0 = d1;
            blockPos = blockPos3;
            flag1 = true;
        }
        return flag1 ? Vector3d.func_237492_c_((Vector3i)blockPos) : null;
    }

    public boolean func_75253_b() {
        return !this.cat.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.cat.func_70661_as().func_75492_a(this.x, this.y, this.z, this.speed);
    }

    public void func_75251_c() {
        this.cat.func_70661_as().func_75499_g();
    }

    private static BlockPos moveAboveSolid(BlockPos pos, int maxBuildHeight, Predicate<BlockPos> isSolid) {
        if (!isSolid.test(pos)) {
            return pos;
        }
        BlockPos blockPos = pos.func_177984_a();
        while (blockPos.func_177956_o() < maxBuildHeight && isSolid.test(blockPos)) {
            blockPos = blockPos.func_177984_a();
        }
        return blockPos;
    }
}

