/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.item;

import com.github.mnesikos.simplycats.SimplyCats;
import com.github.mnesikos.simplycats.client.gui.CatBookScreen;
import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CatBookItem
extends Item {
    public CatBookItem() {
        super(new Item.Properties().func_200916_a(SimplyCats.ITEM_GROUP).func_200917_a(1));
    }

    public void addBookmarkedPage(int id) {
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        if (target instanceof SimplyCatEntity && player.func_226273_bm_()) {
            ListNBT tagList;
            SimplyCatEntity cat = (SimplyCatEntity)target;
            stack = player.func_184586_b(hand);
            CompoundNBT compound = stack.func_196082_o();
            boolean catExists = false;
            int catInList = 0;
            if (compound.func_74764_b("pages")) {
                tagList = compound.func_150295_c("pages", 10);
                for (int i = 0; i < tagList.size(); ++i) {
                    if (!tagList.func_150305_b(i).func_186857_a("UUID").equals(cat.func_110124_au())) continue;
                    catExists = true;
                    catInList = i;
                    break;
                }
            } else {
                tagList = new ListNBT();
                compound.func_218657_a("pages", (INBT)tagList);
            }
            CompoundNBT catTag = new CompoundNBT();
            cat.func_70039_c(catTag);
            ResourceLocation key = EntityType.func_200718_a((EntityType)cat.func_200600_R());
            catTag.func_74778_a("id", key.toString());
            if (cat.func_145818_k_()) {
                catTag.func_74778_a("DisplayName", cat.func_145748_c_().getString());
            }
            if (!catExists) {
                tagList.add((Object)catTag);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.book.save_cat_data", new Object[]{cat.func_200200_C_()}), true);
            } else {
                tagList.func_218659_a(catInList, (INBT)catTag);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.book.update_cat_data", new Object[]{cat.func_200200_C_()}), true);
            }
            stack.func_77982_d(compound);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        CompoundNBT bookTag = player.func_184586_b(hand).func_77978_p();
        if (bookTag == null || bookTag.isEmpty()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.book.empty_book"), true);
        } else if (world.field_72995_K) {
            this.openCatBook(bookTag, world);
        }
        return super.func_77659_a(world, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openCatBook(CompoundNBT bookTag, World world) {
        Minecraft.func_71410_x().func_147108_a((Screen)new CatBookScreen(bookTag, world));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.cat_book.usage"));
    }
}

