/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.item;

import com.github.mnesikos.simplycats.SimplyCats;
import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CertificateItem
extends Item {
    private final boolean adoption;

    public CertificateItem(boolean adoption) {
        super(new Item.Properties().func_200916_a(SimplyCats.ITEM_GROUP));
        this.adoption = adoption;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        if (target instanceof SimplyCatEntity || target instanceof WolfEntity || target instanceof ParrotEntity) {
            TameableEntity tameable = (TameableEntity)target;
            if (this.adoption) {
                if (tameable instanceof SimplyCatEntity && ((SimplyCatEntity)tameable).canBeTamed(player) || !(tameable instanceof SimplyCatEntity) && !tameable.func_70909_n()) {
                    if (tameable instanceof SimplyCatEntity) {
                        ((SimplyCatEntity)tameable).setTamed(true, player);
                    } else {
                        tameable.func_193101_c(player);
                    }
                    tameable.func_70661_as().func_75499_g();
                    tameable.func_233687_w_(true);
                    tameable.func_70606_j(tameable.func_110138_aP());
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.info.adopt_usage", new Object[]{tameable.func_200200_C_()}), true);
                    if (player.field_70170_p.field_72995_K) {
                        this.playTameEffect(true, tameable.field_70170_p, tameable);
                    }
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    return ActionResultType.SUCCESS;
                }
                if (tameable instanceof SimplyCatEntity && !tameable.func_70909_n()) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.info.tamed_limit_reached"), true);
                    return ActionResultType.PASS;
                }
            } else if (tameable.func_152114_e((LivingEntity)player)) {
                if (tameable instanceof SimplyCatEntity) {
                    ((SimplyCatEntity)tameable).setTamed(false, player);
                } else {
                    tameable.func_70903_f(false);
                }
                tameable.func_70661_as().func_75499_g();
                tameable.func_184754_b(null);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.info.release_usage", new Object[]{tameable.func_200200_C_()}), true);
                this.playTameEffect(false, tameable.field_70170_p, tameable);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    protected void playTameEffect(boolean play, World world, TameableEntity entity) {
        BasicParticleType iparticledata = ParticleTypes.field_197633_z;
        if (!play) {
            iparticledata = ParticleTypes.field_197601_L;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = world.field_73012_v.nextGaussian() * 0.02;
            double d1 = world.field_73012_v.nextGaussian() * 0.02;
            double d2 = world.field_73012_v.nextGaussian() * 0.02;
            world.func_195594_a((IParticleData)iparticledata, entity.func_226282_d_(1.0), entity.func_226279_cv_() + 0.5, entity.func_226287_g_(1.0), d0, d1, d2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.certificate_" + (this.adoption ? "adopt" : "release") + ".desc"));
    }
}

