/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.worldgen.villages;

import com.github.mnesikos.simplycats.block.SCBlocks;
import com.github.mnesikos.simplycats.item.SCItems;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class SCVillagers {
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PROFESSIONS, (String)"simplycats");
    public static final DeferredRegister<PointOfInterestType> POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"simplycats");
    public static final RegistryObject<PointOfInterestType> ADOPTION_BOOK = POI_TYPES.register("adoption_book", () -> new PointOfInterestType("shelter_worker", PointOfInterestType.func_221042_a((Block)((Block)SCBlocks.SHELTER_BOOK.get())), 2, 1));
    public static final RegistryObject<VillagerProfession> SHELTER_WORKER = PROFESSIONS.register("shelter_worker", () -> new VillagerProfession("shelter_worker", (PointOfInterestType)ADOPTION_BOOK.get(), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.field_219702_mJ));

    public static void registerPointOfInterests() {
        try {
            ObfuscationReflectionHelper.findMethod(PointOfInterestType.class, (String)"registerBlockStates", (Class[])new Class[]{PointOfInterestType.class}).invoke(null, ADOPTION_BOOK.get());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void registerTrades() {
        VillagerTrades.ITrade[] level1 = new VillagerTrades.ITrade[]{new VillagerTrades.ItemsForEmeraldsTrade((Item)SCItems.CATNIP_SEEDS.get(), 1, 1, 4, 8), new VillagerTrades.EmeraldForItemsTrade((IItemProvider)SCItems.CATNIP.get(), 20, 16, 2)};
        VillagerTrades.ITrade[] level2 = new VillagerTrades.ITrade[]{new ItemsForPetTrade((IItemProvider)Items.field_196086_aW, 3), new ItemsForPetTrade((IItemProvider)Items.field_151103_aS, 4), new VillagerTrades.ItemsForEmeraldsTrade((Item)SCItems.STERILIZE_POTION.get(), 1, 4, 4, 16)};
        VillagerTrades.ITrade[] level3 = new VillagerTrades.ITrade[]{new VillagerTrades.ItemsForEmeraldsTrade((Item)SCItems.PET_CARRIER.get(), 2, 1, 4, 16)};
        VillagerTrades.ITrade[] level4 = new VillagerTrades.ITrade[]{new ItemsForPetTrade((IItemProvider)Items.field_151014_N, 5), new ItemsForPetTrade((IItemProvider)Items.field_151172_bF, 6), new VillagerTrades.ItemsForEmeraldsTrade(Items.field_151141_av, 2, 1, 2, 16)};
        VillagerTrades.ITrade[] level5 = new VillagerTrades.ITrade[]{new VillagerTrades.ItemsForEmeraldsTrade((Item)SCItems.LASER_POINTER.get(), 1, 1, 1, 32)};
        VillagerTrades.field_221239_a.put(SHELTER_WORKER.get(), SCVillagers.toIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)level1, (Object)2, (Object)level2, (Object)3, (Object)level3, (Object)4, (Object)level4, (Object)5, (Object)level5)));
    }

    private static Int2ObjectMap<VillagerTrades.ITrade[]> toIntMap(ImmutableMap<Integer, VillagerTrades.ITrade[]> map) {
        return new Int2ObjectOpenHashMap(map);
    }

    public static class ItemsForPetTrade
    implements VillagerTrades.ITrade {
        private final ItemStack petCarrierItem;
        private final Item itemCost;

        private ItemsForPetTrade(IItemProvider itemCost, int setDamageValue) {
            ItemStack carrierItem = new ItemStack((IItemProvider)SCItems.PET_CARRIER.get(), 1, new CompoundNBT());
            carrierItem.func_196085_b(setDamageValue);
            this.petCarrierItem = carrierItem;
            this.itemCost = itemCost.func_199767_j();
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity entity, Random random) {
            int j = Math.min(8 + random.nextInt(9), 16);
            ItemStack price = new ItemStack((IItemProvider)this.itemCost, j);
            return new MerchantOffer(price, this.petCarrierItem, 2, 16, 0.2f);
        }
    }
}

