/*
 * Decompiled with CFR 0.152.
 */
package supercoder79.cavebiomes.impl;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import supercoder79.cavebiomes.api.CaveDecorator;
import supercoder79.cavebiomes.world.compat.VanillaCompat;
import supercoder79.cavebiomes.world.decorator.CaveDecorators;
import supercoder79.cavebiomes.world.layer.LayerDispatcher;

public final class CaveBiomesImpl {
    private static final Map<class_5321<class_1959>, CaveDecorator> BIOME_DECORATORS = new HashMap<class_5321<class_1959>, CaveDecorator>();
    private static final List<CaveDecorator> DECORATORS = new ArrayList<CaveDecorator>();
    private static final List<CaveDecorator> BASE_DECORATORS = new ArrayList<CaveDecorator>();
    private static final List<LayerDispatcher.DispatchFunction> DISPATCH_FUNCTIONS = new ArrayList<LayerDispatcher.DispatchFunction>();

    private CaveBiomesImpl() {
    }

    public static void addBiomeCaveDecorator(class_5321<class_1959> biome, CaveDecorator decorator) {
        BIOME_DECORATORS.put(biome, decorator);
    }

    public static void registerCaveDecorator(CaveDecorator decorator) {
        if (!DECORATORS.contains(decorator)) {
            DECORATORS.add(decorator);
        }
    }

    public static void registerBaseCaveDecorator(CaveDecorator decorator) {
        if (!BASE_DECORATORS.contains(decorator)) {
            BASE_DECORATORS.add(decorator);
        }
    }

    public static void registerLayerDispatcher(LayerDispatcher.DispatchFunction function) {
        DISPATCH_FUNCTIONS.add(function);
    }

    public static List<CaveDecorator> getCaveDecorators() {
        return ImmutableList.copyOf(DECORATORS);
    }

    public static List<CaveDecorator> getBaseCaveDecorators() {
        return ImmutableList.copyOf(BASE_DECORATORS);
    }

    public static List<LayerDispatcher.DispatchFunction> getDispatchFunctions() {
        return ImmutableList.copyOf(DISPATCH_FUNCTIONS);
    }

    public static int indexOf(CaveDecorator decorator) {
        return DECORATORS.indexOf(decorator);
    }

    public static CaveDecorator getCaveDecoratorForBiome(class_2378<class_1959> registry, class_1959 biome) {
        Optional key = registry.method_29113((Object)biome);
        if (key.isPresent()) {
            return BIOME_DECORATORS.computeIfAbsent((class_5321<class_1959>)key.get(), (Function<class_5321<class_1959>, CaveDecorator>)((Function<class_5321, CaveDecorator>)registryKey -> VanillaCompat.guessCaveDecorator(biome)));
        }
        return CaveDecorators.NONE;
    }
}

