/*
 * Decompiled with CFR 0.152.
 */
package supercoder79.cavebiomes.world.layer;

import supercoder79.cavebiomes.util.LayerRandom;
import supercoder79.cavebiomes.world.layer.CaveLayer;

public class ScaleCaveLayer
extends CaveLayer {
    private final CaveLayer parent;

    public ScaleCaveLayer(long worldSeed, int salt, CaveLayer parent) {
        super(worldSeed, salt);
        this.parent = parent;
    }

    @Override
    protected int operate(LayerRandom random, int x, int z) {
        int tl = this.parent.sample(this.transformX(x), this.transformZ(z));
        int ix = x & 1;
        int iz = z & 1;
        if (ix == 0 && iz == 0) {
            return tl;
        }
        random.setPosSeed(x & 0xFFFFFFFE, z & 0xFFFFFFFE, this.salt);
        if (ix == 0) {
            int bl = this.parent.sample(this.transformX(x), this.transformZ(z + 1));
            return this.choose(random, tl, bl);
        }
        if (iz == 0) {
            int tr = this.parent.sample(this.transformX(x + 1), this.transformZ(z));
            return this.choose(random, tl, tr);
        }
        int bl = this.parent.sample(this.transformX(x), this.transformZ(z + 1));
        int tr = this.parent.sample(this.transformX(x + 1), this.transformZ(z));
        int br = this.parent.sample(this.transformX(x + 1), this.transformZ(z + 1));
        return this.sample(random, tl, tr, bl, br);
    }

    public int transformX(int x) {
        return x >> 1;
    }

    public int transformZ(int y) {
        return y >> 1;
    }

    protected int sample(LayerRandom random, int i, int j, int k, int l) {
        if (j == k && k == l) {
            return j;
        }
        if (i == j && i == k) {
            return i;
        }
        if (i == j && i == l) {
            return i;
        }
        if (i == k && i == l) {
            return i;
        }
        if (i == j && k != l) {
            return i;
        }
        if (i == k && j != l) {
            return i;
        }
        if (i == l && j != k) {
            return i;
        }
        if (j == k && i != l) {
            return j;
        }
        if (j == l && i != k) {
            return j;
        }
        return k == l && i != j ? k : this.choose(random, i, j, k, l);
    }
}

