/*
 * Decompiled with CFR 0.152.
 */
package me.thonk.croptopia;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.thonk.croptopia.Constants;
import me.thonk.croptopia.SetupCommand;
import me.thonk.croptopia.blocks.CroptopiaCropBlock;
import me.thonk.croptopia.blocks.LeafCropBlock;
import me.thonk.croptopia.config.ConfigurableSeed;
import me.thonk.croptopia.data.Runner;
import me.thonk.croptopia.dependencies.Patchouli;
import me.thonk.croptopia.generator.BiomeModifiers;
import me.thonk.croptopia.items.CropItem;
import me.thonk.croptopia.items.CropLootTableModifier;
import me.thonk.croptopia.items.SeedItem;
import me.thonk.croptopia.loottables.BiomeLootCondition;
import me.thonk.croptopia.mixin.AxeAccess;
import me.thonk.croptopia.mixin.VillagerAccess;
import me.thonk.croptopia.recipe.DamageDurabilitySerializer;
import me.thonk.croptopia.registry.BlockRegistry;
import me.thonk.croptopia.registry.Composter;
import me.thonk.croptopia.registry.ItemRegistry;
import me.thonk.croptopia.registry.LeavesRegistry;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1299;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1798;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2397;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_4970;
import net.minecraft.class_5335;
import net.minecraft.class_5341;
import net.minecraft.class_5342;

public class Croptopia
implements ModInitializer {
    public static ArrayList<class_2248> cropBlocks = new ArrayList();
    public static ArrayList<class_1792> cropItems = new ArrayList();
    public static ArrayList<class_2248> leafBlocks = new ArrayList();
    private static List<ConfigurableSeed> seeds = new ArrayList<ConfigurableSeed>();
    public static final class_1761 CROPTOPIA_ITEM_GROUP = FabricItemGroupBuilder.create((class_2960)new class_2960("croptopia", "croptopia")).icon(() -> new class_1799((class_1935)ItemRegistry.onion)).build();
    public static final class_5342 BIOME_CHECK = Croptopia.registerLootCondition("biome_check", new BiomeLootCondition.Serializer());
    public static final DamageDurabilitySerializer DAMAGE_DURABILITY = Croptopia.registerSerializer("crafting_damage_durability", new DamageDurabilitySerializer());
    public static Patchouli patchouli;
    private static Runner runner;

    public void onInitialize() {
        runner = new Runner();
        patchouli = new Patchouli();
        LeavesRegistry.init();
        BlockRegistry.init();
        ItemRegistry.init();
        Constants.OPTIONS.addSeedDefaults(seeds, Constants.OPTIONS.getOptionsFile());
        seeds.clear();
        seeds = Constants.OPTIONS.readConfiguredSeeds(Constants.OPTIONS.getOptionsFile());
        BiomeModifiers.init();
        CropLootTableModifier.init();
        Composter.init();
        CommandRegistrationCallback.EVENT.register((commandDispatcher, b) -> SetupCommand.register((CommandDispatcher<class_2168>)commandDispatcher));
        this.modifyVillagerFoodItems();
        this.modifyVillagerGatherables();
        this.modifyAxeBlockStripping();
        runner.init();
    }

    public static class_2960 createIdentifier(String name) {
        return new class_2960("croptopia", name);
    }

    public static class_5342 registerLootCondition(String id, class_5335<? extends class_5341> serializer) {
        return (class_5342)class_2378.method_10230((class_2378)class_2378.field_25299, (class_2960)new class_2960("croptopia", id), (Object)new class_5342(serializer));
    }

    public static <S extends class_1865<T>, T extends class_1860<?>> S registerSerializer(String id, S serializer) {
        return (S)((class_1865)class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)new class_2960("croptopia", id), serializer));
    }

    public static class_1792 registerItem(String itemName, class_1792 item) {
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)Croptopia.createIdentifier(itemName), (Object)item);
        if (item instanceof class_1798) {
            ((class_1798)item).method_7713(class_1792.field_8003, item);
        }
        if (item instanceof CropItem) {
            cropItems.add(item);
        }
        if (item instanceof SeedItem) {
            CroptopiaCropBlock block = (CroptopiaCropBlock)((SeedItem)item).method_7711();
            block.setSeedsItem(item);
        }
        if (item instanceof SeedItem) {
            seeds.add(new ConfigurableSeed(itemName, item, ((SeedItem)item).getCategory(), 0.0125f));
        }
        return item;
    }

    public static class_1792.class_1793 createGroup() {
        return new class_1792.class_1793().method_7892(CROPTOPIA_ITEM_GROUP);
    }

    public static class_2248 registerBlock(String blockName, class_2248 item) {
        cropBlocks.add(item);
        if (item instanceof LeafCropBlock || item instanceof class_2397) {
            leafBlocks.add(item);
        }
        class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)Croptopia.createIdentifier(blockName), (Object)item);
        return item;
    }

    public static FabricBlockSettings createCropSettings() {
        return FabricBlockSettings.of((class_3614)class_3614.field_15935).noCollision().ticksRandomly().breakInstantly().sounds(class_2498.field_17580);
    }

    public static FabricBlockSettings createSaplingSettings() {
        return FabricBlockSettings.of((class_3614)class_3614.field_15935).noCollision().ticksRandomly().breakInstantly().sounds(class_2498.field_11535);
    }

    public static LeafCropBlock createLeavesBlock() {
        return new LeafCropBlock((class_4970.class_2251)FabricBlockSettings.of((class_3614)class_3614.field_15923).strength(0.2f).ticksRandomly().sounds(class_2498.field_11535).nonOpaque().allowsSpawning(Croptopia::canSpawnOnLeaves).suffocates(Croptopia::never).blockVision(Croptopia::never));
    }

    public static class_2397 createRegularLeavesBlock() {
        return new class_2397((class_4970.class_2251)FabricBlockSettings.of((class_3614)class_3614.field_15923).strength(0.2f).ticksRandomly().sounds(class_2498.field_11535).nonOpaque().allowsSpawning(Croptopia::canSpawnOnLeaves).suffocates(Croptopia::never).blockVision(Croptopia::never));
    }

    private static boolean canSpawnOnLeaves(class_2680 state, class_1922 world, class_2338 pos, class_1299<?> type) {
        return type == class_1299.field_6081 || type == class_1299.field_6104;
    }

    private static boolean never(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }

    public static List<ConfigurableSeed> getSeeds() {
        return seeds;
    }

    private void modifyVillagerFoodItems() {
        ImmutableMap.Builder villagerFoodItems = new ImmutableMap.Builder().putAll(VillagerAccess.getItemFoodValues());
        cropItems.forEach(item -> villagerFoodItems.put(item, (Object)item.method_19264().method_19230()));
        VillagerAccess.setItemFoodValues((Map<class_1792, Integer>)villagerFoodItems.build());
    }

    private void modifyVillagerGatherables() {
        ImmutableSet.Builder villagerGatherables = new ImmutableSet.Builder().addAll(VillagerAccess.getGatherableItems());
        seeds.forEach(configurableSeed -> villagerGatherables.add((Object)configurableSeed.getSeedItem()));
        cropItems.forEach(arg_0 -> ((ImmutableSet.Builder)villagerGatherables).add(arg_0));
        VillagerAccess.setGatherableItems((Set<class_1792>)villagerGatherables.build());
    }

    private void modifyAxeBlockStripping() {
        Map<class_2248, class_2248> immutableBlocks = AxeAccess.getStrippedBlocks();
        AxeAccess.setStrippedBlocks((Map<class_2248, class_2248>)new ImmutableMap.Builder().putAll(immutableBlocks).put((Object)BlockRegistry.cinnamonLog, (Object)BlockRegistry.strippedCinnamonLog).put((Object)BlockRegistry.cinnamonWood, (Object)BlockRegistry.strippedCinnamonWood).build());
    }
}

