/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_4587;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBookEntryList;
import vazkii.patchouli.client.book.gui.button.GuiButtonCategory;
import vazkii.patchouli.common.book.Book;

public class GuiBookCategory
extends GuiBookEntryList {
    private final BookCategory category;
    private int subcategoryButtonCount;

    public GuiBookCategory(Book book, BookCategory category) {
        super(book, category.getName());
        this.category = category;
    }

    @Override
    protected String getDescriptionText() {
        return this.category.getDescription();
    }

    @Override
    protected Collection<BookEntry> getEntries() {
        return this.category.getEntries();
    }

    @Override
    void drawForegroundElements(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        super.drawForegroundElements(ms, mouseX, mouseY, partialTicks);
        if (this.getEntries().isEmpty() && this.subcategoryButtonCount <= 16 && this.subcategoryButtonCount > 0) {
            int bottomSeparator = 55 + 24 * ((this.subcategoryButtonCount - 1) / 4 + 1);
            GuiBookCategory.drawSeparator(ms, this.book, 141, bottomSeparator);
        }
    }

    @Override
    protected void addSubcategoryButtons() {
        int baseY;
        int baseX;
        int i = 0;
        ArrayList<BookCategory> categories = new ArrayList<BookCategory>(this.book.contents.categories.values());
        categories.removeIf(cat -> cat.getParentCategory() != this.category || cat.shouldHide());
        Collections.sort(categories);
        this.subcategoryButtonCount = categories.size();
        boolean rightPageFree = this.getEntries().isEmpty();
        if (rightPageFree) {
            baseX = 151;
            baseY = 43;
        } else {
            baseX = 25;
            baseY = 174 - categories.size() / 4 * 20 - (!this.book.advancementsEnabled() ? 38 : 64);
        }
        for (BookCategory ocategory : categories) {
            int x = baseX + i % 4 * 24;
            int y = baseY + i / 4 * (rightPageFree ? 24 : 20);
            GuiButtonCategory button = new GuiButtonCategory(this, x, y, ocategory, this::handleButtonCategory);
            this.method_25411(button);
            this.dependentButtons.add(button);
            ++i;
        }
    }

    @Override
    protected String getChapterListTitle() {
        if (this.getEntries().isEmpty() && this.subcategoryButtonCount > 0) {
            return class_1074.method_4662((String)"patchouli.gui.lexicon.categories", (Object[])new Object[0]);
        }
        return super.getChapterListTitle();
    }

    @Override
    protected String getNoEntryMessage() {
        if (this.subcategoryButtonCount > 0) {
            return "";
        }
        return super.getNoEntryMessage();
    }

    @Override
    protected class_342 createSearchBar() {
        class_342 widget = super.createSearchBar();
        if (this.getEntries().isEmpty()) {
            widget.field_22763 = false;
            widget.method_1888(false);
            widget.method_1862(false);
        }
        return widget;
    }

    @Override
    protected boolean doesEntryCountForProgress(BookEntry entry) {
        return entry.getCategory() == this.category;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof GuiBookCategory && ((GuiBookCategory)((Object)obj)).category == this.category && ((GuiBookCategory)((Object)obj)).spread == this.spread;
    }

    public int hashCode() {
        return Objects.hashCode(this.category) * 31 + Objects.hashCode(this.spread);
    }

    @Override
    public boolean canBeOpened() {
        return !this.category.isLocked() && !this.equals(class_310.method_1551().field_1755);
    }
}

