/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.base;

import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.EnumConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import vazkii.patchouli.common.base.Patchouli;

public class PatchouliConfig {
    public static PropertyMirror<Boolean> disableAdvancementLocking = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<List<String>> noAdvancementBooks = PropertyMirror.create((ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING));
    public static PropertyMirror<Boolean> testingMode = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<String> inventoryButtonBook = PropertyMirror.create((ConfigType)ConfigTypes.STRING);
    public static PropertyMirror<Boolean> useShiftForQuickLookup = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    private static final EnumConfigType<TextOverflowMode> OVERFLOW_TYPE = ConfigTypes.makeEnum(TextOverflowMode.class);
    public static PropertyMirror<TextOverflowMode> overflowMode = PropertyMirror.create(OVERFLOW_TYPE);
    private static final Map<String, Boolean> CONFIG_FLAGS = new ConcurrentHashMap<String, Boolean>();
    private static final ConfigTree CONFIG = ConfigTree.builder().beginValue("disableAdvancementLocking", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Set this to true to disable advancement locking for ALL books, making all entries visible at all times. Config Flag: advancements_disabled").finishValue(arg_0 -> disableAdvancementLocking.mirror(arg_0)).beginValue("noAdvancementBooks", (ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING), Collections.emptyList()).withComment("Granular list of Book ID's to disable advancement locking for, e.g. [ \"botania:lexicon\" ]. Config Flags: advancements_disabled_<bookid>").finishValue(arg_0 -> noAdvancementBooks.mirror(arg_0)).beginValue("testingMode", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Enable testing mode. By default this doesn't do anything, but you can use the config flag in your books if you want. Config Flag: testing_mode").finishValue(arg_0 -> testingMode.mirror(arg_0)).beginValue("inventoryButtonBook", (ConfigType)ConfigTypes.STRING, (Object)"").withComment("Set this to the ID of a book to have it show up in players' inventories, replacing the recipe book.").finishValue(arg_0 -> inventoryButtonBook.mirror(arg_0)).beginValue("useShiftForQuickLookup", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Set this to true to use Shift instead of Ctrl for the inventory quick lookup feature.").finishValue(arg_0 -> useShiftForQuickLookup.mirror(arg_0)).beginValue("textOverflowMode", OVERFLOW_TYPE, (Object)TextOverflowMode.OVERFLOW).withComment("Set how text overflow should be coped with: overflow the text off the page, truncate overflowed text, or resize everything to fit. Relogin after changing.").finishValue(arg_0 -> overflowMode.mirror(arg_0)).build();

    private static void writeDefaultConfig(Path path, JanksonValueSerializer serializer) {
        try (BufferedOutputStream s = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));){
            FiberSerialization.serialize((ConfigTree)CONFIG, (OutputStream)s, (ValueSerializer)serializer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setup() {
        JanksonValueSerializer serializer = new JanksonValueSerializer(false);
        Path p = Paths.get("config", "patchouli.json5");
        PatchouliConfig.writeDefaultConfig(p, serializer);
        try (BufferedInputStream s = new BufferedInputStream(Files.newInputStream(p, StandardOpenOption.READ, StandardOpenOption.CREATE));){
            FiberSerialization.deserialize((ConfigTree)CONFIG, (InputStream)s, (ValueSerializer)serializer);
        }
        catch (ValueDeserializationException | IOException e) {
            Patchouli.LOGGER.error("Error loading config", e);
        }
    }

    public static void reloadBuiltinFlags() {
        Collection mods = FabricLoader.getInstance().getAllMods();
        for (ModContainer info : mods) {
            PatchouliConfig.setFlag("mod:" + info.getMetadata().getId(), true);
        }
        PatchouliConfig.setFlag("debug", Patchouli.debug);
        PatchouliConfig.setFlag("advancements_disabled", (Boolean)disableAdvancementLocking.getValue());
        PatchouliConfig.setFlag("testing_mode", (Boolean)testingMode.getValue());
        for (String book : (List)noAdvancementBooks.getValue()) {
            PatchouliConfig.setFlag("advancements_disabled_" + book, true);
        }
    }

    public static boolean getConfigFlag(String name) {
        Boolean b;
        if (name.startsWith("&")) {
            return PatchouliConfig.getConfigFlagAND(name.replaceAll("[&|]", "").split(","));
        }
        if (name.startsWith("|")) {
            return PatchouliConfig.getConfigFlagOR(name.replaceAll("[&|]", "").split(","));
        }
        boolean target = true;
        if (name.startsWith("!")) {
            name = name.substring(1);
            target = false;
        }
        if ((b = CONFIG_FLAGS.get(name = name.trim().toLowerCase(Locale.ROOT))) == null) {
            if (!name.startsWith("mod:")) {
                Patchouli.LOGGER.warn("Queried for unknown config flag: {}", (Object)name);
            }
            b = false;
        }
        return b == target;
    }

    public static boolean getConfigFlagAND(String[] tokens) {
        for (String s : tokens) {
            if (PatchouliConfig.getConfigFlag(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean getConfigFlagOR(String[] tokens) {
        for (String s : tokens) {
            if (!PatchouliConfig.getConfigFlag(s)) continue;
            return true;
        }
        return false;
    }

    public static void setFlag(String flag, boolean value) {
        CONFIG_FLAGS.put(flag.trim().toLowerCase(Locale.ROOT), value);
    }

    public static enum TextOverflowMode {
        OVERFLOW,
        TRUNCATE,
        RESIZE;

    }
}

