/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.multiblock;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.common.multiblock.AbstractMultiblock;
import vazkii.patchouli.common.multiblock.SimulateResultImpl;
import vazkii.patchouli.common.multiblock.StateMatcher;
import vazkii.patchouli.common.util.RotationUtil;

public class SparseMultiblock
extends AbstractMultiblock {
    private final Map<class_2338, IStateMatcher> data;
    private final class_2382 size;

    public SparseMultiblock(Map<class_2338, IStateMatcher> data) {
        Preconditions.checkArgument((!data.isEmpty() ? 1 : 0) != 0, (Object)"No data given to sparse multiblock!");
        this.data = ImmutableMap.copyOf(data);
        this.size = this.calculateSize();
    }

    @Override
    public class_2382 getSize() {
        return this.size;
    }

    private class_2382 calculateSize() {
        int minX = this.data.keySet().stream().mapToInt(class_2382::method_10263).min().getAsInt();
        int maxX = this.data.keySet().stream().mapToInt(class_2382::method_10263).max().getAsInt();
        int minY = this.data.keySet().stream().mapToInt(class_2382::method_10264).min().getAsInt();
        int maxY = this.data.keySet().stream().mapToInt(class_2382::method_10264).max().getAsInt();
        int minZ = this.data.keySet().stream().mapToInt(class_2382::method_10260).min().getAsInt();
        int maxZ = this.data.keySet().stream().mapToInt(class_2382::method_10260).max().getAsInt();
        return new class_2382(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
    }

    public class_2680 method_8320(class_2338 pos) {
        int ticks = this.world != null ? (int)this.world.method_8532() : 0;
        return this.data.getOrDefault(pos, StateMatcher.AIR).getDisplayedState(ticks);
    }

    @Override
    public Pair<class_2338, Collection<IMultiblock.SimulateResult>> simulate(class_1937 world, class_2338 anchor, class_2470 rotation, boolean forView) {
        class_2338 disp = forView ? new class_2338(-this.viewOffX, -this.viewOffY + 1, -this.viewOffZ).method_10070(rotation) : new class_2338(-this.offX, -this.offY, -this.offZ).method_10070(rotation);
        class_2338 origin = anchor.method_10081((class_2382)disp);
        ArrayList<SimulateResultImpl> ret = new ArrayList<SimulateResultImpl>();
        for (Map.Entry<class_2338, IStateMatcher> e : this.data.entrySet()) {
            class_2338 currDisp = e.getKey().method_10070(rotation);
            class_2338 actionPos = origin.method_10081((class_2382)currDisp);
            ret.add(new SimulateResultImpl(actionPos, e.getValue(), null));
        }
        return Pair.of((Object)origin, ret);
    }

    @Override
    public boolean test(class_1937 world, class_2338 start, int x, int y, int z, class_2470 rotation) {
        this.setWorld(world);
        class_2338 checkPos = start.method_10081((class_2382)new class_2338(x, y, z).method_10070(rotation));
        class_2680 state = world.method_8320(checkPos).method_26186(RotationUtil.fixHorizontal(rotation));
        IStateMatcher matcher = this.data.getOrDefault(new class_2338(x, y, z), StateMatcher.ANY);
        return matcher.getStatePredicate().test((class_1922)world, checkPos, state);
    }
}

