/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_1657;

public class IdentityCompatibility {
    private static final boolean IDENTITY_LOADED = FabricLoader.getInstance().isModLoaded("identity");
    public static final IdentityCompatibility INSTANCE = new IdentityCompatibility();
    private final Optional<Class<?>> componentsClass;
    private final Optional<Class<?>> componentTypeClass;
    private final Optional<Class<?>> identityComponentClass;
    private final Optional<Object> currentIdentity;
    private final Optional<Method> getComponent;
    private final Optional<Method> getIdentity;
    private boolean enabled = IDENTITY_LOADED;

    public IdentityCompatibility() {
        if (this.enabled) {
            this.componentsClass = IdentityCompatibility.getClass("draylar.identity.registry.Components");
            this.componentTypeClass = IdentityCompatibility.getClass("nerdhub.cardinal.components.api.ComponentType");
            this.identityComponentClass = IdentityCompatibility.getClass("draylar.identity.cca.IdentityComponent");
            this.currentIdentity = IdentityCompatibility.getField(this.componentsClass, "CURRENT_IDENTITY").map(f -> {
                try {
                    return f.get(null);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    return Optional.empty();
                }
            });
            this.getComponent = IdentityCompatibility.getMethod(this.componentTypeClass, "get", Object.class);
            this.getIdentity = IdentityCompatibility.getMethod(this.identityComponentClass, "getIdentity", new Class[0]);
        } else {
            this.componentsClass = Optional.empty();
            this.componentTypeClass = Optional.empty();
            this.identityComponentClass = Optional.empty();
            this.currentIdentity = Optional.empty();
            this.getComponent = Optional.empty();
            this.getIdentity = Optional.empty();
        }
    }

    public class_1309 getIdentity(class_1657 entity) {
        if (this.enabled) {
            return this.currentIdentity.flatMap(t -> this.getComponent.flatMap(c -> this.getIdentity.map(m -> {
                try {
                    return (class_1309)m.invoke(c.invoke(t, entity), new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    return null;
                }
            }))).orElse(null);
        }
        return null;
    }

    private static Optional<Field> getField(Optional<Class<?>> classObj, String fieldName) {
        return classObj.map(c -> {
            try {
                Field f = c.getDeclaredField(fieldName);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException | SecurityException exception) {
                return null;
            }
        });
    }

    private static Optional<Method> getMethod(Optional<Class<?>> classObj, String methodName, Class<?> ... args) {
        return classObj.map(c -> {
            try {
                Method m = c.getMethod(methodName, args);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                return null;
            }
        });
    }

    private static Optional<Class<?>> getClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Optional.empty();
        }
    }
}

