/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.config;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.config.util.ConfigHolder;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ConfigLoader {
    public static ConfigHolder loadConfigFromFileForDimension(String dimensionName) {
        String fileName = "DIM_" + dimensionName.replace(':', '-') + ".toml";
        File configFile = new File(BetterCaves.customConfigDir, fileName);
        if (!configFile.exists() || configFile.isDirectory()) {
            BetterCaves.LOGGER.info("Better Caves config file for dimension {} not found. Using global config...", (Object)dimensionName);
            return new ConfigHolder();
        }
        if (!configFile.canRead()) {
            BetterCaves.LOGGER.warn("Better Caves config file for dimension {} not readable. Using global config...", (Object)dimensionName);
            return new ConfigHolder();
        }
        BetterCaves.LOGGER.info("Reading Better Caves config from file for dimension {}...", (Object)dimensionName);
        return ConfigLoader.parseConfigFromFile(configFile);
    }

    private static ConfigHolder parseConfigFromFile(File file) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((File)file).sync().preserveInsertionOrder().build();
        try {
            configData.load();
        }
        catch (Exception e) {
            BetterCaves.LOGGER.error("ERROR - Failed to parse Better Caves config for file {}", (Object)file.getName());
            BetterCaves.LOGGER.error("ENCOUNTERED ERROR {}", (Object)e.toString());
            BetterCaves.LOGGER.info("USING GLOBAL CONFIG FILE INSTEAD...");
            return new ConfigHolder();
        }
        if (configData.valueMap().size() == 0) {
            return new ConfigHolder();
        }
        if (configData.valueMap().size() != 1 || configData.valueMap().get("betterCaves") == null) {
            BetterCaves.LOGGER.error("ERROR - Invalid Better Caves config file {}", (Object)file.getName());
            BetterCaves.LOGGER.error("Is there only one topmost category level, called \"Better Caves\"?");
            BetterCaves.LOGGER.info("USING GLOBAL CONFIG FILE INSTEAD...");
            return new ConfigHolder();
        }
        Map<String, Object> pathMap = ConfigLoader.configToMap((AbstractConfig)configData.valueMap().get("betterCaves"));
        configData.close();
        ConfigHolder config = new ConfigHolder();
        for (Map.Entry<String, Object> entry : pathMap.entrySet()) {
            String fullName = entry.getKey();
            Object value = entry.getValue();
            ConfigHolder.ConfigOption<?> configOption = config.properties.get(fullName);
            if (configOption == null) {
                BetterCaves.LOGGER.error("ERROR: INVALID PROPERTY {} in config {}. Skipping...", (Object)fullName, (Object)file.getName());
                continue;
            }
            Class<?> type = configOption.getType();
            if ((type == Double.TYPE || type == Double.class) && value.getClass() == Integer.class) {
                configOption.set(((Integer)value).doubleValue());
                BetterCaves.LOGGER.debug("{}: overriding config option: {}", (Object)file.getName(), (Object)fullName);
                continue;
            }
            if (type != value.getClass()) {
                BetterCaves.LOGGER.error("ERROR: WRONG TYPE for {} in config {}. Skipping...", (Object)fullName, (Object)file.getName());
                continue;
            }
            configOption.set(value);
            BetterCaves.LOGGER.debug("{}: overriding config option: {}", (Object)file.getName(), (Object)fullName);
        }
        return config;
    }

    private static Map<String, Object> configToMap(AbstractConfig config) {
        HashMap<String, Object> pathMap = new HashMap<String, Object>();
        ConfigLoader.fillPathMap(config, pathMap, "betterCaves");
        return pathMap;
    }

    private static void fillPathMap(AbstractConfig config, Map<String, Object> pathMap, String currPath) {
        if (config == null) {
            return;
        }
        Map configMap = new HashMap();
        try {
            Field mapField = AbstractConfig.class.getDeclaredField("map");
            mapField.setAccessible(true);
            configMap = (Map)mapField.get(config);
        }
        catch (Exception e) {
            BetterCaves.LOGGER.error("Encountered error trying to parse config: {}", (Object)e.toString());
        }
        if (configMap.size() == 0) {
            return;
        }
        for (Map.Entry entry : configMap.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String path = currPath + "." + key;
            if (value instanceof AbstractConfig) {
                ConfigLoader.fillPathMap((AbstractConfig)value, pathMap, path);
                continue;
            }
            pathMap.put(path, value);
        }
    }
}

