/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.util;

import com.yungnickyoung.minecraft.yungsapi.math.ColPos;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3614;
import net.minecraft.class_5281;

public class BetterCavesUtils {
    public static Predicate<class_1959.class_1961> isOcean = b -> b == class_1959.class_1961.field_9367;
    public static Predicate<class_1959.class_1961> isNotOcean = b -> b != class_1959.class_1961.field_9367;

    private BetterCavesUtils() {
    }

    public static int getMaxSurfaceAltitudeSubChunk(class_2791 chunkIn, int subX, int subZ) {
        int[] testCoords;
        int maxHeight = 0;
        for (int x : testCoords = new int[]{0, 1}) {
            for (int z : testCoords) {
                maxHeight = Math.max(maxHeight, BetterCavesUtils.getSurfaceAltitudeForColumn(chunkIn, subX * 2 + x, subZ * 2 + z));
            }
        }
        return maxHeight;
    }

    public static int getSurfaceAltitudeForColumn(class_2791 chunkIn, int localX, int localZ) {
        return BetterCavesUtils.searchSurfaceAltitudeInRangeForColumn(chunkIn, localX, localZ, 255, 0);
    }

    public static int searchSurfaceAltitudeInRangeForColumn(class_2791 chunkIn, int localX, int localZ, int topY, int bottomY) {
        class_2338 topPos;
        class_2338.class_2339 blockPos = new class_2338.class_2339(localX, bottomY, localZ);
        if (topY == 255 && chunkIn.method_8320(topPos = new class_2338(localX, topY, localZ)) != class_2246.field_10124.method_9564() && chunkIn.method_8320(topPos).method_26207() != class_3614.field_15920) {
            return 255;
        }
        for (int y = bottomY; y <= topY; ++y) {
            class_2680 blockState = chunkIn.method_8320((class_2338)blockPos);
            if (blockState == class_2246.field_10124.method_9564() || blockState.method_26207() == class_3614.field_15920) {
                return y;
            }
            blockPos.method_10098(class_2350.field_11036);
        }
        return 1;
    }

    public static int getLocal(int coordinate) {
        return coordinate & 0xF;
    }

    public static boolean isPosInWorld(ColPos pos, class_5281 world) {
        return world.method_8393(pos.getX() >> 4, pos.getZ() >> 4);
    }

    public static boolean isPosInWorld(class_2338 pos, class_5281 world) {
        return world.method_8393(pos.method_10263() >> 4, pos.method_10260() >> 4);
    }

    public static float getDistFactor(class_5281 worldIn, Map<Long, class_1959> biomeMap, ColPos pos, int radius, Predicate<class_1959.class_1961> isTargetBiome) {
        ColPos.Mutable checkpos = new ColPos.Mutable();
        for (int i = 1; i <= radius; ++i) {
            for (int j = 0; j <= i; ++j) {
                for (class_2350 direction : class_2350.class_2353.field_11062) {
                    checkpos.set(pos).move(direction, i).move(direction.method_10170(), j);
                    if (BetterCavesUtils.isPosInWorld((ColPos)checkpos, worldIn) && isTargetBiome.test(biomeMap.get(checkpos.toLong()).method_8688())) {
                        return (float)(i + j) / (float)(2 * radius);
                    }
                    if (j == 0 || i == j) continue;
                    checkpos.set(pos).move(direction, i).move(direction.method_10160(), j);
                    if (!BetterCavesUtils.isPosInWorld((ColPos)checkpos, worldIn) || !isTargetBiome.test(biomeMap.get(checkpos.toLong()).method_8688())) continue;
                    return (float)(i + j) / (float)(2 * radius);
                }
            }
        }
        return 1.0f;
    }

    public static float getDistFactor(class_5281 worldIn, Function<class_2338, class_1959> biomePos, class_2338 pos, int radius, Predicate<class_1959.class_1961> isTargetBiome) {
        class_2338.class_2339 checkpos = new class_2338.class_2339();
        for (int i = 1; i <= radius; ++i) {
            for (int j = 0; j <= i; ++j) {
                for (class_2350 direction : class_2350.class_2353.field_11062) {
                    checkpos.method_10101((class_2382)pos).method_10104(direction, i).method_10104(direction.method_10170(), j);
                    if (BetterCavesUtils.isPosInWorld((class_2338)checkpos, worldIn) && isTargetBiome.test(biomePos.apply((class_2338)checkpos).method_8688())) {
                        return (float)(i + j) / (float)(2 * radius);
                    }
                    if (j == 0 || i == j) continue;
                    checkpos.method_10101((class_2382)pos).method_10104(direction, i).method_10104(direction.method_10160(), j);
                    if (!BetterCavesUtils.isPosInWorld((class_2338)checkpos, worldIn) || !isTargetBiome.test(biomePos.apply((class_2338)checkpos).method_8688())) continue;
                    return (float)(i + j) / (float)(2 * radius);
                }
            }
        }
        return 1.0f;
    }
}

