/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver.controller;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.config.util.ConfigHolder;
import com.yungnickyoung.minecraft.bettercaves.enums.CavernType;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseUtils;
import com.yungnickyoung.minecraft.bettercaves.util.BetterCavesUtils;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverNoiseRange;
import com.yungnickyoung.minecraft.bettercaves.world.carver.cavern.CavernCarver;
import com.yungnickyoung.minecraft.bettercaves.world.carver.cavern.CavernCarverBuilder;
import com.yungnickyoung.minecraft.yungsapi.noise.FastNoise;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_5281;

public class CavernCarverController {
    private class_5281 world;
    private FastNoise cavernRegionSampler;
    private List<CarverNoiseRange> noiseRanges = new ArrayList<CarverNoiseRange>();
    private boolean isDebugViewEnabled;
    private boolean isOverrideSurfaceDetectionEnabled;
    private boolean isFloodedUndergroundEnabled;

    public CavernCarverController(class_5281 worldIn, ConfigHolder config) {
        this.world = worldIn;
        this.isDebugViewEnabled = config.debugVisualizer.get();
        this.isOverrideSurfaceDetectionEnabled = config.overrideSurfaceDetection.get();
        this.isFloodedUndergroundEnabled = config.enableFloodedUnderground.get();
        float cavernRegionSize = this.calcCavernRegionSize(config.cavernRegionSize.get(), config.cavernRegionCustomSize.get().floatValue());
        this.cavernRegionSampler = new FastNoise();
        this.cavernRegionSampler.SetSeed((int)this.world.method_8412() + 333);
        this.cavernRegionSampler.SetFrequency(cavernRegionSize);
        ArrayList<CavernCarver> carvers = new ArrayList<CavernCarver>();
        carvers.add(new CavernCarverBuilder(this.world.method_8412()).ofTypeFromConfig(CavernType.LIQUID, config).debugVisualizerBlock(class_2246.field_10002.method_9564()).build());
        carvers.add(new CavernCarverBuilder(this.world.method_8412()).ofTypeFromConfig(CavernType.FLOORED, config).debugVisualizerBlock(class_2246.field_10205.method_9564()).build());
        float spawnChance = config.cavernSpawnChance.get().floatValue() / 100.0f;
        int totalPriority = carvers.stream().map(CavernCarver::getPriority).reduce(0, Integer::sum);
        BetterCaves.LOGGER.debug("CAVERN INFORMATION");
        BetterCaves.LOGGER.debug("--> SPAWN CHANCE SET TO: " + spawnChance);
        BetterCaves.LOGGER.debug("--> TOTAL PRIORITY: " + totalPriority);
        carvers.removeIf(carver -> carver.getPriority() == 0);
        float totalDeadzonePercent = 1.0f - spawnChance;
        float deadzonePercent = carvers.size() > 1 ? totalDeadzonePercent / (float)(carvers.size() - 1) : totalDeadzonePercent;
        BetterCaves.LOGGER.debug("--> DEADZONE PERCENT: " + deadzonePercent + "(" + totalDeadzonePercent + " TOTAL)");
        float currNoise = -1.0f;
        for (CavernCarver carver2 : carvers) {
            BetterCaves.LOGGER.debug("--> CARVER");
            float rangeCDFPercent = (float)carver2.getPriority() / (float)totalPriority * spawnChance;
            float topNoise = NoiseUtils.simplexNoiseOffsetByPercent(currNoise, rangeCDFPercent);
            CarverNoiseRange range = new CarverNoiseRange(currNoise, topNoise, carver2);
            this.noiseRanges.add(range);
            currNoise = NoiseUtils.simplexNoiseOffsetByPercent(topNoise, deadzonePercent);
            BetterCaves.LOGGER.debug("    --> RANGE PERCENT LENGTH WANTED: " + rangeCDFPercent);
            BetterCaves.LOGGER.debug("    --> RANGE FOUND: " + range);
        }
    }

    public void carveChunk(class_2791 chunk, int chunkX, int chunkZ, int[][] surfaceAltitudes, class_2680[][] liquidBlocks, Function<class_2338, class_1959> biomePos, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        if (this.noiseRanges.size() == 0) {
            return;
        }
        boolean flooded = false;
        float smoothAmpFloodFactor = 1.0f;
        for (int subX = 0; subX < 4; ++subX) {
            for (int subZ = 0; subZ < 4; ++subZ) {
                int startX = subX * 4;
                int startZ = subZ * 4;
                int endX = startX + 4 - 1;
                int endZ = startZ + 4 - 1;
                class_2338 startPos = new class_2338(chunkX * 16 + startX, 1, chunkZ * 16 + startZ);
                class_2338 endPos = new class_2338(chunkX * 16 + endX, 1, chunkZ * 16 + endZ);
                this.noiseRanges.forEach(range -> range.setNoiseCube(null));
                int maxHeight = 0;
                if (!this.isOverrideSurfaceDetectionEnabled) {
                    for (int x = startX; x < endX; ++x) {
                        for (int z = startZ; z < endZ; ++z) {
                            maxHeight = Math.max(maxHeight, surfaceAltitudes[x][z]);
                        }
                    }
                    for (CarverNoiseRange range2 : this.noiseRanges) {
                        CavernCarver carver = (CavernCarver)range2.getCarver();
                        maxHeight = Math.max(maxHeight, carver.getTopY());
                    }
                }
                for (int offsetX = 0; offsetX < 4; ++offsetX) {
                    block6: for (int offsetZ = 0; offsetZ < 4; ++offsetZ) {
                        int localX = startX + offsetX;
                        int localZ = startZ + offsetZ;
                        class_2338 colPos = new class_2338(chunkX * 16 + localX, 1, chunkZ * 16 + localZ);
                        if (this.isFloodedUndergroundEnabled && !this.isDebugViewEnabled && (double)(smoothAmpFloodFactor = BetterCavesUtils.getDistFactor(this.world, biomePos, colPos, 2, (flooded = biomePos.apply(colPos).method_8688() == class_1959.class_1961.field_9367) ? BetterCavesUtils.isNotOcean : BetterCavesUtils.isOcean)) <= 0.25) continue;
                        int surfaceAltitude = surfaceAltitudes[localX][localZ];
                        class_2680 liquidBlock = liquidBlocks[localX][localZ];
                        float cavernRegionNoise = this.cavernRegionSampler.GetNoise((float)colPos.method_10263(), (float)colPos.method_10260());
                        for (CarverNoiseRange range3 : this.noiseRanges) {
                            int topY;
                            if (!range3.contains(cavernRegionNoise)) continue;
                            CavernCarver carver = (CavernCarver)range3.getCarver();
                            int bottomY = carver.getBottomY();
                            int n = topY = this.isDebugViewEnabled ? carver.getTopY() : Math.min(surfaceAltitude, carver.getTopY());
                            if (this.isOverrideSurfaceDetectionEnabled) {
                                topY = carver.getTopY();
                                maxHeight = carver.getTopY();
                            }
                            float smoothAmp = range3.getSmoothAmp(cavernRegionNoise) * smoothAmpFloodFactor;
                            if (range3.getNoiseCube() == null) {
                                range3.setNoiseCube(carver.getNoiseGen().interpolateNoiseCube(startPos, endPos, bottomY, maxHeight));
                            }
                            double[][] noiseColumn = range3.getNoiseCube()[offsetX][offsetZ];
                            carver.carveColumn(chunk, colPos, topY, smoothAmp, noiseColumn, liquidBlock, flooded, flooded ? liquidCarvingMask : airCarvingMask);
                            continue block6;
                        }
                    }
                }
            }
        }
    }

    private float calcCavernRegionSize(String cavernRegionSize, float cavernRegionCustomSize) {
        switch (cavernRegionSize.toLowerCase()) {
            case "small": {
                return 0.01f;
            }
            case "large": {
                return 0.005f;
            }
            case "extralarge": {
                return 0.001f;
            }
            case "custom": {
                return cavernRegionCustomSize;
            }
        }
        return 0.007f;
    }

    public void setWorld(class_5281 worldIn) {
        this.world = worldIn;
    }
}

