/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory;

import com.google.gson.JsonObject;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class PowerFactory<P extends Power> {
    private final class_2960 id;
    private boolean hasConditions = false;
    protected SerializableData data;
    protected Function<SerializableData.Instance, BiFunction<PowerType<P>, class_1657, P>> factoryConstructor;

    public PowerFactory(class_2960 id, SerializableData data, Function<SerializableData.Instance, BiFunction<PowerType<P>, class_1657, P>> factoryConstructor) {
        this.id = id;
        this.data = data;
        this.factoryConstructor = factoryConstructor;
    }

    public PowerFactory<P> allowCondition() {
        if (!this.hasConditions) {
            this.hasConditions = true;
            this.data.add("condition", SerializableDataType.ENTITY_CONDITION, null);
        }
        return this;
    }

    public class_2960 getSerializerId() {
        return this.id;
    }

    public Instance read(JsonObject json) {
        return new Instance(this.data.read(json));
    }

    public Instance read(class_2540 buffer) {
        return new Instance(this.data.read(buffer));
    }

    public class Instance
    implements BiFunction<PowerType<P>, class_1657, P> {
        private final SerializableData.Instance dataInstance;

        private Instance(SerializableData.Instance data) {
            this.dataInstance = data;
        }

        public void write(class_2540 buf) {
            buf.method_10812(PowerFactory.this.id);
            PowerFactory.this.data.write(buf, this.dataInstance);
        }

        @Override
        public P apply(PowerType<P> pPowerType, class_1657 playerEntity) {
            BiFunction powerFactory = PowerFactory.this.factoryConstructor.apply(this.dataInstance);
            Power p = (Power)powerFactory.apply(pPowerType, playerEntity);
            if (PowerFactory.this.hasConditions && this.dataInstance.isPresent("condition")) {
                p.addCondition((ConditionFactory.Instance)this.dataInstance.get("condition"));
            }
            return p;
        }
    }
}

