/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.integration.rei;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.TransferRecipeDisplay;
import me.shedaniel.rei.server.ContainerInfo;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import ru.betterend.recipe.builders.AlloyingRecipe;
import ru.betterend.recipe.builders.InfusionRecipe;

public class REIInfusionDisplay
implements TransferRecipeDisplay {
    private final InfusionRecipe recipe;
    private final List<List<EntryStack>> input;
    private final List<EntryStack> output;
    private final int time;

    public REIInfusionDisplay(InfusionRecipe recipe) {
        this.recipe = recipe;
        this.input = Lists.newArrayList();
        this.output = Collections.singletonList(EntryStack.create((class_1799)recipe.method_8110()));
        this.time = recipe.getInfusionTime();
        recipe.method_8117().forEach(ingredient -> this.input.add(EntryStack.ofIngredient((class_1856)ingredient)));
    }

    public int getInfusionTime() {
        return this.time;
    }

    @NotNull
    public Optional<class_2960> getRecipeLocation() {
        return Optional.ofNullable(this.recipe).map(class_1860::method_8114);
    }

    @NotNull
    public List<List<EntryStack>> getInputEntries() {
        return this.input;
    }

    @NotNull
    public List<List<EntryStack>> getResultingEntries() {
        return Collections.singletonList(this.output);
    }

    @NotNull
    public class_2960 getRecipeCategory() {
        return AlloyingRecipe.ID;
    }

    @NotNull
    public List<List<EntryStack>> getRequiredEntries() {
        return this.input;
    }

    public int getWidth() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }

    public List<List<EntryStack>> getOrganisedInputEntries(ContainerInfo<class_1703> containerInfo, class_1703 container) {
        return this.input;
    }
}

