/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import net.adventurez.init.EffectInit;
import net.adventurez.init.ItemInit;
import net.adventurez.item.armor.StoneGolemArmor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4603;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_4603.class})
public abstract class InGameOverlayRendererMixin {
    private static final class_2960 WITHERED_TEXTURE = new class_2960("adventurez:textures/misc/dark.png");

    @Inject(method={"renderOverlays"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerEntity;isOnFire()Z")}, cancellable=true)
    private static void fireOverlayMixin(class_310 minecraftClient, class_4587 matrixStack, CallbackInfo info) {
        boolean fireActivated;
        class_746 playerEntity = minecraftClient.field_1724;
        class_1799 golemChestplate = playerEntity.method_6118(class_1304.field_6174);
        boolean bl = fireActivated = golemChestplate.method_7909().equals(ItemInit.STONE_GOLEM_CHESTPLATE) && StoneGolemArmor.fireTime(golemChestplate);
        if (fireActivated) {
            info.cancel();
        }
    }

    @Inject(method={"renderOverlays"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;enableAlphaTest()V")})
    private static void renderOverlaysMixin(class_310 minecraftClient, class_4587 matrixStack, CallbackInfo info) {
        class_746 playerEntity = minecraftClient.field_1724;
        if (playerEntity.method_6059(EffectInit.WITHERING)) {
            int duration = playerEntity.method_6112(EffectInit.WITHERING).method_5584();
            InGameOverlayRendererMixin.renderWitheredOverlay(minecraftClient, matrixStack, duration);
        }
    }

    private static void renderWitheredOverlay(class_310 minecraftClient, class_4587 matrixStack, int duration) {
        RenderSystem.enableTexture();
        minecraftClient.method_1531().method_22813(WITHERED_TEXTURE);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        float f = minecraftClient.field_1724.method_5718();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float m = -minecraftClient.field_1724.field_6031 / 64.0f;
        float n = minecraftClient.field_1724.field_5965 / 64.0f;
        class_1159 matrix4f = matrixStack.method_23760().method_23761();
        float colorBlend = (float)duration / 200.0f;
        bufferBuilder.method_1328(7, class_290.field_20887);
        bufferBuilder.method_22918(matrix4f, -1.0f, -1.0f, -0.5f).method_22915(f, f, f, colorBlend).method_22913(4.0f + m, 4.0f + n).method_1344();
        bufferBuilder.method_22918(matrix4f, 1.0f, -1.0f, -0.5f).method_22915(f, f, f, colorBlend).method_22913(0.0f + m, 4.0f + n).method_1344();
        bufferBuilder.method_22918(matrix4f, 1.0f, 1.0f, -0.5f).method_22915(f, f, f, colorBlend).method_22913(0.0f + m, 0.0f + n).method_1344();
        bufferBuilder.method_22918(matrix4f, -1.0f, 1.0f, -0.5f).method_22915(f, f, f, colorBlend).method_22913(4.0f + m, 0.0f + n).method_1344();
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
        RenderSystem.disableBlend();
    }
}

