/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.common.util.pool;

import java.util.concurrent.atomic.AtomicInteger;

public abstract class ReusableObject {
    private final AtomicInteger refCount = new AtomicInteger(0);

    final void acquireReference() {
        int count = this.refCount.getAndIncrement();
        if (count <= 0) {
            throw new IllegalStateException("Reference cannot be acquired after all others have been dropped");
        }
    }

    final boolean releaseReference() {
        int count = this.refCount.decrementAndGet();
        if (count < 0) {
            throw new IllegalStateException("No references are currently held");
        }
        return count == 0;
    }

    protected abstract void reset();

    public void acquireOwner() {
        if (!this.refCount.compareAndSet(0, 1)) {
            throw new IllegalStateException("Object in pool still has references");
        }
    }
}

