/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.config;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3037;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import net.minecraft.class_4970;

public class HangingColumnConfig
implements class_3037 {
    public static final Codec<HangingColumnConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)class_4651.field_24937.fieldOf("block_provider").forGetter(config -> config.blockProvider), (App)Codec.INT.fieldOf("min_length").forGetter(config -> config.minLength), (App)Codec.INT.fieldOf("max_length").forGetter(config -> config.maxLength), (App)class_2680.field_24734.listOf().fieldOf("whitelist").forGetter(config -> config.whitelist.stream().map(class_2248::method_9564).collect(Collectors.toList()))).apply((Applicative)codecRecorder, HangingColumnConfig::new));
    private final class_4651 blockProvider;
    private final int minLength;
    private final int maxLength;
    private final Set<class_2248> whitelist;

    HangingColumnConfig(class_4651 blockProvider, int minLength, int maxLength, List<class_2680> whitelist) {
        this.blockProvider = blockProvider;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.whitelist = whitelist.stream().map(class_4970.class_4971::method_26204).collect(Collectors.toSet());
    }

    public class_4651 getBlockProvider() {
        return this.blockProvider;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxPossibleLength() {
        int returnValue = this.minLength - this.maxLength;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return returnValue;
    }

    public Set<class_2248> getWhitelist() {
        return this.whitelist;
    }

    public static class Builder {
        private class_4651 blockProvider = new class_4656(class_2246.field_10503.method_9564());
        private List<class_2248> whitelist = ImmutableList.of((Object)class_2246.field_10219);
        private int minLength = 1;
        private int maxLength = 9;

        public Builder setBlock(class_2248 block) {
            this.blockProvider = block != null ? new class_4656(block.method_9564()) : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setBlock(class_2680 state) {
            this.blockProvider = state != null ? new class_4656(state) : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setBlock(class_4651 provider) {
            this.blockProvider = provider != null ? provider : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setMinLength(int minLength) {
            this.minLength = minLength;
            return this;
        }

        public Builder setMaxLength(int maxPossibleHeight) {
            this.maxLength = maxPossibleHeight != 0 ? maxPossibleHeight + 1 : 1;
            return this;
        }

        public Builder setWhitelist(ImmutableList<class_2248> whitelist) {
            this.whitelist = whitelist;
            return this;
        }

        public Builder copy(HangingColumnConfig config) {
            this.blockProvider = config.blockProvider;
            this.minLength = config.minLength;
            this.maxLength = config.maxLength;
            this.whitelist = ImmutableList.copyOf((Collection)config.whitelist);
            return this;
        }

        public HangingColumnConfig build() {
            return new HangingColumnConfig(this.blockProvider, this.minLength, this.maxLength, this.whitelist.stream().map(class_2248::method_9564).collect(Collectors.toList()));
        }
    }
}

