/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.command;

import com.google.common.base.Strings;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import doggytalents.common.command.arguments.UUIDArgument;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.item.RadarItem;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.DogRespawnData;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.storage.IDogData;
import doggytalents.common.util.Util;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class DogRespawnCommand {
    public static final DynamicCommandExceptionType COLOR_INVALID = new DynamicCommandExceptionType(arg -> new TranslationTextComponent("command.dogrespawn.invalid", new Object[]{arg}));
    public static final DynamicCommandExceptionType SPAWN_EXCEPTION = new DynamicCommandExceptionType(arg -> new TranslationTextComponent("command.dogrespawn.exception", new Object[]{arg}));
    public static final Dynamic2CommandExceptionType TOO_MANY_OPTIONS = new Dynamic2CommandExceptionType((arg1, arg2) -> new TranslationTextComponent("command.dogrespawn.imprecise", new Object[]{arg1, arg2}));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"dog").requires(s -> s.func_197034_c(2))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"locate").then(Commands.func_197057_a((String)"byuuid").then(Commands.func_197056_a((String)"dog_owner", (ArgumentType)UUIDArgument.uuid()).suggests(DogRespawnCommand.getOwnerIdSuggestionsLocate()).then(Commands.func_197056_a((String)"dog_uuid", (ArgumentType)UUIDArgument.uuid()).suggests(DogRespawnCommand.getDogIdSuggestionsLocate()).executes(c -> DogRespawnCommand.locate((CommandContext<CommandSource>)c)))))).then(Commands.func_197057_a((String)"byname").then(Commands.func_197056_a((String)"owner_name", (ArgumentType)StringArgumentType.string()).suggests(DogRespawnCommand.getOwnerNameSuggestionsLocate()).then(Commands.func_197056_a((String)"dog_name", (ArgumentType)StringArgumentType.string()).suggests(DogRespawnCommand.getDogNameSuggestionsLocate()).executes(c -> DogRespawnCommand.locate2((CommandContext<CommandSource>)c))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"revive").then(Commands.func_197057_a((String)"byuuid").then(Commands.func_197056_a((String)"dog_owner", (ArgumentType)UUIDArgument.uuid()).suggests(DogRespawnCommand.getOwnerIdSuggestionsRevive()).then(Commands.func_197056_a((String)"dog_uuid", (ArgumentType)UUIDArgument.uuid()).suggests(DogRespawnCommand.getDogIdSuggestionsRevive()).executes(c -> DogRespawnCommand.respawn((CommandContext<CommandSource>)c)))))).then(Commands.func_197057_a((String)"byname").then(Commands.func_197056_a((String)"owner_name", (ArgumentType)StringArgumentType.string()).suggests(DogRespawnCommand.getOwnerNameSuggestionsRevive()).then(Commands.func_197056_a((String)"dog_name", (ArgumentType)StringArgumentType.string()).suggests(DogRespawnCommand.getDogNameSuggestionsRevive()).executes(c -> DogRespawnCommand.respawn2((CommandContext<CommandSource>)c)))))));
    }

    public static void registerSerilizers() {
        ArgumentTypes.func_218136_a((String)Util.getResourcePath("uuid"), UUIDArgument.class, (IArgumentSerializer)new ArgumentSerializer(UUIDArgument::uuid));
    }

    private static <S extends ISuggestionProvider> SuggestionProvider<S> getOwnerIdSuggestionsLocate() {
        return (context, builder) -> DogRespawnCommand.getOwnerIdSuggestions(DogLocationStorage.get((World)((CommandSource)context.getSource()).func_197023_e()).getAll(), context, builder);
    }

    private static <S extends ISuggestionProvider> SuggestionProvider<S> getOwnerIdSuggestionsRevive() {
        return (context, builder) -> DogRespawnCommand.getOwnerIdSuggestions(DogRespawnStorage.get((World)((CommandSource)context.getSource()).func_197023_e()).getAll(), context, builder);
    }

    private static <S extends ISuggestionProvider> CompletableFuture<Suggestions> getOwnerIdSuggestions(Collection<? extends IDogData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof CommandSource) {
            return ISuggestionProvider.func_197005_b((Iterable)possibilities.stream().map(IDogData::getOwnerId).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof ISuggestionProvider) {
            return ((ISuggestionProvider)context.getSource()).func_197009_a(context, builder);
        }
        return Suggestions.empty();
    }

    private static <S extends ISuggestionProvider> SuggestionProvider<S> getDogIdSuggestionsLocate() {
        return (context, builder) -> DogRespawnCommand.getDogIdSuggestions(DogLocationStorage.get((World)((CommandSource)context.getSource()).func_197023_e()).getAll(), context, builder);
    }

    private static <S extends ISuggestionProvider> SuggestionProvider<S> getDogIdSuggestionsRevive() {
        return (context, builder) -> DogRespawnCommand.getDogIdSuggestions(DogRespawnStorage.get((World)((CommandSource)context.getSource()).func_197023_e()).getAll(), context, builder);
    }

    private static <S extends ISuggestionProvider> CompletableFuture<Suggestions> getDogIdSuggestions(Collection<? extends IDogData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof CommandSource) {
            UUID ownerId = (UUID)context.getArgument("dog_owner", UUID.class);
            if (ownerId == null) {
                return Suggestions.empty();
            }
            return ISuggestionProvider.func_197005_b((Iterable)possibilities.stream().filter(data -> ownerId.equals(data.getOwnerId())).map(IDogData::getDogId).map(Object::toString).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof ISuggestionProvider) {
            return ((ISuggestionProvider)context.getSource()).func_197009_a(context, builder);
        }
        return Suggestions.empty();
    }

    private static <S extends ISuggestionProvider> SuggestionProvider<S> getOwnerNameSuggestionsLocate() {
        return (context, builder) -> DogRespawnCommand.getOwnerNameSuggestions(DogLocationStorage.get((World)((CommandSource)context.getSource()).func_197023_e()).getAll(), context, builder);
    }

    private static <S extends ISuggestionProvider> SuggestionProvider<S> getOwnerNameSuggestionsRevive() {
        return (context, builder) -> DogRespawnCommand.getOwnerNameSuggestions(DogRespawnStorage.get((World)((CommandSource)context.getSource()).func_197023_e()).getAll(), context, builder);
    }

    public static <S extends ISuggestionProvider> CompletableFuture<Suggestions> getOwnerNameSuggestions(Collection<? extends IDogData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof CommandSource) {
            return ISuggestionProvider.func_197005_b((Iterable)possibilities.stream().map(IDogData::getOwnerName).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof ISuggestionProvider) {
            return ((ISuggestionProvider)context.getSource()).func_197009_a(context, builder);
        }
        return Suggestions.empty();
    }

    private static <S extends ISuggestionProvider> SuggestionProvider<S> getDogNameSuggestionsLocate() {
        return (context, builder) -> DogRespawnCommand.getDogNameSuggestions(DogLocationStorage.get((World)((CommandSource)context.getSource()).func_197023_e()).getAll(), context, builder);
    }

    private static <S extends ISuggestionProvider> SuggestionProvider<S> getDogNameSuggestionsRevive() {
        return (context, builder) -> DogRespawnCommand.getDogNameSuggestions(DogRespawnStorage.get((World)((CommandSource)context.getSource()).func_197023_e()).getAll(), context, builder);
    }

    public static <S extends ISuggestionProvider> CompletableFuture<Suggestions> getDogNameSuggestions(Collection<? extends IDogData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof CommandSource) {
            String ownerName = (String)context.getArgument("owner_name", String.class);
            if (ownerName == null) {
                return Suggestions.empty();
            }
            return ISuggestionProvider.func_197005_b((Iterable)possibilities.stream().filter(data -> ownerName.equals(data.getOwnerName())).map(IDogData::getDogName).filter(str -> !Strings.isNullOrEmpty((String)str)).collect(Collectors.toList()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof ISuggestionProvider) {
            return ((ISuggestionProvider)context.getSource()).func_197009_a(context, builder);
        }
        return Suggestions.empty();
    }

    private static int respawn(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        CommandSource source = (CommandSource)ctx.getSource();
        source.func_197035_h();
        ServerWorld world = source.func_197023_e();
        UUID ownerUuid = (UUID)ctx.getArgument("dog_owner", UUID.class);
        UUID uuid = (UUID)ctx.getArgument("dog_uuid", UUID.class);
        DogRespawnStorage respawnStorage = DogRespawnStorage.get((World)world);
        DogRespawnData respawnData = respawnStorage.getData(uuid);
        if (respawnData == null) {
            throw COLOR_INVALID.create((Object)uuid.toString());
        }
        return DogRespawnCommand.respawn(respawnStorage, respawnData, source);
    }

    private static int respawn2(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        CommandSource source = (CommandSource)ctx.getSource();
        source.func_197035_h();
        ServerWorld world = source.func_197023_e();
        String ownerName = (String)ctx.getArgument("owner_name", String.class);
        String dogName = (String)ctx.getArgument("dog_name", String.class);
        DogRespawnStorage respawnStorage = DogRespawnStorage.get((World)world);
        List respawnData = respawnStorage.getDogs(ownerName).filter(data -> data.getDogName().equalsIgnoreCase(dogName)).collect(Collectors.toList());
        if (respawnData.isEmpty()) {
            throw COLOR_INVALID.create((Object)dogName);
        }
        if (respawnData.size() > 1) {
            StringJoiner joiner = new StringJoiner(", ");
            for (DogRespawnData data2 : respawnData) {
                joiner.add(Objects.toString(data2.getDogId()));
            }
            throw TOO_MANY_OPTIONS.create((Object)joiner.toString(), (Object)respawnData.size());
        }
        return DogRespawnCommand.respawn(respawnStorage, (DogRespawnData)respawnData.get(0), source);
    }

    private static int respawn(DogRespawnStorage respawnStorage, DogRespawnData respawnData, CommandSource source) throws CommandSyntaxException {
        DogEntity dog = respawnData.respawn(source.func_197023_e(), (PlayerEntity)source.func_197035_h(), source.func_197035_h().func_233580_cy_().func_177984_a());
        if (dog != null) {
            respawnStorage.remove(respawnData.getDogId());
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.dogrespawn.uuid.success", new Object[]{respawnData.getDogName()}), false);
            return 1;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.dogrespawn.uuid.failure", new Object[]{respawnData.getDogName()}), false);
        return 0;
    }

    private static int locate(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        CommandSource source = (CommandSource)ctx.getSource();
        source.func_197035_h();
        ServerWorld world = source.func_197023_e();
        UUID ownerUuid = (UUID)ctx.getArgument("dog_owner", UUID.class);
        UUID uuid = (UUID)ctx.getArgument("dog_uuid", UUID.class);
        DogLocationStorage locationStorage = DogLocationStorage.get((World)world);
        DogLocationData locationData = locationStorage.getData(uuid);
        if (locationData == null) {
            throw COLOR_INVALID.create((Object)uuid.toString());
        }
        return DogRespawnCommand.locate(locationStorage, locationData, source);
    }

    private static int locate2(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        CommandSource source = (CommandSource)ctx.getSource();
        source.func_197035_h();
        ServerWorld world = source.func_197023_e();
        String ownerName = (String)ctx.getArgument("owner_name", String.class);
        String dogName = (String)ctx.getArgument("dog_name", String.class);
        DogLocationStorage locationStorage = DogLocationStorage.get((World)world);
        List locationData = locationStorage.getAll().stream().filter(data -> ownerName.equals(data.getOwnerName())).filter(data -> data.getDogName().equalsIgnoreCase(dogName)).collect(Collectors.toList());
        if (locationData.isEmpty()) {
            throw COLOR_INVALID.create((Object)dogName);
        }
        if (locationData.size() > 1) {
            StringJoiner joiner = new StringJoiner(", ");
            for (DogLocationData data2 : locationData) {
                joiner.add(Objects.toString(data2.getDogId()));
            }
            throw TOO_MANY_OPTIONS.create((Object)joiner.toString(), (Object)locationData.size());
        }
        return DogRespawnCommand.locate(locationStorage, (DogLocationData)locationData.get(0), source);
    }

    private static int locate(DogLocationStorage respawnStorage, DogLocationData locationData, CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        if (locationData.getDimension().equals((Object)player.field_70170_p.func_234923_W_())) {
            String translateStr = RadarItem.getDirectionTranslationKey(locationData, (Entity)player);
            int distance = MathHelper.func_76143_f((double)(locationData.getPos() != null ? locationData.getPos().func_72438_d(player.func_213303_ch()) : -1.0));
            source.func_197030_a((ITextComponent)new TranslationTextComponent(translateStr, new Object[]{locationData.getName(player.field_70170_p), distance}), false);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("dogradar.notindim", new Object[]{locationData.getDimension()}), false);
        }
        return 1;
    }
}

