/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.config;

import doggytalents.DoggyTalents2;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.Talent;
import doggytalents.common.config.ConfigValues;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    private static ClientConfig CLIENT;
    private static ServerConfig SERVER;
    private static TalentConfig TALENT;
    private static ForgeConfigSpec CONFIG_SERVER_SPEC;
    private static ForgeConfigSpec CONFIG_CLIENT_SPEC;
    private static ForgeConfigSpec CONFIG_TALENT_SPEC;

    public static void init(IEventBus modEventBus) {
        Pair commonPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        CONFIG_SERVER_SPEC = (ForgeConfigSpec)commonPair.getRight();
        SERVER = (ServerConfig)commonPair.getLeft();
        Pair clientPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CONFIG_CLIENT_SPEC = (ForgeConfigSpec)clientPair.getRight();
        CLIENT = (ClientConfig)clientPair.getLeft();
        DoggyTalents2.LOGGER.debug("Register configs");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, CONFIG_SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CONFIG_CLIENT_SPEC);
        modEventBus.addListener(ConfigHandler::loadConfig);
        modEventBus.addListener(ConfigHandler::reloadConfig);
    }

    public static void initTalentConfig() {
        Pair talentPair = new ForgeConfigSpec.Builder().configure(TalentConfig::new);
        CONFIG_TALENT_SPEC = (ForgeConfigSpec)talentPair.getRight();
        TALENT = (TalentConfig)talentPair.getLeft();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, CONFIG_TALENT_SPEC, "doggytalents-talents.toml");
    }

    public static void loadConfig(ModConfig.Loading event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == CONFIG_CLIENT_SPEC) {
            ConfigHandler.refreshClient();
        } else if (config.getSpec() == CONFIG_SERVER_SPEC) {
            ConfigHandler.refreshServer();
        } else if (config.getSpec() == CONFIG_TALENT_SPEC) {
            ConfigHandler.refreshTalents();
        }
    }

    public static void reloadConfig(ModConfig.Reloading event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == CONFIG_CLIENT_SPEC) {
            ConfigHandler.refreshClient();
        } else if (config.getSpec() == CONFIG_SERVER_SPEC) {
            ConfigHandler.refreshServer();
        } else if (config.getSpec() == CONFIG_TALENT_SPEC) {
            ConfigHandler.refreshTalents();
        }
    }

    public static void refreshServer() {
        DoggyTalents2.LOGGER.debug("Refresh Common Config");
        ConfigValues.DISABLE_HUNGER = (Boolean)ConfigHandler.SERVER.DISABLE_HUNGER.get();
        ConfigValues.STARTING_ITEMS = (Boolean)ConfigHandler.SERVER.STARTING_ITEMS.get();
        ConfigValues.DOG_GENDER = (Boolean)ConfigHandler.SERVER.DOG_GENDER.get();
        ConfigValues.PUPS_GET_PARENT_LEVELS = (Boolean)ConfigHandler.SERVER.PUPS_GET_PARENT_LEVELS.get();
    }

    public static void refreshClient() {
        DoggyTalents2.LOGGER.debug("Refresh Client Config");
        ConfigValues.DIRE_PARTICLES = (Boolean)ConfigHandler.CLIENT.DIRE_PARTICLES.get();
        ConfigValues.RENDER_CHEST = (Boolean)ConfigHandler.CLIENT.RENDER_CHEST.get();
        ConfigValues.USE_DT_TEXTURES = (Boolean)ConfigHandler.CLIENT.USE_DT_TEXTURES.get();
    }

    public static void refreshTalents() {
        DoggyTalents2.LOGGER.debug("Refresh Talents Config");
        ConfigValues.DISABLED_TALENTS.clear();
        ConfigHandler.TALENT.DISABLED_TALENTS.forEach((talent, val) -> {
            if (!((Boolean)val.get()).booleanValue()) {
                ConfigValues.DISABLED_TALENTS.add((Talent)((Object)talent));
            }
        });
    }

    static class TalentConfig {
        public Map<Talent, ForgeConfigSpec.BooleanValue> DISABLED_TALENTS;

        public TalentConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Here you can disable talents.").push("Talents");
            this.DISABLED_TALENTS = new HashMap<Talent, ForgeConfigSpec.BooleanValue>();
            DoggyTalentsAPI.TALENTS.forEach(loc -> this.DISABLED_TALENTS.put((Talent)((Object)loc), builder.define(loc.getRegistryName().toString(), true)));
            builder.pop();
        }
    }

    static class ServerConfig {
        public ForgeConfigSpec.BooleanValue DISABLE_HUNGER;
        public ForgeConfigSpec.BooleanValue STARTING_ITEMS;
        public ForgeConfigSpec.BooleanValue DOG_GENDER;
        public ForgeConfigSpec.BooleanValue PUPS_GET_PARENT_LEVELS;
        public Map<String, ForgeConfigSpec.BooleanValue> DISABLED_TALENTS;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            builder.pop();
            builder.push("Dog Constants");
            this.DISABLE_HUNGER = builder.comment("Disable hunger mode for the dog").translation("doggytalents.config.dog.disable_hunger").define("disable_hunger", false);
            this.STARTING_ITEMS = builder.comment("When enabled you will spawn with a guide, Doggy Charm and Command Emblem.").translation("doggytalents.config.enable_starting_items").define("enable_starting_items", false);
            this.DOG_GENDER = builder.comment("When enabled, dogs will be randomly assigned genders and will only mate and produce children with the opposite gender.").translation("doggytalents.config.enable_gender").define("enable_gender", true);
            this.PUPS_GET_PARENT_LEVELS = builder.comment("When enabled, puppies get some levels from parents. When disabled, puppies start at 0 points.").translation("doggytalents.config.enable_pup_get_parent_levels").define("enable_pup_get_parent_levels", false);
            builder.pop();
        }
    }

    static class ClientConfig {
        public ForgeConfigSpec.BooleanValue DIRE_PARTICLES;
        public ForgeConfigSpec.BooleanValue RENDER_CHEST;
        public ForgeConfigSpec.BooleanValue USE_DT_TEXTURES;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            builder.pop();
            builder.push("Dog Render");
            this.DIRE_PARTICLES = builder.comment("Enables the particle effect on Dire Level 30 dogs.").translation("doggytalents.config.client.enable_dire_particles").define("enable_dire_particles", true);
            this.RENDER_CHEST = builder.comment("When enabled, dogs with points in pack puppy will have chests on their side.").translation("doggytalents.config.client.render_chest").define("render_chest", true);
            this.USE_DT_TEXTURES = builder.comment("If disabled will use the default minecraft wolf skin for all dog textures.").translation("doggytalents.config.client.enable_dt_textures").define("enable_dt_textures", true);
            builder.pop();
        }
    }
}

