/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.feature.EnumMode;
import doggytalents.api.inferface.IThrowableItem;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.util.EntityUtil;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.world.World;

public class DogFollowOwnerGoal
extends Goal {
    private final DogEntity dog;
    private final PathNavigator navigator;
    private final World world;
    private final double followSpeed;
    private final float stopDist;
    private final float startDist;
    private LivingEntity owner;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public DogFollowOwnerGoal(DogEntity dogIn, double speedIn, float minDistIn, float maxDistIn) {
        this.dog = dogIn;
        this.world = dogIn.field_70170_p;
        this.followSpeed = speedIn;
        this.navigator = dogIn.func_70661_as();
        this.startDist = minDistIn;
        this.stopDist = maxDistIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity owner = this.dog.func_70902_q();
        if (owner == null) {
            return false;
        }
        if (this.dog.getMode() == EnumMode.PATROL) {
            return false;
        }
        if (owner.func_175149_v()) {
            return false;
        }
        if (this.dog.func_233684_eK_()) {
            return false;
        }
        if (!this.dog.hasBone() && this.dog.func_70068_e((Entity)owner) < (double)this.getMinStartDistanceSq()) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean func_75253_b() {
        if (this.navigator.func_75500_f()) {
            return false;
        }
        if (this.dog.func_233684_eK_()) {
            return false;
        }
        return this.dog.func_70068_e((Entity)this.owner) > (double)(this.stopDist * this.stopDist);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.dog.func_184643_a(PathNodeType.WATER);
        this.dog.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        double distanceToOwner;
        if (this.dog.hasBone() && (distanceToOwner = this.owner.func_70068_e((Entity)this.dog)) <= (double)(this.stopDist * this.stopDist)) {
            IThrowableItem throwableItem = this.dog.getThrowableItem();
            ItemStack fetchItem = throwableItem != null ? throwableItem.getReturnStack(this.dog.getBoneVariant()) : this.dog.getBoneVariant();
            this.dog.func_70099_a(fetchItem, 0.0f);
            this.dog.setBoneVariant(ItemStack.field_190927_a);
        }
        this.owner = null;
        this.navigator.func_75499_g();
        this.dog.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.dog.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.dog.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.dog.func_110167_bD() && !this.dog.func_184218_aH()) {
                if (this.dog.func_70068_e((Entity)this.owner) >= 144.0) {
                    EntityUtil.tryToTeleportNearEntity((LivingEntity)this.dog, this.navigator, this.owner, 4);
                } else {
                    this.navigator.func_75497_a((Entity)this.owner, this.followSpeed);
                }
            }
        }
    }

    public float getMinStartDistanceSq() {
        if (this.dog.isMode(EnumMode.GUARD)) {
            return 4.0f;
        }
        return this.startDist * this.startDist;
    }
}

