/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.DogEntity;
import doggytalents.common.util.EntityUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;

public class MoveToClosestItemGoal
extends Goal {
    protected final DogEntity dog;
    protected final Predicate<ItemEntity> predicate;
    protected final Comparator<Entity> sorter;
    protected final double followSpeed;
    protected final PathNavigator dogNavigator;
    protected final float minDist;
    protected ItemEntity target;
    private int timeToRecalcPath;
    private float maxDist;
    private float oldWaterCost;
    private double oldRangeSense;

    public MoveToClosestItemGoal(DogEntity dogIn, double speedIn, float maxDist, float stopDist, @Nullable Predicate<ItemStack> targetSelector) {
        this.dog = dogIn;
        this.dogNavigator = dogIn.func_70661_as();
        this.followSpeed = speedIn;
        this.maxDist = maxDist;
        this.minDist = stopDist;
        this.predicate = entity -> {
            if (entity.func_82150_aj()) {
                return false;
            }
            if (targetSelector != null && !targetSelector.test(entity.func_92059_d())) {
                return false;
            }
            return (double)entity.func_70032_d((Entity)this.dog) <= EntityUtil.getFollowRange((LivingEntity)this.dog);
        };
        this.sorter = new EntityUtil.Sorter((Entity)dogIn);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        double d0 = EntityUtil.getFollowRange((LivingEntity)this.dog);
        List list = this.dog.field_70170_p.func_175647_a(ItemEntity.class, this.dog.func_174813_aQ().func_72314_b(d0, 4.0, d0), this.predicate);
        if (list.isEmpty()) {
            return false;
        }
        Collections.sort(list, this.sorter);
        this.target = (ItemEntity)list.get(0);
        return true;
    }

    public boolean func_75253_b() {
        ItemEntity target = this.target;
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        double d0 = EntityUtil.getFollowRange((LivingEntity)this.dog);
        double dist = this.dog.func_70068_e((Entity)target);
        return !(dist > d0 * d0) && !(dist < (double)(this.minDist * this.minDist));
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.dog.func_184643_a(PathNodeType.WATER);
        this.dog.func_184644_a(PathNodeType.WATER, 0.0f);
        this.oldRangeSense = this.dog.func_110148_a(Attributes.field_233819_b_).func_111126_e();
        this.dog.func_110148_a(Attributes.field_233819_b_).func_111128_a((double)this.maxDist);
    }

    public void func_75246_d() {
        if (!this.dog.func_233684_eK_() && --this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.dogNavigator.func_75497_a((Entity)this.target, this.followSpeed)) {
                this.dog.func_70671_ap().func_75651_a((Entity)this.target, 10.0f, (float)this.dog.func_70646_bf());
            }
        }
    }

    public void func_75251_c() {
        this.target = null;
        this.dogNavigator.func_75499_g();
        this.dog.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
        this.dog.func_110148_a(Attributes.field_233819_b_).func_111128_a(this.oldRangeSense);
    }
}

