/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;

public class GuardDogTalent
extends TalentInstance {
    private int cooldown;

    public GuardDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public TalentInstance copy() {
        GuardDogTalent inst = new GuardDogTalent(this.getTalent(), this.level);
        inst.cooldown = this.cooldown;
        return inst;
    }

    @Override
    public void init(AbstractDogEntity dogIn) {
        this.cooldown = dogIn.field_70173_aa;
    }

    @Override
    public void writeToNBT(AbstractDogEntity dogIn, CompoundNBT compound) {
        super.writeToNBT(dogIn, compound);
        int timeLeft = this.cooldown - dogIn.field_70173_aa;
        compound.func_74768_a("guardtime", timeLeft);
    }

    @Override
    public void readFromNBT(AbstractDogEntity dogIn, CompoundNBT compound) {
        super.readFromNBT(dogIn, compound);
        this.cooldown = dogIn.field_70173_aa + compound.func_74762_e("guardtime");
    }

    @Override
    public ActionResult<Float> attackEntityFrom(AbstractDogEntity dogIn, DamageSource damageSource, float damage) {
        int timeLeft;
        if (dogIn.field_70170_p.field_72995_K) {
            return ActionResult.func_226250_c_((Object)Float.valueOf(damage));
        }
        Entity entity = damageSource.func_76346_g();
        if (entity != null && (timeLeft = this.cooldown - dogIn.field_70173_aa) <= 0) {
            int blockChance = this.level() + (this.level() >= 5 ? 1 : 0);
            if (dogIn.func_70681_au().nextInt(12) < blockChance) {
                this.cooldown = dogIn.field_70173_aa + 10;
                dogIn.func_184185_a(SoundEvents.field_187635_cQ, dogIn.func_70599_aP() / 2.0f, (dogIn.func_70681_au().nextFloat() - dogIn.func_70681_au().nextFloat()) * 0.2f + 1.0f);
                return ActionResult.func_226251_d_((Object)Float.valueOf(0.0f));
            }
        }
        return ActionResult.func_226250_c_((Object)Float.valueOf(damage));
    }
}

