/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.shape.Shape;
import brentmaas.buildguide.common.shape.ShapeSet;

public abstract class AbstractRenderHandler {
    public abstract void register();

    public abstract void renderShapeBuffer(Shape var1);

    protected abstract void setupRenderingShapeSet(ShapeSet var1);

    protected abstract void endRenderingShape();

    protected abstract boolean isCompatibilityProfile();

    protected abstract boolean textureEnabled();

    protected abstract boolean depthTestEnabled();

    protected abstract boolean depthMaskEnabled();

    protected abstract boolean blendEnabled();

    protected abstract void setTexture(boolean var1);

    protected abstract void setDepthTest(boolean var1);

    protected abstract void setDepthMask(boolean var1);

    protected abstract void setBlend(boolean var1);

    protected abstract void setupNotCulling();

    protected abstract void setupBlendFunc();

    protected abstract void pushProfiler(String var1);

    protected abstract void popProfiler();

    public void render() {
        this.pushProfiler("buildguide");
        if (BuildGuide.stateManager.getState().enabled && BuildGuide.stateManager.getState().isShapeAvailable() && BuildGuide.stateManager.getState().getCurrentShapeSet().origin != null) {
            for (ShapeSet s : BuildGuide.stateManager.getState().shapeSets) {
                this.renderShapeSet(s);
            }
        }
        this.popProfiler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderShapeSet(ShapeSet shapeSet) {
        if (shapeSet.getShape().lock.tryLock()) {
            try {
                if (shapeSet.visible && shapeSet.getShape().ready && !shapeSet.getShape().error) {
                    boolean toggleBlend;
                    if (!shapeSet.getShape().vertexBufferUnpacked) {
                        shapeSet.getShape().buffer.end();
                        shapeSet.getShape().vertexBufferUnpacked = true;
                    }
                    this.setupRenderingShapeSet(shapeSet);
                    boolean toggleTexture = this.isCompatibilityProfile() && this.textureEnabled();
                    boolean hasDepthTest = this.depthTestEnabled();
                    boolean toggleDepthTest = BuildGuide.stateManager.getState().depthTest ^ hasDepthTest;
                    boolean toggleDepthMask = this.depthMaskEnabled();
                    boolean bl = toggleBlend = !this.blendEnabled();
                    if (toggleTexture) {
                        this.setTexture(false);
                    }
                    if (toggleDepthTest && hasDepthTest) {
                        this.setDepthTest(false);
                    } else if (toggleDepthTest) {
                        this.setDepthTest(true);
                    }
                    if (toggleDepthMask) {
                        this.setDepthMask(false);
                    }
                    this.setupNotCulling();
                    this.setupBlendFunc();
                    if (toggleBlend) {
                        this.setBlend(true);
                    }
                    this.renderShapeBuffer(shapeSet.getShape());
                    if (toggleBlend) {
                        this.setBlend(false);
                    }
                    if (toggleDepthTest && hasDepthTest) {
                        this.setDepthTest(true);
                    } else if (toggleDepthTest) {
                        this.setDepthTest(false);
                    }
                    if (toggleDepthMask) {
                        this.setDepthMask(true);
                    }
                    if (toggleTexture) {
                        this.setTexture(true);
                    }
                    this.endRenderingShape();
                }
            }
            finally {
                shapeSet.getShape().lock.unlock();
            }
        }
    }
}

