/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.forge;

import brentmaas.buildguide.common.AbstractRenderHandler;
import brentmaas.buildguide.common.shape.Shape;
import brentmaas.buildguide.common.shape.ShapeSet;
import brentmaas.buildguide.forge.shape.ShapeBuffer;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL32;

public class RenderHandler
extends AbstractRenderHandler {
    private PoseStack poseStackInstance;
    private Matrix4f projectionMatrixInstance;

    @Override
    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRenderBlock(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            this.poseStackInstance = event.getPoseStack();
            this.projectionMatrixInstance = event.getProjectionMatrix();
            this.render();
        }
    }

    @Override
    public void renderShapeBuffer(Shape shape) {
        ((ShapeBuffer)shape.buffer).render(this.poseStackInstance.m_85850_().m_252922_(), this.projectionMatrixInstance);
    }

    @Override
    protected void setupRenderingShapeSet(ShapeSet shapeSet) {
        this.poseStackInstance.m_85836_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        this.poseStackInstance.m_85837_(-projectedView.f_82479_ + (double)shapeSet.origin.x, -projectedView.f_82480_ + (double)shapeSet.origin.y, -projectedView.f_82481_ + (double)shapeSet.origin.z);
    }

    @Override
    protected void endRenderingShape() {
        this.poseStackInstance.m_85849_();
    }

    @Override
    protected boolean isCompatibilityProfile() {
        return GL32.glGetInteger((int)37158) == 2;
    }

    @Override
    protected boolean textureEnabled() {
        return GL32.glIsEnabled((int)3553);
    }

    @Override
    protected boolean depthTestEnabled() {
        return GL32.glIsEnabled((int)2929);
    }

    @Override
    protected boolean depthMaskEnabled() {
        return GL32.glGetBoolean((int)2930);
    }

    @Override
    protected boolean blendEnabled() {
        return GL32.glIsEnabled((int)3042);
    }

    @Override
    protected void setTexture(boolean enabled) {
    }

    @Override
    protected void setDepthTest(boolean enabled) {
        if (enabled) {
            RenderSystem.enableDepthTest();
        } else {
            RenderSystem.disableDepthTest();
        }
    }

    @Override
    protected void setDepthMask(boolean enabled) {
        RenderSystem.depthMask((boolean)enabled);
    }

    @Override
    protected void setBlend(boolean enabled) {
        if (enabled) {
            RenderSystem.enableBlend();
        } else {
            RenderSystem.disableBlend();
        }
    }

    @Override
    protected void setupNotCulling() {
        RenderSystem.polygonMode((int)1032, (int)6914);
    }

    @Override
    protected void setupBlendFunc() {
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    @Override
    protected void pushProfiler(String key) {
        Minecraft.m_91087_().m_91307_().m_6180_(key);
    }

    @Override
    protected void popProfiler() {
        Minecraft.m_91087_().m_91307_().m_7238_();
    }
}

