/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import fuzs.mutantmonsters.client.MutantMonstersClient;
import fuzs.mutantmonsters.client.init.ClientModRegistry;
import fuzs.mutantmonsters.client.model.MutantSnowGolemModel;
import fuzs.mutantmonsters.client.renderer.MutantRenderTypes;
import fuzs.mutantmonsters.world.entity.mutant.MutantSnowGolem;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_927;

public class MutantSnowGolemRenderer
extends class_927<MutantSnowGolem, MutantSnowGolemModel> {
    static final class_2960 TEXTURE = MutantMonstersClient.entityTexture("mutant_snow_golem/mutant_snow_golem");
    private static final class_2960 JACK_O_LANTERN_TEXTURE = MutantMonstersClient.entityTexture("mutant_snow_golem/jack_o_lantern");
    private static final class_1921 GLOW_RENDER_TYPE = MutantRenderTypes.eyes(MutantMonstersClient.entityTexture("mutant_snow_golem/glow"));

    public MutantSnowGolemRenderer(class_5617.class_5618 context) {
        super(context, (class_583)new MutantSnowGolemModel(context.method_32167(ClientModRegistry.MUTANT_SNOW_GOLEM)), 0.7f);
        this.method_4046(new JackOLanternLayer((class_3883<MutantSnowGolem, MutantSnowGolemModel>)this, context.method_32170()));
        this.method_4046(new HeldBlockLayer((class_3883<MutantSnowGolem, MutantSnowGolemModel>)this, context.method_43337()));
    }

    public void render(MutantSnowGolem entityIn, float entityYaw, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        super.method_4072((class_1308)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        class_1657 owner = entityIn.getOwner();
        if (owner != null) {
            matrixStackIn.method_22903();
            if (this.method_4071((class_1308)entityIn)) {
                matrixStackIn.method_22904(0.0, (double)0.25875f, 0.0);
            }
            this.method_3926((class_1297)entityIn, (class_2561)owner.method_5476().method_27661().method_27694(style -> style.method_10978(Boolean.valueOf(true))), matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.method_22909();
        }
    }

    public class_2960 getTextureLocation(MutantSnowGolem entity) {
        return TEXTURE;
    }

    static class JackOLanternLayer
    extends class_3887<MutantSnowGolem, MutantSnowGolemModel> {
        private final MutantSnowGolemModel headModel;

        public JackOLanternLayer(class_3883<MutantSnowGolem, MutantSnowGolemModel> entityRendererIn, class_5599 entityModelSet) {
            super(entityRendererIn);
            this.headModel = new MutantSnowGolemModel(entityModelSet.method_32072(ClientModRegistry.MUTANT_SNOW_GOLEM_HEAD)).setRenderHeadOnly();
        }

        public void render(class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, MutantSnowGolem livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (livingEntity.hasJackOLantern()) {
                if (!livingEntity.method_5767()) {
                    ((MutantSnowGolemModel)this.method_17165()).copyPropertiesTo(this.headModel);
                    JackOLanternLayer.method_23199((class_583)this.headModel, (class_2960)JACK_O_LANTERN_TEXTURE, (class_4587)matrixStackIn, (class_4597)bufferIn, (int)packedLightIn, (class_1309)livingEntity, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                float green = Math.max(0.0f, 0.8f + 0.05f * class_3532.method_15362((float)(ageInTicks * 0.15f)));
                float blue = Math.max(0.0f, 0.15f + 0.2f * class_3532.method_15362((float)(ageInTicks * 0.1f)));
                class_4588 ivertexbuilder = bufferIn.getBuffer(GLOW_RENDER_TYPE);
                ((MutantSnowGolemModel)this.method_17165()).method_2828(matrixStackIn, ivertexbuilder, 0xF00000, class_4608.field_21444, 1.0f, green, blue, 1.0f);
            }
        }
    }

    static class HeldBlockLayer
    extends class_3887<MutantSnowGolem, MutantSnowGolemModel> {
        private final class_776 blockRenderer;

        public HeldBlockLayer(class_3883<MutantSnowGolem, MutantSnowGolemModel> entityRendererIn, class_776 blockRenderer) {
            super(entityRendererIn);
            this.blockRenderer = blockRenderer;
        }

        public void render(class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, MutantSnowGolem livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (livingEntity.isThrowing() && livingEntity.getThrowingTick() < 7) {
                matrixStackIn.method_22903();
                boolean leftHanded = livingEntity.method_5961();
                float scale = Math.min(0.8f, ((float)livingEntity.getThrowingTick() + partialTicks) / 7.0f);
                matrixStackIn.method_22904(leftHanded ? -0.4 : 0.4, 0.0, 0.0);
                ((MutantSnowGolemModel)this.method_17165()).translateArm(leftHanded, matrixStackIn);
                matrixStackIn.method_22904(0.0, 0.9, 0.0);
                matrixStackIn.method_22905(-scale, -scale, scale);
                matrixStackIn.method_22904(-0.5, -0.5, 0.5);
                matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                this.blockRenderer.method_3353(class_2246.field_10295.method_9564(), matrixStackIn, bufferIn, packedLightIn, class_4608.field_21444);
                matrixStackIn.method_22909();
            }
        }
    }
}

