/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells;

import appeng.api.client.StorageCellModels;
import appeng.api.networking.GridServices;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.upgrades.Upgrades;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.GuiText;
import appeng.hotkeys.HotkeyActions;
import gripe._90.megacells.core.Addons;
import gripe._90.megacells.core.Platform;
import gripe._90.megacells.definition.MEGABlockEntities;
import gripe._90.megacells.definition.MEGABlocks;
import gripe._90.megacells.definition.MEGAConfig;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.integration.ae2wt.AE2WTIntegration;
import gripe._90.megacells.integration.appbot.AppBotIntegration;
import gripe._90.megacells.integration.appbot.AppBotItems;
import gripe._90.megacells.item.cell.BulkCellItem;
import gripe._90.megacells.misc.DecompressionService;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MEGACells {
    public static final String MODID = "megacells";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"MEGA Cells");
    public static final Platform PLATFORM = ServiceLoader.load(Platform.class).findFirst().orElseThrow();
    public static final Platform.Client PLATFORM_CLIENT = PLATFORM.isClient() ? ServiceLoader.load(Platform.Client.class).findFirst().orElseThrow() : null;

    private MEGACells() {
    }

    public static class_2960 makeId(String path) {
        return new class_2960(MODID, path);
    }

    public static void initCommon() {
        MEGAConfig.load();
        MEGAItems.init();
        MEGABlocks.init();
        MEGABlockEntities.init();
        if (PLATFORM.isAddonLoaded(Addons.APPBOT)) {
            AppBotItems.init();
        }
        StorageCells.addCellHandler((ICellHandler)BulkCellItem.HANDLER);
        MEGAItems.getItemPortables().forEach(cell -> HotkeyActions.registerPortableCell((ItemDefinition)cell, (String)"portable_item_cell"));
        MEGAItems.getFluidPortables().forEach(cell -> HotkeyActions.registerPortableCell((ItemDefinition)cell, (String)"portable_fluid_cell"));
        MEGACells.initStorageCellModels();
        PLATFORM.initCompression();
        GridServices.register(DecompressionService.class, DecompressionService.class);
        PLATFORM.initLavaTransform();
        PLATFORM.addVillagerTrade((class_1935)MEGAItems.SKY_STEEL_INGOT, 8, 3, 20);
        PLATFORM.addVillagerTrade((class_1935)MEGAItems.ACCUMULATION_PROCESSOR_PRESS, 40, 1, 50);
    }

    private static void initStorageCellModels() {
        Stream.of(MEGAItems.getItemCells(), MEGAItems.getItemPortables()).flatMap(Collection::stream).forEach(c -> StorageCellModels.registerModel((class_1935)c, (class_2960)MEGACells.makeId("block/drive/cells/mega_item_cell")));
        Stream.of(MEGAItems.getFluidCells(), MEGAItems.getFluidPortables()).flatMap(Collection::stream).forEach(c -> StorageCellModels.registerModel((class_1935)c, (class_2960)MEGACells.makeId("block/drive/cells/mega_fluid_cell")));
        StorageCellModels.registerModel(MEGAItems.BULK_ITEM_CELL, (class_2960)MEGACells.makeId("block/drive/cells/bulk_item_cell"));
        if (PLATFORM.isAddonLoaded(Addons.APPBOT)) {
            Stream.of(AppBotItems.getCells(), AppBotItems.getPortables()).flatMap(Collection::stream).forEach(c -> StorageCellModels.registerModel((class_1935)c, (class_2960)MEGACells.makeId("block/drive/cells/mega_mana_cell")));
        }
    }

    public static void initUpgrades() {
        String storageCellGroup = GuiText.StorageCells.getTranslationKey();
        String portableCellGroup = GuiText.PortableCells.getTranslationKey();
        String interfaceGroup = GuiText.Interface.getTranslationKey();
        String wirelessTerminalGroup = GuiText.WirelessTerminals.getTranslationKey();
        for (ItemDefinition<?> itemDefinition : MEGAItems.getItemCells()) {
            Upgrades.add((class_1935)AEItems.FUZZY_CARD, itemDefinition, (int)1, (String)storageCellGroup);
            Upgrades.add((class_1935)AEItems.INVERTER_CARD, itemDefinition, (int)1, (String)storageCellGroup);
            Upgrades.add((class_1935)AEItems.EQUAL_DISTRIBUTION_CARD, itemDefinition, (int)1, (String)storageCellGroup);
            Upgrades.add((class_1935)AEItems.VOID_CARD, itemDefinition, (int)1, (String)storageCellGroup);
        }
        for (ItemDefinition<?> itemDefinition : MEGAItems.getFluidCells()) {
            Upgrades.add((class_1935)AEItems.INVERTER_CARD, itemDefinition, (int)1, (String)storageCellGroup);
            Upgrades.add((class_1935)AEItems.EQUAL_DISTRIBUTION_CARD, itemDefinition, (int)1, (String)storageCellGroup);
            Upgrades.add((class_1935)AEItems.VOID_CARD, itemDefinition, (int)1, (String)storageCellGroup);
        }
        for (ItemDefinition itemDefinition : MEGAItems.getItemPortables()) {
            Upgrades.add((class_1935)AEItems.FUZZY_CARD, (class_1935)itemDefinition, (int)1, (String)portableCellGroup);
            Upgrades.add((class_1935)AEItems.INVERTER_CARD, (class_1935)itemDefinition, (int)1, (String)portableCellGroup);
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (class_1935)itemDefinition, (int)2, (String)portableCellGroup);
            Upgrades.add((class_1935)AEItems.EQUAL_DISTRIBUTION_CARD, (class_1935)itemDefinition, (int)1, (String)storageCellGroup);
            Upgrades.add((class_1935)AEItems.VOID_CARD, (class_1935)itemDefinition, (int)1, (String)storageCellGroup);
        }
        for (ItemDefinition itemDefinition : MEGAItems.getFluidPortables()) {
            Upgrades.add((class_1935)AEItems.INVERTER_CARD, (class_1935)itemDefinition, (int)1, (String)portableCellGroup);
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (class_1935)itemDefinition, (int)2, (String)portableCellGroup);
            Upgrades.add((class_1935)AEItems.EQUAL_DISTRIBUTION_CARD, (class_1935)itemDefinition, (int)1, (String)storageCellGroup);
            Upgrades.add((class_1935)AEItems.VOID_CARD, (class_1935)itemDefinition, (int)1, (String)storageCellGroup);
        }
        Upgrades.add((class_1935)AEItems.CRAFTING_CARD, MEGABlocks.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
        Upgrades.add((class_1935)AEItems.CRAFTING_CARD, MEGAItems.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
        Upgrades.add((class_1935)AEItems.FUZZY_CARD, MEGABlocks.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
        Upgrades.add((class_1935)AEItems.FUZZY_CARD, MEGAItems.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
        Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (class_1935)AEItems.WIRELESS_TERMINAL, (int)2, (String)wirelessTerminalGroup);
        Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (class_1935)AEItems.WIRELESS_CRAFTING_TERMINAL, (int)2, (String)wirelessTerminalGroup);
        Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (class_1935)AEItems.COLOR_APPLICATOR, (int)2);
        Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (class_1935)AEItems.MATTER_CANNON, (int)2);
        Upgrades.add(MEGAItems.COMPRESSION_CARD, MEGAItems.BULK_ITEM_CELL, (int)1);
        for (ItemDefinition itemDefinition : List.of(AEItems.PORTABLE_ITEM_CELL1K, AEItems.PORTABLE_ITEM_CELL4K, AEItems.PORTABLE_ITEM_CELL16K, AEItems.PORTABLE_ITEM_CELL64K, AEItems.PORTABLE_ITEM_CELL256K, AEItems.PORTABLE_FLUID_CELL1K, AEItems.PORTABLE_FLUID_CELL4K, AEItems.PORTABLE_FLUID_CELL16K, AEItems.PORTABLE_FLUID_CELL64K, AEItems.PORTABLE_FLUID_CELL256K)) {
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (class_1935)itemDefinition, (int)2, (String)portableCellGroup);
        }
        if (PLATFORM.isAddonLoaded(Addons.AE2WTLIB)) {
            AE2WTIntegration.initUpgrades();
        }
        if (PLATFORM.isAddonLoaded(Addons.APPBOT)) {
            AppBotIntegration.initUpgrades();
        }
    }
}

