/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.fabric;

import appeng.api.IAEAddonEntrypoint;
import appeng.block.networking.EnergyCellBlockItem;
import appeng.client.gui.implementations.InterfaceScreen;
import appeng.client.gui.implementations.PatternProviderScreen;
import appeng.client.render.SimpleModelLoader;
import appeng.client.render.crafting.AbstractCraftingUnitModelProvider;
import appeng.client.render.crafting.CraftingCubeModel;
import appeng.client.render.crafting.CraftingMonitorRenderer;
import appeng.core.AppEng;
import appeng.core.definitions.ItemDefinition;
import appeng.init.client.InitScreens;
import appeng.items.storage.BasicStorageCell;
import appeng.items.tools.powered.AbstractPortableCell;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.block.MEGACraftingUnitType;
import gripe._90.megacells.client.gui.CellDockScreen;
import gripe._90.megacells.client.render.MEGACraftingUnitModelProvider;
import gripe._90.megacells.core.Addons;
import gripe._90.megacells.definition.MEGABlockEntities;
import gripe._90.megacells.definition.MEGABlocks;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.integration.appbot.AppBotItems;
import gripe._90.megacells.menu.CellDockMenu;
import gripe._90.megacells.menu.MEGAInterfaceMenu;
import gripe._90.megacells.menu.MEGAPatternProviderMenu;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5272;
import net.minecraft.class_5616;

@Environment(value=EnvType.CLIENT)
public class MEGACellsClient
implements IAEAddonEntrypoint {
    public void onAe2Initialized() {
        this.initScreens();
        this.initBlockModels();
        this.initItemModels();
        this.initItemColors();
    }

    private void initScreens() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            InitScreens.register(MEGAInterfaceMenu.TYPE, InterfaceScreen::new, (String)"/screens/megacells/mega_interface.json");
            InitScreens.register(MEGAPatternProviderMenu.TYPE, PatternProviderScreen::new, (String)"/screens/megacells/mega_pattern_provider.json");
            InitScreens.register(CellDockMenu.TYPE, CellDockScreen::new, (String)"/screens/megacells/cell_dock.json");
        });
    }

    private void initBlockModels() {
        for (MEGACraftingUnitType type : MEGACraftingUnitType.values()) {
            ModelLoadingRegistry.INSTANCE.registerResourceProvider(resourceManager -> new SimpleModelLoader(MEGACells.makeId("block/crafting/" + type.getAffix() + "_formed"), () -> new CraftingCubeModel((AbstractCraftingUnitModelProvider)new MEGACraftingUnitModelProvider(type))));
            BlockRenderLayerMap.INSTANCE.putBlock(type.getDefinition().block(), class_1921.method_23581());
        }
        class_5616.method_32144(MEGABlockEntities.MEGA_CRAFTING_MONITOR, CraftingMonitorRenderer::new);
    }

    private void initItemModels() {
        class_5272.method_27879((class_1792)MEGABlocks.MEGA_ENERGY_CELL.method_8389(), (class_2960)AppEng.makeId((String)"fill_level"), (is, level, entity, seed) -> {
            EnergyCellBlockItem energyCell = (EnergyCellBlockItem)MEGABlocks.MEGA_ENERGY_CELL.method_8389();
            double curPower = energyCell.getAECurrentPower(is);
            double maxPower = energyCell.getAEMaxPower(is);
            return (float)(curPower / maxPower);
        });
    }

    private void initItemColors() {
        ArrayList cells = new ArrayList(MEGAItems.getItemCells());
        cells.addAll(MEGAItems.getFluidCells());
        cells.add(MEGAItems.BULK_ITEM_CELL);
        ArrayList<ItemDefinition<? extends AbstractPortableCell>> portables = new ArrayList<ItemDefinition<? extends AbstractPortableCell>>(MEGAItems.getItemPortables());
        portables.addAll(MEGAItems.getFluidPortables());
        if (MEGACells.PLATFORM.isAddonLoaded(Addons.APPBOT)) {
            cells.addAll(AppBotItems.getCells());
            portables.addAll(AppBotItems.getPortables());
        }
        ColorProviderRegistry.ITEM.register(BasicStorageCell::getColor, (Object[])cells.toArray(new class_1935[0]));
        ColorProviderRegistry.ITEM.register(AbstractPortableCell::getColor, (Object[])portables.toArray(new class_1935[0]));
    }
}

