/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.item.cell;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.item.cell.BulkCellItem;
import gripe._90.megacells.misc.CompressionChain;
import gripe._90.megacells.misc.CompressionService;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.math.BigInteger;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public class BulkCellInventory
implements StorageCell {
    private static final String KEY = "key";
    private static final String UNIT_COUNT = "smallestUnitCount";
    private static final String UNIT_FACTOR = "unitFactor";
    private static final long STACK_LIMIT = (long)Math.pow(2.0, 42.0);
    private final ISaveProvider container;
    private final class_1799 stack;
    private AEItemKey storedItem;
    private final AEItemKey filterItem;
    private final boolean compressionEnabled;
    private final CompressionChain compressionChain;
    private BigInteger unitCount;
    private final BigInteger unitFactor;
    private boolean isPersisted = true;

    BulkCellInventory(class_1799 stack, ISaveProvider container) {
        BigInteger recordedFactor;
        this.stack = stack;
        this.container = container;
        BulkCellItem cell = (BulkCellItem)stack.method_7909();
        this.filterItem = (AEItemKey)cell.getConfigInventory(this.stack).getKey(0);
        this.storedItem = this.getTag().method_10545(KEY) ? AEItemKey.fromTag((class_2487)this.getTag().method_10562(KEY)) : null;
        this.unitCount = !this.getTag().method_10558(UNIT_COUNT).isEmpty() ? new BigInteger(this.getTag().method_10558(UNIT_COUNT)) : BigInteger.ZERO;
        this.compressionEnabled = cell.getUpgrades(this.stack).isInstalled(MEGAItems.COMPRESSION_CARD);
        this.compressionChain = CompressionService.INSTANCE.getChain(this.storedItem != null ? this.storedItem : this.filterItem).orElseGet(CompressionChain::new);
        this.unitFactor = this.compressionChain.unitFactor(this.storedItem != null ? this.storedItem : this.filterItem);
        BigInteger bigInteger = recordedFactor = !this.getTag().method_10558(UNIT_FACTOR).isEmpty() ? new BigInteger(this.getTag().method_10558(UNIT_FACTOR)) : this.unitFactor;
        if (!this.unitFactor.equals(recordedFactor)) {
            this.unitCount = this.unitCount.multiply(this.unitFactor).divide(recordedFactor);
            this.saveChanges();
        }
    }

    private long clampedLong(BigInteger toClamp, long limit) {
        return toClamp.min(BigInteger.valueOf(limit)).longValue();
    }

    private class_2487 getTag() {
        return this.stack.method_7948();
    }

    public CellState getStatus() {
        if (this.unitCount.signum() == 0) {
            return CellState.EMPTY;
        }
        if (!this.storedItem.equals((Object)this.filterItem)) {
            return CellState.FULL;
        }
        return CellState.NOT_EMPTY;
    }

    public AEItemKey getStoredItem() {
        return this.storedItem;
    }

    public long getStoredQuantity() {
        return this.clampedLong(this.unitCount.divide(this.unitFactor), Long.MAX_VALUE);
    }

    public AEItemKey getFilterItem() {
        return this.filterItem;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public CompressionChain getCompressionChain() {
        return this.compressionChain;
    }

    public double getIdleDrain() {
        return 5.0;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (amount == 0L || !(what instanceof AEItemKey)) {
            return 0L;
        }
        AEItemKey item = (AEItemKey)what;
        if (this.filterItem == null || this.storedItem != null && !this.filterItem.equals((Object)this.storedItem)) {
            return 0L;
        }
        if (!this.compressionEnabled && !what.equals(this.filterItem)) {
            return 0L;
        }
        if (this.compressionEnabled && !what.equals(this.filterItem) && !this.compressionChain.containsVariant(item)) {
            return 0L;
        }
        BigInteger factor = this.compressionChain.unitFactor(item);
        BigInteger units = BigInteger.valueOf(amount).multiply(factor);
        if (mode == Actionable.MODULATE) {
            if (this.storedItem == null) {
                this.storedItem = this.filterItem;
            }
            this.unitCount = this.unitCount.add(units);
            this.saveChanges();
        }
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (this.unitCount.signum() < 1 || !(what instanceof AEItemKey)) {
            return 0L;
        }
        AEItemKey item = (AEItemKey)what;
        if (this.filterItem == null || this.storedItem != null && !this.filterItem.equals((Object)this.storedItem)) {
            return 0L;
        }
        if (!(this.compressionEnabled || this.unitCount.divide(this.unitFactor).signum() >= 1 && what.equals(this.storedItem))) {
            return 0L;
        }
        if (this.compressionEnabled && !what.equals(this.filterItem) && !this.compressionChain.containsVariant(item)) {
            return 0L;
        }
        BigInteger factor = this.compressionChain.unitFactor(item);
        BigInteger currentUnitCount = this.unitCount;
        BigInteger units = BigInteger.valueOf(amount).multiply(factor);
        if (currentUnitCount.compareTo(units) <= 0) {
            if (mode == Actionable.MODULATE) {
                this.storedItem = null;
                this.unitCount = BigInteger.ZERO;
                this.saveChanges();
            }
            return this.clampedLong(currentUnitCount.divide(factor), Long.MAX_VALUE);
        }
        if (mode == Actionable.MODULATE) {
            this.unitCount = this.unitCount.subtract(units);
            this.saveChanges();
        }
        return this.clampedLong(units.divide(factor), Long.MAX_VALUE);
    }

    private void saveChanges() {
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.storedItem == null || this.unitCount.signum() < 1) {
            this.getTag().method_10551(KEY);
            this.getTag().method_10551(UNIT_COUNT);
            this.getTag().method_10551(UNIT_FACTOR);
        } else {
            this.getTag().method_10566(KEY, (class_2520)this.storedItem.toTagGeneric());
            this.getTag().method_10582(UNIT_COUNT, this.unitCount.toString());
            this.getTag().method_10582(UNIT_FACTOR, this.unitFactor.toString());
        }
        this.isPersisted = true;
    }

    public void getAvailableStacks(KeyCounter out) {
        if (this.storedItem != null) {
            if (this.compressionEnabled && this.storedItem.equals((Object)this.filterItem) && !this.compressionChain.isEmpty()) {
                BigInteger count = this.unitCount;
                CompressionChain chain = this.compressionChain.limited().lastMultiplierSwapped();
                ObjectListIterator objectListIterator = chain.iterator();
                while (objectListIterator.hasNext()) {
                    CompressionService.Variant variant = (CompressionService.Variant)objectListIterator.next();
                    BigInteger compressionFactor = BigInteger.valueOf(variant.factor());
                    AEItemKey key = variant.item();
                    if (count.divide(compressionFactor).signum() == 1 && variant != chain.get(chain.size() - 1)) {
                        out.add((AEKey)key, count.remainder(compressionFactor).longValue());
                        count = count.divide(compressionFactor);
                        continue;
                    }
                    out.add((AEKey)key, this.clampedLong(count, STACK_LIMIT));
                    break;
                }
            } else {
                out.add((AEKey)this.storedItem, this.clampedLong(this.unitCount.divide(this.unitFactor), STACK_LIMIT));
            }
        }
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        AEItemKey item;
        return what instanceof AEItemKey && ((item = (AEItemKey)what).equals((Object)this.storedItem) || item.equals((Object)this.filterItem) || this.compressionChain.containsVariant(item));
    }

    public boolean canFitInsideCell() {
        return this.filterItem == null && this.storedItem == null && this.unitCount.signum() < 1;
    }

    public class_2561 getDescription() {
        return this.stack.method_7964();
    }
}

