/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.stacks.AEItemKey;
import gripe._90.megacells.definition.MEGAConfig;
import gripe._90.megacells.misc.CompressionService;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class CompressionChain
extends ObjectArrayList<CompressionService.Variant> {
    public void add(AEItemKey item, byte factor) {
        this.add(new CompressionService.Variant(item, factor));
    }

    public boolean containsVariant(AEItemKey item) {
        return this.stream().anyMatch(v -> v.item().equals((Object)item));
    }

    public BigInteger unitFactor(AEItemKey item) {
        Optional<CompressionService.Variant> variant = this.stream().filter(v -> v.item().equals((Object)item)).findFirst();
        if (variant.isEmpty()) {
            return BigInteger.ONE;
        }
        ObjectList subChain = this.subList(0, this.indexOf(variant.get()) + 1);
        return subChain.stream().map(v -> BigInteger.valueOf(v.factor())).reduce(BigInteger.ONE, BigInteger::multiply);
    }

    public CompressionChain lastMultiplierSwapped() {
        List multipliers = this.stream().map(CompressionService.Variant::factor).collect(Collectors.toList());
        Collections.rotate(multipliers, -1);
        List<AEItemKey> items = this.stream().map(CompressionService.Variant::item).toList();
        CompressionChain chain = new CompressionChain();
        for (int i = 0; i < items.size(); ++i) {
            chain.add(items.get(i), (Byte)multipliers.get(i));
        }
        return chain;
    }

    public CompressionChain limited() {
        int chainLength = MEGAConfig.INSTANCE.getCompressionChainLimit();
        if (this.size <= chainLength) {
            return this;
        }
        CompressionChain chain = new CompressionChain();
        chain.addAll(this.subList(0, chainLength));
        return chain;
    }

    public CompressionChain reversed() {
        CompressionChain chain = new CompressionChain();
        for (int i = this.size - 1; i >= 0; --i) {
            chain.add((CompressionService.Variant)this.get(i));
        }
        return chain;
    }
}

