/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.stacks.AEItemKey;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.definition.MEGATags;
import gripe._90.megacells.misc.CompressionChain;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5455;

public class CompressionService {
    public static final CompressionService INSTANCE = new CompressionService();
    private final Set<CompressionChain> compressionChains = new ObjectOpenHashSet();
    private final Set<Override> overrides = new ObjectOpenHashSet();

    private CompressionService() {
    }

    public Optional<CompressionChain> getChain(AEItemKey item) {
        return this.compressionChains.stream().filter(chain -> chain.containsVariant(item)).findFirst();
    }

    public void loadRecipes(class_1863 recipeManager, class_5455 access) {
        this.compressionChains.clear();
        this.overrides.clear();
        List allRecipes = recipeManager.method_30027(class_3956.field_17545);
        List<class_3955> compressedCandidates = allRecipes.stream().filter(recipe -> this.isCompressionRecipe((class_3955)recipe, access)).toList();
        List<class_3955> decompressedCandidates = allRecipes.stream().filter(recipe -> this.isDecompressionRecipe((class_3955)recipe, access)).toList();
        List<class_3955> compressed = compressedCandidates.stream().filter(recipe -> this.isReversibleRecipe((class_3955)recipe, decompressedCandidates, access)).sorted(Comparator.comparingInt(r -> ((class_1856)r.method_8117().get(0)).method_8105().length)).toList();
        List<class_3955> decompressed = decompressedCandidates.stream().filter(recipe -> this.isReversibleRecipe((class_3955)recipe, compressedCandidates, access)).sorted(Comparator.comparingInt(r -> ((class_1856)r.method_8117().get(0)).method_8105().length)).toList();
        Stream.of(compressed, decompressed).flatMap(Collection::stream).forEach(recipe -> {
            class_1792 baseVariant = recipe.method_8110(access).method_7909();
            if (this.compressionChains.stream().noneMatch(chain -> chain.containsVariant(AEItemKey.of((class_1935)baseVariant)))) {
                this.compressionChains.add(this.generateChain(baseVariant, compressed, decompressed, access));
            }
        });
        if (!this.compressionChains.isEmpty()) {
            MEGACells.LOGGER.info("(Re-)initialised bulk cell compression.");
        }
    }

    private CompressionChain generateChain(class_1792 baseVariant, List<class_3955> compressed, List<class_3955> decompressed, class_5455 access) {
        LinkedList<class_1792> variants = new LinkedList<class_1792>();
        LinkedList<Byte> multipliers = new LinkedList<Byte>();
        variants.addFirst(baseVariant);
        Variant lower = this.getNextVariant(baseVariant, decompressed, false, access);
        while (lower != null) {
            variants.addFirst(lower.item().getItem());
            multipliers.addFirst(lower.factor());
            lower = this.getNextVariant(lower.item().getItem(), decompressed, false, access);
        }
        multipliers.addFirst((byte)1);
        CompressionChain chain = new CompressionChain();
        for (int i = 0; i < variants.size(); ++i) {
            chain.add(AEItemKey.of((class_1935)((class_1935)variants.get(i))), (Byte)multipliers.get(i));
        }
        Variant higher = this.getNextVariant(baseVariant, compressed, true, access);
        while (higher != null) {
            chain.add(higher);
            higher = this.getNextVariant(higher.item().getItem(), compressed, true, access);
        }
        return chain;
    }

    private Variant getNextVariant(class_1792 item, List<class_3955> recipes, boolean compressed, class_5455 access) {
        for (Override override : this.overrides) {
            if (compressed && override.smaller.equals(item)) {
                return new Variant(override.larger, override.factor);
            }
            if (compressed || !override.larger.equals(item)) continue;
            return new Variant(override.smaller, override.factor);
        }
        for (class_3955 recipe : recipes) {
            for (class_1799 input : ((class_1856)recipe.method_8117().get(0)).method_8105()) {
                if (!input.method_7909().equals(item)) continue;
                return new Variant(recipe.method_8110(access).method_7909(), (byte)(compressed ? recipe.method_8117().size() : recipe.method_8110(access).method_7947()));
            }
        }
        return null;
    }

    private boolean isDecompressionRecipe(class_3955 recipe, class_5455 access) {
        return recipe.method_8117().stream().filter(i -> !i.method_8103()).count() == 1L && Set.of(Integer.valueOf(4), Integer.valueOf(9)).contains(recipe.method_8110(access).method_7947());
    }

    private boolean isCompressionRecipe(class_3955 recipe, class_5455 access) {
        class_2371 ingredients = recipe.method_8117();
        return recipe.method_8110(access).method_7947() == 1 && ingredients.stream().noneMatch(class_1856::method_8103) && Set.of(Integer.valueOf(4), Integer.valueOf(9)).contains(ingredients.size()) && this.sameIngredient(recipe);
    }

    private boolean sameIngredient(class_3955 recipe) {
        class_2371 ingredients = recipe.method_8117();
        if (recipe instanceof class_1869) {
            return ingredients.stream().distinct().count() <= 1L;
        }
        class_1799[] first = ((class_1856)ingredients.get(0)).method_8105();
        for (class_1856 ingredient : ingredients) {
            class_1799[] stacks = ingredient.method_8105();
            if (stacks.length != first.length) {
                return false;
            }
            for (int i = 0; i < stacks.length; ++i) {
                if (class_1799.method_31577((class_1799)stacks[i], (class_1799)first[i])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isReversibleRecipe(class_3955 recipe, List<class_3955> candidates, class_5455 access) {
        if (this.overrideRecipe(recipe, access)) {
            return true;
        }
        class_1799[] testInput = ((class_1856)recipe.method_8117().get(0)).method_8105();
        class_1792 testOutput = recipe.method_8110(access).method_7909();
        for (class_3955 candidate : candidates) {
            class_1799[] input = ((class_1856)candidate.method_8117().get(0)).method_8105();
            class_1792 output = candidate.method_8110(access).method_7909();
            boolean compressible = Arrays.stream(input).anyMatch(i -> i.method_31574(testOutput));
            boolean decompressible = Arrays.stream(testInput).anyMatch(i -> i.method_31574(output));
            if (!compressible || !decompressible) continue;
            return true;
        }
        return false;
    }

    private boolean overrideRecipe(class_3955 recipe, class_5455 access) {
        for (class_1799 input : ((class_1856)recipe.method_8117().get(0)).method_8105()) {
            if (!input.method_31573(MEGATags.COMPRESSION_OVERRIDES)) continue;
            boolean compressed = !this.isDecompressionRecipe(recipe, access);
            class_1799 output = recipe.method_8110(access);
            class_1792 smaller = compressed ? input.method_7909() : output.method_7909();
            class_1792 larger = compressed ? output.method_7909() : input.method_7909();
            byte factor = (byte)(compressed ? recipe.method_8117().size() : output.method_7947());
            this.overrides.add(new Override(smaller, larger, factor));
            return true;
        }
        return false;
    }

    public record Variant(AEItemKey item, byte factor) {
        private Variant(class_1792 item, byte factor) {
            this(AEItemKey.of((class_1935)item), factor);
        }
    }

    private record Override(class_1792 smaller, class_1792 larger, byte factor) {
    }
}

