/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.crafting.IPatternDetails;
import appeng.api.implementations.blockentities.IChestOrDrive;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridService;
import appeng.api.networking.IGridServiceProvider;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.stacks.AEItemKey;
import appeng.api.storage.cells.StorageCell;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.item.cell.BulkCellInventory;
import gripe._90.megacells.item.part.DecompressionModulePart;
import gripe._90.megacells.misc.CompressionChain;
import gripe._90.megacells.misc.CompressionService;
import gripe._90.megacells.misc.DecompressionPattern;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class DecompressionService
implements IGridService,
IGridServiceProvider {
    private final List<IChestOrDrive> cellHosts = new ObjectArrayList();
    private final List<IPatternDetails> patterns = new ObjectArrayList();
    private final List<DecompressionModulePart> modules = new ObjectArrayList();

    public void addNode(IGridNode node, class_2487 savedData) {
        Object object = node.getOwner();
        if (object instanceof IChestOrDrive) {
            IChestOrDrive cellHost = (IChestOrDrive)object;
            this.cellHosts.add(cellHost);
        }
        if ((object = node.getOwner()) instanceof DecompressionModulePart) {
            DecompressionModulePart module = (DecompressionModulePart)((Object)object);
            this.modules.add(module);
        }
    }

    public void removeNode(IGridNode node) {
        Object object = node.getOwner();
        if (object instanceof IChestOrDrive) {
            IChestOrDrive cellHost = (IChestOrDrive)object;
            this.cellHosts.remove(cellHost);
        }
        if ((object = node.getOwner()) instanceof DecompressionModulePart) {
            DecompressionModulePart module = (DecompressionModulePart)((Object)object);
            this.modules.remove((Object)module);
        }
    }

    public void onServerStartTick() {
        this.patterns.clear();
        for (IChestOrDrive cellHost : this.cellHosts) {
            for (int i = 0; i < cellHost.getCellCount(); ++i) {
                BulkCellInventory bulkCell;
                StorageCell cell = cellHost.getOriginalCellInventory(i);
                if (!(cell instanceof BulkCellInventory) || !(bulkCell = (BulkCellInventory)cell).isCompressionEnabled()) continue;
                this.patterns.addAll(this.generatePatterns(bulkCell));
            }
        }
        for (DecompressionModulePart module : this.modules) {
            ICraftingProvider.requestUpdate((IManagedGridNode)module.getMainNode());
        }
    }

    public List<IPatternDetails> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    private Set<IPatternDetails> generatePatterns(BulkCellInventory cell) {
        CompressionChain fullChain = cell.getCompressionChain();
        if (fullChain.isEmpty()) {
            return Set.of();
        }
        ObjectLinkedOpenHashSet patterns = new ObjectLinkedOpenHashSet();
        CompressionChain decompressionChain = fullChain.limited().reversed();
        ObjectListIterator objectListIterator = decompressionChain.iterator();
        while (objectListIterator.hasNext()) {
            CompressionService.Variant variant = (CompressionService.Variant)objectListIterator.next();
            if (variant == decompressionChain.get(decompressionChain.size() - 1)) continue;
            class_1799 pattern = MEGAItems.DECOMPRESSION_PATTERN.stack();
            CompressionService.Variant decompressed = (CompressionService.Variant)decompressionChain.get(decompressionChain.indexOf(variant) + 1);
            this.encode(pattern.method_7948(), decompressed.item(), variant, false);
            patterns.add((Object)new DecompressionPattern(pattern));
        }
        ObjectList compressionChain = fullChain.subList(decompressionChain.size() - 1, fullChain.size());
        for (CompressionService.Variant variant : compressionChain) {
            if (variant == compressionChain.get(0)) continue;
            class_1799 pattern = MEGAItems.DECOMPRESSION_PATTERN.stack();
            CompressionService.Variant decompressed = (CompressionService.Variant)compressionChain.get(compressionChain.indexOf((Object)variant) - 1);
            this.encode(pattern.method_7948(), decompressed.item(), variant, true);
            patterns.add((Object)new DecompressionPattern(pattern));
        }
        return patterns;
    }

    private void encode(class_2487 tag, AEItemKey base, CompressionService.Variant variant, boolean toCompress) {
        tag.method_10566("variant", (class_2520)variant.item().toTag());
        tag.method_10566("base", (class_2520)base.toTag());
        tag.method_10569("factor", (int)variant.factor());
        tag.method_10556("toCompress", toCompress);
    }
}

