/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.entity.interaction.gifts;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.interaction.gifts.GiftPredicate;
import fabric.net.mca.entity.interaction.gifts.Response;
import fabric.net.mca.resources.data.analysis.IntAnalysis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class GiftType {
    static final List<GiftType> REGISTRY = new ArrayList<GiftType>();
    private final class_2960 id;
    private int priority;
    private final List<GiftPredicate> conditions;
    private final Map<class_1792, Integer> items;
    private final Map<class_6862<class_1792>, Integer> tags;
    private int fail;
    private int good;
    private int better;
    private final Map<Response, String> responses;

    public static GiftType fromJson(class_2960 id, JsonObject json) {
        ArrayList<GiftPredicate> conditions = new ArrayList<GiftPredicate>();
        class_3518.method_15292((JsonObject)json, (String)"conditions", (JsonArray)new JsonArray()).forEach(element -> conditions.add(GiftPredicate.fromJson(class_3518.method_15295((JsonElement)element, (String)"condition"))));
        HashMap<class_1792, Integer> items = new HashMap<class_1792, Integer>();
        HashMap<class_6862<class_1792>, Integer> tags = new HashMap<class_6862<class_1792>, Integer>();
        class_3518.method_15296((JsonObject)json, (String)"items").entrySet().forEach(element -> {
            String string = (String)element.getKey();
            Integer satisfaction = ((JsonElement)element.getValue()).getAsInt();
            if (string.charAt(0) == '#') {
                class_2960 identifier = new class_2960(string.substring(1));
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)identifier);
                if (tag != null) {
                    tags.put(tag, satisfaction);
                } else if (identifier.method_12836().equals("mca")) {
                    throw new JsonSyntaxException("Unknown item tag '" + identifier + "'");
                }
            } else {
                class_2960 identifier = new class_2960(string);
                Optional item = class_7923.field_41178.method_17966(identifier);
                if (item.isPresent()) {
                    items.put((class_1792)item.get(), satisfaction);
                } else if (identifier.method_12836().equals("mca")) {
                    throw new JsonSyntaxException("Unknown item '" + identifier + "'");
                }
            }
        });
        int priority = class_3518.method_15282((JsonObject)json, (String)"priority", (int)0);
        JsonObject thresholds = class_3518.method_15281((JsonObject)json, (String)"thresholds", (JsonObject)new JsonObject());
        int fail = class_3518.method_15282((JsonObject)thresholds, (String)"fail", (int)0);
        int good = class_3518.method_15282((JsonObject)thresholds, (String)"good", (int)10);
        int better = class_3518.method_15282((JsonObject)thresholds, (String)"better", (int)20);
        JsonObject responsesJson = class_3518.method_15281((JsonObject)json, (String)"responses", (JsonObject)new JsonObject());
        Map<Response, String> responses = Stream.of(Response.values()).collect(Collectors.toMap(Function.identity(), response -> class_3518.method_15253((JsonObject)responsesJson, (String)response.name().toLowerCase(Locale.ENGLISH), (String)response.getDefaultDialogue())));
        return new GiftType(id, priority, conditions, items, tags, fail, good, better, responses);
    }

    public static Stream<GiftType> allMatching(class_1799 stack) {
        return REGISTRY.stream().filter(type -> type.matches(stack));
    }

    public static Optional<GiftType> bestMatching(VillagerEntityMCA recipient, class_1799 stack, class_3222 player) {
        int max = GiftType.allMatching(stack).mapToInt(a -> a.priority).max().orElse(0);
        Optional<GiftType> worst = GiftType.allMatching(stack).filter(a -> a.priority == max).filter(a -> a.getResponse(a.getSatisfactionFor(recipient, stack, player).getTotal()) == Response.FAIL).max(Comparator.comparingDouble(a -> a.getSatisfactionFor(recipient, stack, player).getTotal().intValue()));
        if (worst.isPresent()) {
            return worst;
        }
        return GiftType.allMatching(stack).filter(a -> a.priority == max).max(Comparator.comparingDouble(a -> a.getSatisfactionFor(recipient, stack, player).getTotal().intValue()));
    }

    public static Optional<GiftType> getGiftType(class_2960 id) {
        return REGISTRY.stream().filter(p -> p.id.equals((Object)id)).findFirst();
    }

    private static Map<Response, String> getDefaultDialogues() {
        return Arrays.stream(Response.values()).collect(Collectors.toMap(r -> r, Response::getDefaultDialogue));
    }

    public GiftType(class_1792 item, int satisfaction, class_2960 extendFrom) {
        this(item, satisfaction, GiftType.getDefaultDialogues());
        Optional<GiftType> type = GiftType.getGiftType(extendFrom);
        type.ifPresent(this::extendFrom);
    }

    public GiftType(class_1792 item, int satisfaction, Map<Response, String> responses) {
        this(class_7923.field_41178.method_10221((Object)item), 0, new LinkedList<GiftPredicate>(), Collections.singletonMap(item, satisfaction), Collections.emptyMap(), 0, 10, 20, responses);
    }

    public GiftType(class_2960 id, int priority, List<GiftPredicate> conditions, Map<class_1792, Integer> items, Map<class_6862<class_1792>, Integer> tags, int fail, int good, int better, Map<Response, String> responses) {
        this.id = id;
        this.priority = priority;
        this.conditions = conditions;
        this.items = items;
        this.tags = tags;
        this.fail = fail;
        this.good = good;
        this.better = better;
        this.responses = responses;
    }

    public class_2960 getId() {
        return this.id;
    }

    public List<GiftPredicate> getConditions() {
        return this.conditions;
    }

    public Map<Response, String> getResponses() {
        return this.responses;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(class_1799 stack) {
        if (this.items.keySet().stream().anyMatch(i -> i == stack.method_7909())) return true;
        if (!this.tags.keySet().stream().anyMatch(arg_0 -> ((class_1799)stack).method_31573(arg_0))) return false;
        return true;
    }

    public IntAnalysis getSatisfactionFor(VillagerEntityMCA recipient, class_1799 stack, class_3222 player) {
        IntAnalysis analysis = new IntAnalysis();
        Optional<Integer> value = this.items.entrySet().stream().filter(i -> i.getKey() == stack.method_7909()).findFirst().map(Map.Entry::getValue);
        int base = value.orElseGet(() -> this.tags.entrySet().stream().filter(i -> stack.method_31573((class_6862)i.getKey())).findFirst().map(Map.Entry::getValue).orElse(0));
        analysis.add("base", base);
        for (GiftPredicate c : this.conditions) {
            int val = c.getSatisfactionFor(recipient, stack, player);
            if (!(c.test(recipient, stack, player) > 0.0f)) continue;
            analysis.add(c.getConditionKeys().get(0), val);
        }
        return analysis;
    }

    public Response getResponse(int satisfaction) {
        return satisfaction <= this.fail ? Response.FAIL : (satisfaction <= this.good ? Response.GOOD : (satisfaction <= this.better ? Response.BETTER : Response.BEST));
    }

    public String getDialogueFor(Response response) {
        return this.responses.get((Object)response);
    }

    public void extendFrom(GiftType extendingType) {
        this.conditions.addAll(extendingType.getConditions());
        this.responses.clear();
        this.responses.putAll(extendingType.getResponses());
        this.priority = extendingType.priority;
        this.fail = extendingType.fail;
        this.good = extendingType.good;
        this.better = extendingType.better;
    }
}

