/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import forge.net.mca.MCA;
import forge.net.mca.client.gui.InteractScreen;
import forge.net.mca.client.gui.MCAScreens;
import forge.net.mca.client.resources.Icon;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.ai.relationship.RelationshipState;
import forge.net.mca.network.c2s.GetFamilyTreeRequest;
import forge.net.mca.server.world.data.FamilyTreeNode;
import forge.net.mca.util.compat.ButtonWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class FamilyTreeScreen
extends Screen {
    private static final int HORIZONTAL_SPACING = 20;
    private static final int VERTICAL_SPACING = 60;
    private static final int SPOUSE_HORIZONTAL_SPACING = 50;
    private UUID focusedEntityId;
    private final Map<UUID, FamilyTreeNode> family = new HashMap<UUID, FamilyTreeNode>();
    private final TreeNode emptyNode;
    private TreeNode tree = this.emptyNode = new TreeNode();
    @Nullable
    private TreeNode focused;
    private double scrollX;
    private double scrollY;
    private final Screen parent;

    public FamilyTreeScreen(UUID entityId) {
        super((Component)Component.m_237115_((String)"gui.family_tree.title"));
        this.focusedEntityId = entityId;
        this.parent = Minecraft.m_91087_().f_91080_;
    }

    public boolean m_7043_() {
        return false;
    }

    public void setFamilyData(UUID uuid, Map<UUID, FamilyTreeNode> family) {
        this.focusedEntityId = uuid;
        this.family.putAll(family);
        this.rebuildTree();
    }

    private boolean focusEntity(UUID id) {
        this.focusedEntityId = id;
        NetworkHandler.sendToServer(new GetFamilyTreeRequest(id));
        return false;
    }

    public void m_7856_() {
        this.focusEntity(this.focusedEntityId);
        this.m_142416_((GuiEventListener)new ButtonWidget(this.f_96543_ / 2 - 100, this.f_96544_ - 25, 200, 20, (Component)Component.m_237115_((String)"gui.done"), sender -> this.m_7379_()));
    }

    public void m_7379_() {
        assert (this.f_96541_ != null);
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0) {
            this.scrollX += deltaX;
            this.scrollY += deltaY;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.focused != null) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            if (this.focusEntity(this.focused.id)) {
                this.rebuildTree();
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.m_280273_(context);
        context.m_280509_(0, 30, this.f_96543_, this.f_96544_ - 30, 0x66000000);
        this.focused = null;
        Window window = Minecraft.m_91087_().m_91268_();
        double f = window.m_85449_();
        int windowHeight = (int)Math.round((double)window.m_85446_() * f);
        int x = 0;
        int y = (int)(30.0 * f);
        int w = (int)((double)this.f_96543_ * f);
        int h = (int)((double)(this.f_96544_ - 60) * f);
        GL11.glScissor((int)x, (int)(windowHeight - h - y), (int)w, (int)h);
        GL11.glEnable((int)3089);
        PoseStack matrices = context.m_280168_();
        matrices.m_85836_();
        int xx = (int)(this.scrollX + (double)(this.f_96543_ / 2));
        int yy = (int)(this.scrollY + (double)(this.f_96544_ / 2));
        matrices.m_252880_((float)xx, (float)yy, 0.0f);
        this.tree.render(context, mouseX - xx, mouseY - yy);
        matrices.m_85849_();
        GL11.glDisable((int)3089);
        FamilyTreeNode selected = this.family.get(this.focusedEntityId);
        Component label = selected == null ? this.f_96539_ : Component.m_237113_((String)selected.getName()).m_130946_("'s ").m_7220_(this.f_96539_);
        context.m_280653_(this.f_96547_, label, this.f_96543_ / 2, 10, 0xFFFFFF);
        super.m_88315_(context, mouseX, mouseY, delta);
    }

    private void rebuildTree() {
        this.scrollX = 14.0;
        this.scrollY = -69.0;
        FamilyTreeNode focusedNode = this.family.get(this.focusedEntityId);
        this.focused = null;
        this.tree = this.emptyNode;
        if (focusedNode != null) {
            this.tree = this.insertParents(new TreeNode(focusedNode, true), focusedNode, 2);
        }
    }

    private TreeNode insertParents(TreeNode root, FamilyTreeNode focusedNode, int levels) {
        @Nullable FamilyTreeNode father = this.family.get(focusedNode.father());
        @Nullable FamilyTreeNode mother = this.family.get(focusedNode.mother());
        @Nullable FamilyTreeNode newRoot = father != null ? father : mother;
        TreeNode fNode = newRoot == null ? new TreeNode() : new TreeNode(newRoot, false);
        fNode.children.add(root);
        @Nullable FamilyTreeNode spouse = newRoot == father ? mother : father;
        TreeNode treeNode = fNode.spouse = spouse == null ? new TreeNode() : new TreeNode(spouse, false);
        if (newRoot != null && levels > 0) {
            return this.insertParents(fNode, newRoot, levels - 1);
        }
        return fNode;
    }

    private final class TreeNode {
        private boolean widthComputed;
        private int width;
        private int labelWidth;
        private final List<Component> label = new ArrayList<Component>();
        private final List<TreeNode> children = new ArrayList<TreeNode>();
        private Bounds bounds;
        TreeNode spouse;
        final UUID id;
        final boolean deceased;
        private final RelationshipState relationship;
        private final String defaultNodeName = "???";

        private TreeNode() {
            this.id = null;
            this.deceased = false;
            this.relationship = RelationshipState.SINGLE;
            this.label.add((Component)Component.m_237113_((String)"???"));
        }

        public TreeNode(FamilyTreeNode node, boolean recurse) {
            this(node, new HashSet<UUID>(), recurse);
        }

        public TreeNode(FamilyTreeNode node, Set<UUID> parsed, boolean recurse) {
            this.id = node.id();
            this.deceased = node.isDeceased();
            this.relationship = node.getRelationshipState();
            MutableComponent text = Component.m_237113_((String)(MCA.isBlankString(node.getName()) ? "???" : node.getName()));
            this.label.add((Component)text.m_6270_(text.m_7383_().m_178520_(node.gender().getColor())));
            this.label.add((Component)node.getProfessionText().m_130940_(ChatFormatting.GRAY));
            FamilyTreeNode father = FamilyTreeScreen.this.family.get(node.father());
            FamilyTreeNode mother = FamilyTreeScreen.this.family.get(node.mother());
            if ((father == null || father.isDeceased()) && (mother == null || mother.isDeceased())) {
                this.label.add((Component)Component.m_237115_((String)"gui.family_tree.label.orphan").m_130940_(ChatFormatting.GRAY));
            }
            if (node.getRelationshipState() != RelationshipState.SINGLE) {
                this.label.add((Component)Component.m_237115_((String)("marriage." + node.getRelationshipState().base().getIcon())));
            }
            if (recurse) {
                node.children().forEach(child -> {
                    FamilyTreeNode e = FamilyTreeScreen.this.family.get(child);
                    if (e != null) {
                        this.children.add(new TreeNode(e, parsed, parsed.add((UUID)child)));
                    }
                });
                FamilyTreeNode spouse = FamilyTreeScreen.this.family.get(node.partner());
                if (spouse != null) {
                    this.spouse = new TreeNode(spouse, parsed, false);
                } else if (!this.children.isEmpty()) {
                    this.spouse = new TreeNode();
                }
            }
        }

        public void render(GuiGraphics context, int mouseX, int mouseY) {
            boolean isFocused;
            PoseStack matrices = context.m_280168_();
            Bounds bounds = this.getBounds();
            boolean bl = isFocused = this.id != null && bounds.contains(mouseX, mouseY);
            if (isFocused) {
                FamilyTreeScreen.this.focused = this;
            }
            int childrenStartX = -this.getWidth() / 2;
            for (TreeNode node : this.children) {
                int x = (childrenStartX += (node.getWidth() + 20) / 2) + 10;
                int y = 60;
                this.drawHook(context, x, y);
                matrices.m_85836_();
                matrices.m_252880_((float)x, (float)y, 0.0f);
                node.render(context, mouseX - x, mouseY - y);
                matrices.m_85849_();
                childrenStartX += (node.getWidth() + 20) / 2;
            }
            matrices.m_85836_();
            matrices.m_252880_(0.0f, 0.0f, 400.0f);
            int fillColor = isFocused ? -267386816 : -267386864;
            int borderColor = isFocused ? -14155649 : 0x505000FF;
            context.m_280509_(bounds.left, bounds.top + 1, bounds.left + 1, bounds.bottom - 1, fillColor);
            context.m_280509_(bounds.right - 1, bounds.top + 1, bounds.right, bounds.bottom - 1, fillColor);
            context.m_280509_(bounds.left + 1, bounds.top, bounds.right - 1, bounds.bottom, fillColor);
            context.m_280509_(bounds.left + 1, bounds.top + 1, bounds.left + 2, bounds.bottom - 1, borderColor);
            context.m_280509_(bounds.right - 2, bounds.top + 1, bounds.right - 1, bounds.bottom - 1, borderColor);
            context.m_280509_(bounds.left + 2, bounds.top + 1, bounds.right - 2, bounds.top + 2, borderColor);
            context.m_280509_(bounds.left + 2, bounds.bottom - 2, bounds.right - 2, bounds.bottom - 1, borderColor);
            MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            int l = bounds.top + 5;
            int k = bounds.left + 6;
            if (this.deceased) {
                k += 20;
            }
            Matrix4f matrix4f = matrices.m_85850_().m_252922_();
            Font r = Minecraft.m_91087_().f_91062_;
            for (int s = 0; s < this.label.size(); ++s) {
                Component line = this.label.get(s);
                if (line != null) {
                    r.m_272077_(line, (float)k, (float)l, -1, true, matrix4f, (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                }
                if (s == 0) {
                    l += 2;
                }
                l += 10;
            }
            immediate.m_109911_();
            matrices.m_85849_();
            if (this.deceased) {
                Icon icon = MCAScreens.getInstance().getIcon("deceased");
                context.m_280398_(InteractScreen.ICON_TEXTURES, bounds.left + 6, bounds.top + 6, 0, (float)icon.u(), (float)icon.v(), 16, 16, 256, 256);
                if (isFocused && mouseX <= bounds.left + 20) {
                    matrices.m_85836_();
                    matrices.m_252880_(0.0f, 0.0f, 20.0f);
                    context.m_280557_(FamilyTreeScreen.this.f_96547_, (Component)Component.m_237115_((String)"gui.family_tree.label.deceased"), mouseX, mouseY);
                    matrices.m_85849_();
                }
            }
            if (this.spouse != null) {
                int x = bounds.left - 50;
                int y = bounds.top + bounds.bottom / 2;
                context.m_280656_(x, bounds.left - 1, y, -1);
                if (this.relationship == RelationshipState.MARRIED_TO_PLAYER || this.relationship == RelationshipState.MARRIED_TO_VILLAGER || this.relationship == RelationshipState.ENGAGED || this.relationship == RelationshipState.PROMISED || this.relationship == RelationshipState.WIDOW) {
                    Icon icon = MCAScreens.getInstance().getIcon(this.relationship.getIcon());
                    context.m_280398_(InteractScreen.ICON_TEXTURES, bounds.left - 25 - 8, y - 8, 0, (float)icon.u(), (float)icon.v(), 16, 16, 256, 256);
                }
                int n = this.spouse.label.size();
                Objects.requireNonNull(FamilyTreeScreen.this.f_96547_);
                matrices.m_85836_();
                matrices.m_252880_((float)(x -= this.spouse.getWidth() / 2 - 6), (float)(y -= n * 9 / 2), 0.0f);
                this.spouse.render(context, mouseX - x, mouseY - y);
                matrices.m_85849_();
            }
        }

        private void drawHook(GuiGraphics context, int endX, int endY) {
            int midY = endY / 2;
            context.m_280315_(0, 0, midY, -1);
            context.m_280656_(0, endX, midY, -1);
            context.m_280315_(endX, midY, endY, -1);
        }

        public int getWidth() {
            if (!this.widthComputed) {
                this.widthComputed = true;
                this.labelWidth = this.label.stream().mapToInt(arg_0 -> ((Font)FamilyTreeScreen.this.f_96547_).m_92852_(arg_0)).max().orElse(0);
                if (this.deceased) {
                    this.labelWidth += 20;
                }
                this.width = Math.max(this.labelWidth + 10, this.children.stream().mapToInt(TreeNode::getWidth).sum()) + 10;
                if (this.spouse != null) {
                    this.width += this.spouse.getWidth() + 50;
                }
            }
            return this.width;
        }

        public Bounds getBounds() {
            if (this.bounds == null) {
                this.getWidth();
                int padding = 4;
                int n = -this.labelWidth / 2 - padding;
                int n2 = this.labelWidth / 2 + padding * 2;
                int n3 = -padding;
                Objects.requireNonNull(FamilyTreeScreen.this.f_96547_);
                this.bounds = new Bounds(n, n2, n3, 9 * this.label.size() + padding * 2);
            }
            return this.bounds;
        }
    }

    static final class Bounds {
        final int left;
        final int right;
        final int top;
        final int bottom;

        public Bounds(int left, int right, int top, int bottom) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }

        public Bounds add(int x, int y) {
            return new Bounds(this.left + x, this.right + x, this.top + y, this.bottom + y);
        }

        public boolean contains(int mouseX, int mouseY) {
            return mouseX >= this.left && mouseY >= this.top && mouseX <= this.right && mouseY <= this.bottom;
        }
    }
}

