/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.resources.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forge.net.mca.MCA;
import forge.net.mca.util.RegistryHelper;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;

public final class BuildingType
implements Serializable {
    private static final long serialVersionUID = 2215455350801127280L;
    private final String name;
    private final int margin;
    private final String color;
    private final int priority;
    private final boolean visible;
    private final boolean noBeds;
    private final Map<String, Integer> blocks;
    private transient Map<ResourceLocation, ResourceLocation> blockToGroup;
    private transient Map<ResourceLocation, Integer> groups;
    private final boolean icon;
    private final int iconU;
    private final int iconV;
    private final boolean grouped;
    private final int mergeRange;

    public BuildingType() {
        this.name = "?";
        this.margin = 0;
        this.color = "ffffffff";
        this.priority = 0;
        this.visible = true;
        this.noBeds = false;
        this.blocks = Map.of("#minecraft:beds", 1000000000);
        this.blockToGroup = null;
        this.icon = false;
        this.iconU = 0;
        this.iconV = 0;
        this.grouped = false;
        this.mergeRange = 32;
    }

    public BuildingType(String name, JsonObject value) {
        JsonObject blocks;
        this.name = name;
        this.margin = GsonHelper.m_13824_((JsonObject)value, (String)"margin", (int)0);
        this.color = GsonHelper.m_13851_((JsonObject)value, (String)"color", (String)"ffffffff");
        this.priority = GsonHelper.m_13824_((JsonObject)value, (String)"priority", (int)0);
        this.visible = GsonHelper.m_13855_((JsonObject)value, (String)"visible", (boolean)true);
        this.noBeds = GsonHelper.m_13855_((JsonObject)value, (String)"noBeds", (boolean)false);
        this.icon = GsonHelper.m_13855_((JsonObject)value, (String)"icon", (boolean)false);
        this.iconU = GsonHelper.m_13824_((JsonObject)value, (String)"iconU", (int)0);
        this.iconV = GsonHelper.m_13824_((JsonObject)value, (String)"iconV", (int)0);
        this.grouped = GsonHelper.m_13855_((JsonObject)value, (String)"grouped", (boolean)false);
        this.mergeRange = GsonHelper.m_13824_((JsonObject)value, (String)"mergeRange", (int)0);
        this.blocks = new HashMap<String, Integer>();
        if (GsonHelper.m_144772_((JsonObject)value, (String)"blocks")) {
            blocks = GsonHelper.m_13930_((JsonObject)value, (String)"blocks");
            for (Map.Entry entry : blocks.entrySet()) {
                this.blocks.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
            }
        }
        this.groups = new HashMap<ResourceLocation, Integer>();
        if (GsonHelper.m_144772_((JsonObject)value, (String)"groups")) {
            blocks = GsonHelper.m_13930_((JsonObject)value, (String)"groups");
            for (Map.Entry entry : blocks.entrySet()) {
                this.groups.put(new ResourceLocation((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsInt());
            }
        }
    }

    public String name() {
        return this.name;
    }

    public String color() {
        return this.color;
    }

    public int priority() {
        return this.priority;
    }

    public boolean visible() {
        return this.visible;
    }

    public int getColor() {
        return (int)Long.parseLong(this.color, 16);
    }

    public Map<ResourceLocation, ResourceLocation> getBlockToGroup() {
        if (this.blockToGroup == null) {
            this.blockToGroup = new HashMap<ResourceLocation, ResourceLocation>();
            this.groups = new HashMap<ResourceLocation, Integer>();
            for (Map.Entry<String, Integer> requirement : this.blocks.entrySet()) {
                ResourceLocation identifier;
                if (requirement.getKey().startsWith("#")) {
                    identifier = new ResourceLocation(requirement.getKey().substring(1));
                    TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)identifier);
                    if (tag == null || RegistryHelper.isTagEmpty(tag)) {
                        MCA.LOGGER.error("Unknown building type tag " + identifier);
                    } else {
                        Optional<HolderSet<HolderSet>> entries = RegistryHelper.getEntries(tag);
                        entries.ifPresent(registryEntries -> {
                            for (Block b : registryEntries.m_203614_().map(Holder::m_203334_).toList()) {
                                this.blockToGroup.putIfAbsent(BuiltInRegistries.f_256975_.m_7981_((Object)b), identifier);
                            }
                        });
                    }
                } else {
                    identifier = new ResourceLocation(requirement.getKey());
                    this.blockToGroup.put(identifier, identifier);
                }
                this.groups.put(identifier, requirement.getValue());
            }
        }
        return this.blockToGroup;
    }

    public Map<ResourceLocation, Integer> getGroups() {
        this.getBlockToGroup();
        return this.groups;
    }

    public Map<ResourceLocation, List<BlockPos>> getGroups(Map<ResourceLocation, List<BlockPos>> blocks) {
        HashMap<ResourceLocation, List<BlockPos>> available = new HashMap<ResourceLocation, List<BlockPos>>();
        for (Map.Entry<ResourceLocation, List<BlockPos>> entry : blocks.entrySet()) {
            Optional.ofNullable(this.getBlockToGroup().get(entry.getKey())).ifPresent(v -> available.computeIfAbsent((ResourceLocation)v, k -> new LinkedList()).addAll((Collection)entry.getValue()));
        }
        return available;
    }

    public boolean isIcon() {
        return this.icon;
    }

    public int iconU() {
        return this.iconU * 20;
    }

    public int iconV() {
        return this.iconV * 60;
    }

    public boolean grouped() {
        return this.grouped;
    }

    public int mergeRange() {
        return this.mergeRange;
    }

    public boolean noBeds() {
        return this.noBeds;
    }

    public int getMargin() {
        return this.margin;
    }

    public int getMinBlocks() {
        return this.blocks.values().stream().mapToInt(v -> v).sum();
    }
}

