/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.world.data;

import forge.net.mca.util.NbtHelper;
import forge.net.mca.util.WorldUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.saveddata.SavedData;

public class Nationality
extends SavedData {
    private static final int CHUNK_SIZE = 128;
    private Map<Long, Integer> map = new HashMap<Long, Integer>();
    static final RandomSource random = RandomSource.m_216327_();
    private static final int[][] neighbours = new int[][]{{0, 0}, {-1, 0}, {1, 0}, {0, -1}, {0, 1}, {-1, 1}, {1, 1}, {-1, -1}, {-1, 1}};

    public static Nationality get(ServerLevel world) {
        return WorldUtils.loadData(world.m_7654_().m_129783_(), Nationality::new, w -> new Nationality(), "mca_nationality");
    }

    Nationality() {
    }

    Nationality(CompoundTag nbt) {
        this.map = NbtHelper.toMap(nbt, Long::valueOf, e -> ((IntTag)e).m_7047_());
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        NbtHelper.fromMap(nbt, this.map, String::valueOf, IntTag::m_128679_);
        return nbt;
    }

    private static long toId(long x, long z) {
        return x / 128L * Integer.MAX_VALUE + z / 128L;
    }

    public int getRegionId(BlockPos pos) {
        long rid;
        int id = -1;
        for (int[] neighbour : neighbours) {
            int z;
            int x = pos.m_123341_() + neighbour[0] * 128;
            long rid2 = Nationality.toId(x, z = pos.m_123343_() + neighbour[1] * 128);
            if (!this.map.containsKey(rid2)) continue;
            id = this.map.get(rid2);
            break;
        }
        if (id == -1) {
            id = random.m_188502_();
        }
        if (!this.map.containsKey(rid = Nationality.toId(pos.m_123341_(), pos.m_123343_()))) {
            this.map.put(rid, id);
            this.m_77762_();
        }
        return id;
    }
}

