/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_1111;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5862;
import net.minecraft.class_7373;
import quilt.net.mca.Config;
import quilt.net.mca.MCA;
import quilt.net.mca.client.sound.CustomEntityBoundSoundInstance;
import quilt.net.mca.client.sound.SingleWeighedSoundEvents;

public class OnlineSpeechManager {
    private static final MessageDigest MESSAGEDIGEST;
    public static final OnlineSpeechManager INSTANCE;
    private final class_310 client;
    private boolean warningIssued = false;
    private final Random random = new Random();

    public OnlineSpeechManager() {
        this.client = class_310.method_1551();
    }

    public static String toHex(byte[] bytes) {
        BigInteger bi = new BigInteger(1, bytes);
        return String.format(Locale.ROOT, "%0" + (bytes.length << 1) + "X", bi);
    }

    public String getHash(String text) {
        MESSAGEDIGEST.update(text.getBytes());
        return OnlineSpeechManager.toHex(MESSAGEDIGEST.digest()).toLowerCase(Locale.ROOT);
    }

    public void play(String language, String voice, float pitch, String text, class_1297 entity) {
        String hash = this.getHash(text);
        CompletableFuture.runAsync(() -> {
            if (this.downloadAudio(language, voice, text, hash, false)) {
                this.play(language, voice, pitch, entity, hash);
            } else if (!this.warningIssued) {
                this.warningIssued = true;
                class_310.method_1551().method_44714().method_44736((class_2561)class_2561.method_43471((String)"command.tts_busy").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}), false);
            }
        });
    }

    public void play(String language, String voice, float pitch, class_1297 entity, String hash) {
        class_2960 soundLocation = MCA.locate("tts_cache/" + language + "-" + voice + "/" + hash);
        class_1111 sound = new class_1111(soundLocation.method_12832(), (class_7373)class_5862.method_33908((float)1.0f), (class_7373)class_5862.method_33908((float)1.0f), 1, class_1111.class_1112.field_5474, true, false, 16);
        SingleWeighedSoundEvents weightedSoundEvents = new SingleWeighedSoundEvents(sound, soundLocation, "");
        CustomEntityBoundSoundInstance instance = new CustomEntityBoundSoundInstance(weightedSoundEvents, class_3414.method_47908((class_2960)soundLocation), class_3419.field_15254, 1.0f, pitch, entity, this.random.nextLong());
        this.client.execute(() -> this.client.method_1483().method_4873((class_1113)instance));
    }

    public boolean downloadAudio(String language, String voice, String text, String hash, boolean dry) {
        boolean bl;
        File file = new File("tts_cache/" + language + "-" + voice + "/" + hash + ".ogg");
        if (file.exists()) {
            if (file.length() == 0L) {
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException e) {
                    MCA.LOGGER.warn("Failed to delete file " + file.getPath());
                }
            } else {
                return true;
            }
        }
        file.getParentFile().mkdirs();
        FileOutputStream stream = new FileOutputStream(file);
        try {
            Map<String, String> params = Map.of("text", this.cleanPhrase(text), "language", language, "speaker", voice, "file_format", "ogg", "cache", "true", "prepare_speakers", String.valueOf(10), "load_async", "true");
            String encodedURL = params.keySet().stream().map(key -> key + "=" + URLEncoder.encode((String)params.get(key), StandardCharsets.UTF_8)).collect(Collectors.joining("&", Config.getInstance().villagerTTSServer + "v1/tts/xtts-v2?", ""));
            bl = this.downloadFile(encodedURL, stream, dry);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                MCA.LOGGER.warn("Failed to open file " + file.getPath());
                return false;
            }
        }
        stream.close();
        return bl;
    }

    private boolean downloadFile(String url, OutputStream output, boolean dry) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            int totalBytesRead = 0;
            try (InputStream input = connection.getInputStream();){
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = input.read(buffer)) != -1) {
                    output.write(buffer, 0, bytesRead);
                    totalBytesRead += bytesRead;
                    if (!dry) continue;
                    break;
                }
            }
            connection.disconnect();
            return totalBytesRead > 100;
        }
        catch (IOException e) {
            MCA.LOGGER.warn("Failed to download " + url + ": " + e.getMessage());
            return false;
        }
    }

    public String cleanPhrase(String p) {
        p = p.replaceAll("\\*.*\\*", "");
        p = p.replace("%supporter%", "someone");
        p = p.replace("%Supporter%", "someone");
        p = p.replace("some %2$s", "something");
        p = p.replace("at %2$s", "somewhere here");
        p = p.replace("At %2$s", "Somewhere here");
        p = p.replace(" to %2$s", " to here");
        p = p.replace(", %1$s.", ".");
        p = p.replace(", %1$s!", "!");
        p = p.replace(" %1$s!", "!");
        p = p.replace(", %1$s.", ".");
        p = p.replace("%1$s!", " ");
        p = p.replace("%1$s, ", " ");
        p = p.replace("%1$s", " ");
        p = p.replace("avoid %2$s", "avoid that location");
        p = p.replace(" Should be around %2$s.", "");
        p = p.replace("  ", " ");
        p = p.replace(" ,", ",");
        p = p.replace("Bahaha! ", "");
        p = p.replace("Run awaaaaaay! ", "Run!");
        p = p.replace("Aaaaaaaahhh! ", "");
        p = p.replace("Aaaaaaahhh! ", "");
        p = p.replace("Aaaaaaaaaaahhh! ", "");
        p = p.replace("AAAAAAAAAAAAAAAAAAAHHHHHH!!!!!! ", "");
        p = p.trim();
        return p;
    }

    static {
        INSTANCE = new OnlineSpeechManager();
        try {
            MESSAGEDIGEST = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

