/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.entity.ai.chatAI;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import org.apache.commons.io.IOUtils;
import quilt.net.mca.Config;
import quilt.net.mca.MCA;
import quilt.net.mca.entity.VillagerEntityMCA;
import quilt.net.mca.entity.ai.chatAI.ChatAIStrategy;
import quilt.net.mca.entity.ai.chatAI.gpt3Modules.EnvironmentModule;
import quilt.net.mca.entity.ai.chatAI.gpt3Modules.PersonalityModule;
import quilt.net.mca.entity.ai.chatAI.gpt3Modules.PlayerModule;
import quilt.net.mca.entity.ai.chatAI.gpt3Modules.RelationModule;
import quilt.net.mca.entity.ai.chatAI.gpt3Modules.TraitsModule;
import quilt.net.mca.entity.ai.chatAI.gpt3Modules.VillageModule;

public class GPT3
implements ChatAIStrategy {
    private static final int MIN_MEMORY = 100;
    private static final int MAX_MEMORY = 600;
    private static final int MAX_MEMORY_TIME = 54000;
    private static final Map<UUID, List<class_3545<String, String>>> memory = new HashMap<UUID, List<class_3545<String, String>>>();
    private static final Map<UUID, Long> lastInteractions = new HashMap<UUID, Long>();

    public static String translate(String phrase) {
        return phrase.replace("_", " ").toLowerCase(Locale.ROOT).replace("mca.", "");
    }

    public static Answer post(String url, String requestBody, String token) {
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.toString());
            con.setRequestProperty("Content-Type", "application/json");
            con.setRequestProperty("Accept", "application/json");
            con.setRequestProperty("Authorization", "Bearer " + token);
            con.setDoOutput(true);
            try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
                wr.write(requestBody.getBytes(StandardCharsets.UTF_8));
                wr.flush();
            }
            InputStream response = con.getInputStream();
            String body = IOUtils.toString((InputStream)response, (Charset)StandardCharsets.UTF_8);
            JsonObject map = JsonParser.parseString((String)body).getAsJsonObject();
            String message = map.has("choices") ? map.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").getAsJsonPrimitive("content").getAsString() : null;
            String error = map.has("error") ? map.get("error").getAsString().trim().replace("\n", " ") : null;
            message = message == null ? null : GPT3.cleanupAnswer(message);
            return new Answer(message, error);
        }
        catch (Exception e) {
            MCA.LOGGER.error((Object)e);
            return new Answer(null, "unknown");
        }
    }

    public static Answer request(String encodedURL) {
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(encodedURL).openConnection();
            con.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.toString());
            InputStream response = con.getInputStream();
            String body = IOUtils.toString((InputStream)response, (Charset)StandardCharsets.UTF_8);
            JsonObject map = JsonParser.parseString((String)body).getAsJsonObject();
            String answer = map.has("answer") ? map.get("answer").getAsString().trim().replace("\n", " ") : "";
            String error = map.has("error") ? map.get("error").getAsString().trim().replace("\n", " ") : null;
            return new Answer(answer, error);
        }
        catch (Exception e) {
            MCA.LOGGER.error((Object)e);
            return new Answer(null, "unknown");
        }
    }

    @Override
    public Optional<String> answer(class_3222 player, VillagerEntityMCA villager, String msg) {
        try {
            String playerName = player.method_5477().getString();
            String villagerName = villager.method_5477().getString();
            long time = villager.method_37908().method_8510();
            if (time > lastInteractions.getOrDefault(villager.method_5667(), 0L) + 54000L) {
                memory.remove(villager.method_5667());
            }
            lastInteractions.put(villager.method_5667(), time);
            List pastDialogue = memory.computeIfAbsent(villager.method_5667(), key -> new LinkedList());
            int memory = 100 + Math.min(5, Config.getInstance().villagerChatAIIntelligence) * 500 / 5;
            while (pastDialogue.stream().mapToInt(v -> ((String)v.method_15441()).length() / 4).sum() > memory) {
                pastDialogue.remove(0);
            }
            LinkedList<String> input = new LinkedList<String>();
            PersonalityModule.apply(input, villager, player);
            TraitsModule.apply(input, villager, player);
            RelationModule.apply(input, villager, player);
            VillageModule.apply(input, villager, player);
            EnvironmentModule.apply(input, villager, player);
            PlayerModule.apply(input, villager, player);
            Map<String, String> variables = Map.of("player", playerName, "villager", villagerName);
            StringBuilder sb = new StringBuilder();
            if (!Config.getInstance().villagerChatAISystemPrompt.isEmpty()) {
                sb.append(Config.getInstance().villagerChatAISystemPrompt);
                sb.append("\n");
            }
            for (String s2 : input) {
                for (Map.Entry<String, String> entry : variables.entrySet()) {
                    s2 = s2.replaceAll("\\$" + entry.getKey(), entry.getValue());
                }
                sb.append(s2);
            }
            String system = sb.toString();
            StringBuilder body = new StringBuilder();
            body.append("{");
            body.append("\"model\": \"").append(Config.getInstance().villagerChatAIModel).append("\",");
            body.append("\"messages\": [");
            body.append("{\"role\": \"system\", \"content\": ").append(GPT3.jsonStringQuote(system)).append("},");
            for (class_3545 pair : pastDialogue) {
                String role = (String)pair.method_15442();
                String content = (String)pair.method_15441();
                body.append("{\"role\": \"").append(role).append("\", \"content\": ").append(GPT3.jsonStringQuote(content)).append("},");
            }
            body.append("{\"role\": \"user\", \"content\": ").append(GPT3.jsonStringQuote(msg)).append("}");
            body.append("]}");
            String token = Config.getInstance().villagerChatAIToken;
            if (token.isEmpty() || Config.getInstance().villagerChatAIEndpoint.contains("conczin.net")) {
                token = variables.get("player");
            }
            Answer message = GPT3.post(Config.getInstance().villagerChatAIEndpoint, body.toString(), token);
            if (message.error == null) {
                if (message.answer != null) {
                    pastDialogue.add(new class_3545((Object)"user", (Object)msg));
                    pastDialogue.add(new class_3545((Object)"assistant", (Object)message.answer));
                }
                return Optional.ofNullable(message.answer);
            }
            if (message.error.equals("invalid_model")) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Invalid model!").method_27692(class_124.field_1061), false);
            } else if (message.error.equals("limit")) {
                class_5250 styled = class_2561.method_43471((String)"mca.limit.patreon").method_27694(s -> s.method_10977(class_124.field_1065).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://github.com/Luke100000/minecraft-comes-alive/wiki/GPT3-based-conversations#increase-conversation-limit")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"mca.limit.patreon.hover"))));
                player.method_7353((class_2561)styled, false);
            } else if (message.error.equals("limit_premium")) {
                player.method_7353((class_2561)class_2561.method_43471((String)"mca.limit.premium").method_27692(class_124.field_1061), false);
            } else {
                MCA.LOGGER.error(message.error);
                player.method_7353((class_2561)class_2561.method_43471((String)"mca.ai_broken").method_27692(class_124.field_1061), false);
            }
        }
        catch (Exception e) {
            MCA.LOGGER.error((Object)e);
            player.method_7353((class_2561)class_2561.method_43471((String)"mca.ai_broken").method_27692(class_124.field_1061), false);
        }
        return Optional.empty();
    }

    static String jsonStringQuote(String string) {
        StringBuilder sb = new StringBuilder("\"");
        for (char c : string.toCharArray()) {
            sb.append(switch (c) {
                case '\"', '/', '\\' -> "\\" + c;
                case '\b' -> "\\b";
                case '\t' -> "\\t";
                case '\n' -> "\\n";
                case '\f' -> "\\f";
                case '\r' -> "\\r";
                default -> c < ' ' ? String.format(Locale.ROOT, "\\u%04x", Character.valueOf(c)) : Character.valueOf(c);
            });
        }
        return sb.append('\"').toString();
    }

    static String cleanupAnswer(String answer) {
        answer = answer.replace("\"", "");
        answer = answer.replace("\n", " ");
        String[] parts = answer.split(":", 2);
        return parts[parts.length - 1].strip();
    }

    public record Answer(String answer, String error) {
    }
}

