/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.TelepathicAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.adventure.commands.AddGemCommand;
import dev.shadowsoffire.apotheosis.adventure.commands.BossCommand;
import dev.shadowsoffire.apotheosis.adventure.commands.CategoryCheckCommand;
import dev.shadowsoffire.apotheosis.adventure.commands.GemCommand;
import dev.shadowsoffire.apotheosis.adventure.commands.LootifyCommand;
import dev.shadowsoffire.apotheosis.adventure.commands.ModifierCommand;
import dev.shadowsoffire.apotheosis.adventure.commands.RarityCommand;
import dev.shadowsoffire.apotheosis.adventure.commands.SocketCommand;
import dev.shadowsoffire.apotheosis.adventure.compat.GameStagesCompat;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.cca.BossComponent;
import dev.shadowsoffire.apotheosis.cca.ZenithComponents;
import dev.shadowsoffire.apotheosis.util.Events;
import dev.shadowsoffire.attributeslib.api.ItemAttributeModifierEvent;
import dev.shadowsoffire.attributeslib.components.BooleanComponent;
import dev.shadowsoffire.placebo.events.AnvilLandCallback;
import dev.shadowsoffire.placebo.events.GetEnchantmentLevelEvent;
import dev.shadowsoffire.placebo.events.ItemUseEvent;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import io.github.fabricators_of_create.porting_lib.entity.events.EntityEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.PlayerEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.ShieldBlockEvent;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5425;
import net.minecraft.class_8111;
import net.spell_engine.api.spell.SpellEvents;

public class AdventureEvents {
    private static ThreadLocal<AtomicBoolean> reentrantLock = ThreadLocal.withInitial(() -> new AtomicBoolean(false));

    public static void init() {
        AdventureEvents.cmds();
        AdventureEvents.affixModifiers();
        AdventureEvents.preventBossSuffocate();
        AdventureEvents.impact();
        AdventureEvents.onDamage();
        AdventureEvents.onItemUse();
        AdventureEvents.shieldBlock();
        AdventureEvents.blockBreak();
        AdventureEvents.dropsHigh();
        AdventureEvents.drops();
        AdventureEvents.deathMark();
        AdventureEvents.speed();
        AdventureEvents.onBreak();
        AdventureEvents.special();
        AdventureEvents.gemSmashing();
        AdventureEvents.enchLevels();
        AdventureEvents.update();
        if (FabricLoader.getInstance().isModLoaded("spell_engine")) {
            AdventureEvents.onSpellCast();
        }
    }

    public static void cmds() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralArgumentBuilder root = class_2170.method_9247((String)"zenith");
            RarityCommand.register((LiteralArgumentBuilder<class_2168>)root);
            CategoryCheckCommand.register((LiteralArgumentBuilder<class_2168>)root);
            LootifyCommand.register((LiteralArgumentBuilder<class_2168>)root);
            ModifierCommand.register((LiteralArgumentBuilder<class_2168>)root);
            GemCommand.register((LiteralArgumentBuilder<class_2168>)root);
            SocketCommand.register((LiteralArgumentBuilder<class_2168>)root);
            BossCommand.register((LiteralArgumentBuilder<class_2168>)root);
            AddGemCommand.register((LiteralArgumentBuilder<class_2168>)root);
            dispatcher.register(root);
        });
    }

    public static void affixModifiers() {
        ItemAttributeModifierEvent.GATHER_TOOLTIPS.register(e -> {
            class_1799 stack = e.stack;
            if (stack.method_7985()) {
                Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(stack);
                affixes.forEach((afx, inst) -> inst.addModifiers(e.slot, (arg_0, arg_1) -> ((ItemAttributeModifierEvent.AttributeModifierEvent)e).addModifier(arg_0, arg_1)));
            }
        });
    }

    public static void preventBossSuffocate() {
        LivingEntityEvents.HURT.register((source, damaged, amount) -> {
            if (damaged.getCustomData().method_10545("apoth.boss")) {
                ((BossComponent)ZenithComponents.BOSS_DATA.get((Object)damaged)).setIsBoss(damaged.getCustomData().method_10577("apoth.boss"));
                damaged.getCustomData().method_10551("apoth.boss");
            }
            if (source.method_49708(class_8111.field_42340) && ((BossComponent)ZenithComponents.BOSS_DATA.get((Object)damaged)).getIsBoss()) {
                return 0.0f;
            }
            return amount;
        });
    }

    public static void fireArrow(class_1665 arrow) {
        class_1297 shooter;
        if (!((BooleanComponent)ZenithComponents.GENERATED_ARROW.get((Object)arrow)).getValue() && (shooter = arrow.method_24921()) instanceof class_1309) {
            class_1309 living = (class_1309)shooter;
            class_1799 bow = living.method_6030();
            if (bow.method_7960() && ((bow = living.method_6047()).method_7960() || !LootCategory.forItem(bow).isRanged())) {
                bow = living.method_6079();
            }
            if (bow.method_7960()) {
                return;
            }
            AffixHelper.streamAffixes(bow).forEach(a -> a.onArrowFired(living, arrow));
            AffixHelper.copyFrom(bow, (class_1297)arrow);
        }
    }

    public static void impact() {
        EntityEvents.PROJECTILE_IMPACT.register(event -> {
            class_1676 patt6022$temp = event.getProjectile();
            if (patt6022$temp instanceof class_1665) {
                class_1665 arrow = (class_1665)patt6022$temp;
                Map<DynamicHolder<Affix>, AffixInstance> affixes = AffixHelper.getAffixes((class_1297)arrow);
                class_239 hitResult = event.getRayTraceResult();
                affixes.values().forEach(inst -> inst.onArrowImpact(arrow, hitResult, hitResult.method_17783()));
            }
        });
    }

    public static void onDamage() {
        LivingEntityEvents.HURT.register((source, damaged, amount) -> {
            float finalAmount = amount;
            Adventure.Affixes.MAGICAL.getOptional().ifPresent(afx -> afx.onHurt(source, damaged, finalAmount));
            amount = finalAmount;
            for (class_1799 s : damaged.method_5743()) {
                Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(s);
                for (AffixInstance inst : affixes.values()) {
                    amount = inst.onHurt(source, damaged, amount);
                }
            }
            return amount;
        });
    }

    public static void onItemUse() {
        ItemUseEvent.ItemUse.ITEM_USE_EVENT.register(event -> {
            class_1799 s = event.stack;
            AtomicBoolean result = new AtomicBoolean(false);
            AffixHelper.streamAffixes(s).forEach(inst -> {
                class_1269 type = inst.onItemUse(event.ctx);
                if (type != null) {
                    event.cancellationResult = type;
                    result.set(true);
                }
            });
            return result.get();
        });
    }

    public static void onSpellCast() {
        SpellEvents.PROJECTILE_SHOOT.register(projectileLaunchEvent -> {
            Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(projectileLaunchEvent.caster().method_6047());
            affixes.values().forEach(inst -> inst.onCast(projectileLaunchEvent));
        });
    }

    public static void shieldBlock() {
        ShieldBlockEvent.EVENT.register(e -> {
            class_1799 stack = e.getEntity().method_6030();
            Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(stack);
            float blocked = e.getBlockedDamage();
            for (AffixInstance inst : affixes.values()) {
                blocked = inst.onShieldBlock(e.getEntity(), e.getDamageSource(), blocked);
            }
            if (blocked != e.getBlockedDamage()) {
                e.setBlockedDamage(blocked);
            }
        });
    }

    public static void blockBreak() {
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> {
            class_1799 stack = player.method_6047();
            AffixHelper.streamAffixes(stack).forEach(inst -> inst.onBlockBreak(player, (class_1936)world, pos, state));
        });
    }

    public static void dropsHigh() {
        LivingEntityEvents.DROPS.register((target, source, drops, lootingLevel, recentlyHit) -> {
            class_1297 patt8820$temp = source.method_5529();
            if (patt8820$temp instanceof class_3222) {
                class_3222 p = (class_3222)patt8820$temp;
                if (target instanceof class_1588 && drops != null) {
                    if (p instanceof FakePlayer) {
                        return false;
                    }
                    float chance = AdventureConfig.gemDropChance + (((BossComponent)ZenithComponents.BOSS_DATA.get((Object)target)).getIsBoss() ? AdventureConfig.gemBossBonus : 0.0f);
                    if (p.method_6051().method_43057() <= chance) {
                        class_1309 ent = target;
                        drops.add(new class_1542(ent.method_37908(), ent.method_23317(), ent.method_23318(), ent.method_23321(), GemRegistry.createRandomGemStack(p.method_6051(), (class_3218)p.method_37908(), p.method_7292(), WeightedDynamicRegistry.IDimensional.matches((class_1937)p.method_37908()), GameStagesCompat.IStaged.matches((class_1657)p)), 0.0, 0.0, 0.0));
                    }
                }
            }
            return false;
        });
    }

    public static void drops() {
        LivingEntityEvents.DROPS.register((target, source, drops, lootingLevel, recentlyHit) -> {
            if (drops == null) {
                return false;
            }
            Adventure.Affixes.FESTIVE.getOptional().ifPresent(afx -> afx.drops(target, source, drops));
            TelepathicAffix.drops(source, drops);
            Adventure.Affixes.FESTIVE.getOptional().ifPresent(afx -> afx.removeMarker(drops));
            return false;
        });
    }

    public static void deathMark() {
        Events.OnEntityDeath.LIVING_DEATH.register((entity, source) -> Adventure.Affixes.FESTIVE.getOptional().ifPresent(afx -> afx.markEquipment(entity, source)));
    }

    public static void speed() {
        PlayerEvents.BREAK_SPEED.register(e -> Adventure.Affixes.OMNETIC.getOptional().ifPresent(afx -> afx.speed(e)));
    }

    public static void onBreak() {
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> Adventure.Affixes.RADIAL.getOptional().ifPresent(afx -> afx.onBreak(world, player, pos, state, blockEntity)));
    }

    public static void special() {
        LivingEntityEvents.CHECK_SPAWN.register((mob, level, x, y, z, spawner, type) -> {
            if (level.method_8409().method_43057() <= AdventureConfig.randomAffixItem && mob instanceof class_1588) {
                class_1657 player = level.method_18459(x, y, z, -1.0, false);
                if (player == null) {
                    return true;
                }
                class_1799 affixItem = LootController.createRandomLootItem(level.method_8409(), null, player, (class_5425)((class_3218)mob.method_37908()));
                if (affixItem.method_7960()) {
                    return true;
                }
                affixItem.method_7948().method_10556("zenith_rspawn", true);
                LootCategory cat = LootCategory.forItem(affixItem);
                class_1304 slot = cat.getSlots()[0];
                mob.method_5673(slot, affixItem);
                mob.method_25939(slot);
            }
            return true;
        });
    }

    public static void gemSmashing() {
        AnvilLandCallback.EVENT.register((level, pos, newState, oldState, entity) -> {
            List items = level.method_18467(class_1542.class, new class_238(pos, pos.method_10069(1, 1, 1)));
            for (class_1542 ent : items) {
                class_1799 stack = ent.method_6983();
                if (!stack.method_31574(Adventure.Items.GEM)) continue;
                ent.method_6979(new class_1799((class_1935)Adventure.Items.GEM_DUST, stack.method_7947()));
            }
            return false;
        });
    }

    public static void enchLevels() {
        GetEnchantmentLevelEvent.GET_ENCHANTMENT_LEVEL.register((enchantments, stack) -> {
            boolean isReentrant = reentrantLock.get().getAndSet(true);
            if (isReentrant) {
                return enchantments;
            }
            if (stack.method_31573(Apoth.Tags.ENCHANT_LEVEL_MODIFIER_BLACKLIST)) {
                return enchantments;
            }
            AffixHelper.streamAffixes(stack).forEach(inst -> inst.getEnchantmentLevels(enchantments));
            reentrantLock.get().set(false);
            return enchantments;
        });
    }

    public static void update() {
        LivingEntityEvents.TICK.register(entity -> {
            if (entity.getCustomData().method_10545("apoth.burns_in_sun")) {
                ((BooleanComponent)ZenithComponents.BURNS.get((Object)entity)).setValue(entity.getCustomData().method_10577("apoth.burns_in_sun"));
                entity.getCustomData().method_10551("apoth.burns_in_sun");
            }
            if (((BooleanComponent)ZenithComponents.BURNS.get((Object)entity)).getValue() && entity.method_37908().method_8530() && !entity.method_37908().field_9236) {
                boolean flag;
                float f = entity.method_5718();
                class_2338 blockpos = class_2338.method_49637((double)entity.method_23317(), (double)entity.method_23320(), (double)entity.method_23321());
                boolean bl = flag = entity.method_5637() || entity.field_27857 || entity.field_28628;
                if (f > 0.5f && entity.method_6051().method_43057() * 30.0f < (f - 0.4f) * 2.0f && !flag && entity.method_37908().method_8311(blockpos)) {
                    entity.method_5639(8);
                }
            }
        });
    }
}

