/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix;

import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.cca.AffixDataComponent;
import dev.shadowsoffire.apotheosis.cca.ZenithComponents;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.util.CachedObject;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class AffixHelper {
    public static final class_2960 AFFIX_CACHED_OBJECT = Apotheosis.loc("affixes");
    public static final String DISPLAY = "display";
    public static final String LORE = "Lore";
    public static final String AFFIX_DATA = "affix_data";
    public static final String AFFIXES = "affixes";
    public static final String RARITY = "rarity";
    public static final String NAME = "name";

    public static void applyAffix(class_1799 stack, AffixInstance affix) {
        HashMap<DynamicHolder<? extends Affix>, AffixInstance> affixes = new HashMap<DynamicHolder<? extends Affix>, AffixInstance>(AffixHelper.getAffixes(stack));
        affixes.put(affix.affix(), affix);
        AffixHelper.setAffixes(stack, affixes);
    }

    public static void setAffixes(class_1799 stack, Map<DynamicHolder<? extends Affix>, AffixInstance> affixes) {
        class_2487 afxData = stack.method_7911(AFFIX_DATA);
        class_2487 affixesTag = new class_2487();
        for (AffixInstance inst : affixes.values()) {
            affixesTag.method_10548(inst.affix().getId().toString(), inst.level());
        }
        afxData.method_10566(AFFIXES, (class_2520)affixesTag);
    }

    public static void setName(class_1799 stack, class_2561 name) {
        class_2487 afxData = stack.method_7911(AFFIX_DATA);
        afxData.method_10582(NAME, class_2561.class_2562.method_10867((class_2561)name));
    }

    @Nullable
    public static class_2561 getName(class_1799 stack) {
        if (!stack.method_7985()) {
            return null;
        }
        class_2487 afxData = stack.method_7941(AFFIX_DATA);
        if (afxData == null) {
            return null;
        }
        return class_2561.class_2562.method_10877((String)afxData.method_10558(NAME));
    }

    public static Map<DynamicHolder<? extends Affix>, AffixInstance> getAffixes(class_1799 stack) {
        if (AffixRegistry.INSTANCE.getValues().isEmpty()) {
            return Collections.emptyMap();
        }
        return (Map)CachedObject.CachedObjectSource.getOrCreate((class_1799)stack, (class_2960)AFFIX_CACHED_OBJECT, AffixHelper::getAffixesImpl, (ToIntFunction)CachedObject.hashSubkey((String)AFFIX_DATA));
    }

    public static Map<DynamicHolder<? extends Affix>, AffixInstance> getAffixesImpl(class_1799 stack) {
        HashMap<DynamicHolder<? extends Affix>, AffixInstance> map = new HashMap<DynamicHolder<? extends Affix>, AffixInstance>();
        if (stack.method_7960()) {
            return Collections.emptyMap();
        }
        SocketHelper.loadSocketAffix(stack, map);
        class_2487 afxData = stack.method_7941(AFFIX_DATA);
        if (afxData != null && afxData.method_10545(AFFIXES)) {
            class_2487 affixes = afxData.method_10562(AFFIXES);
            DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(afxData);
            if (!rarity.isBound()) {
                rarity = RarityRegistry.getMinRarity();
            }
            LootCategory cat = LootCategory.forItem(stack);
            for (String key : affixes.method_10541()) {
                DynamicHolder affix = AffixRegistry.INSTANCE.holder(new class_2960(key));
                if (!affix.isBound() || !((Affix)affix.get()).canApplyTo(stack, cat, (LootRarity)rarity.get())) continue;
                float lvl = affixes.method_10583(key);
                map.put((DynamicHolder<? extends Affix>)affix, new AffixInstance((DynamicHolder<? extends Affix>)affix, stack, rarity, lvl));
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public static Stream<AffixInstance> streamAffixes(class_1799 stack) {
        return AffixHelper.getAffixes(stack).values().stream().filter(AffixInstance::isValid);
    }

    public static boolean hasAffixes(class_1799 stack) {
        return stack.method_7985() && !stack.method_7969().method_10562(AFFIX_DATA).method_10562(AFFIXES).method_33133();
    }

    public static void addLore(class_1799 stack, class_2561 lore) {
        class_2487 display = stack.method_7911(DISPLAY);
        class_2499 tag = display.method_10554(LORE, 8);
        tag.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)lore)));
        display.method_10566(LORE, (class_2520)tag);
    }

    public static void setRarity(class_1799 stack, LootRarity rarity) {
        class_5250 comp = class_2561.method_43469((String)"%s", (Object[])new Object[]{class_2561.method_43470((String)"")}).method_27696(class_2583.field_24360.method_27703(rarity.getColor()));
        class_2487 afxData = stack.method_7911(AFFIX_DATA);
        afxData.method_10582(NAME, class_2561.class_2562.method_10867((class_2561)comp));
        afxData.method_10582(RARITY, RarityRegistry.INSTANCE.getKey(rarity).toString());
    }

    public static void copyFrom(class_1799 stack, class_1297 entity) {
        if (AffixHelper.hasAffixes(stack)) {
            class_2487 afxData = stack.method_7941(AFFIX_DATA);
            ((AffixDataComponent)ZenithComponents.AFFIX_DATA.get((Object)entity)).setEntityTag(afxData.method_10553());
        }
    }

    public static Map<DynamicHolder<Affix>, AffixInstance> getAffixes(class_1297 entity) {
        HashMap<DynamicHolder<Affix>, AffixInstance> map = new HashMap<DynamicHolder<Affix>, AffixInstance>();
        if (entity == null) {
            return map;
        }
        class_2487 afxData = ((AffixDataComponent)ZenithComponents.AFFIX_DATA.get((Object)entity)).getEntityTag();
        if (afxData != null && afxData.method_10545(AFFIXES)) {
            class_2487 affixes = afxData.method_10562(AFFIXES);
            DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(afxData);
            if (!rarity.isBound()) {
                rarity = RarityRegistry.getMinRarity();
            }
            for (String key : affixes.method_10541()) {
                DynamicHolder affix = AffixRegistry.INSTANCE.holder(new class_2960(key));
                if (!affix.isBound()) continue;
                float lvl = affixes.method_10583(key);
                map.put((DynamicHolder<Affix>)affix, new AffixInstance((DynamicHolder<? extends Affix>)affix, class_1799.field_8037, rarity, lvl));
            }
        }
        return map;
    }

    public static Stream<AffixInstance> streamAffixes(class_1297 entity) {
        return AffixHelper.getAffixes(entity).values().stream();
    }

    public static DynamicHolder<LootRarity> getRarity(class_1799 stack) {
        if (!stack.method_7985()) {
            return RarityRegistry.INSTANCE.emptyHolder();
        }
        class_2487 afxData = stack.method_7941(AFFIX_DATA);
        return AffixHelper.getRarity(afxData);
    }

    public static DynamicHolder<LootRarity> getRarity(@Nullable class_2487 afxData) {
        if (afxData != null) {
            try {
                return RarityRegistry.byLegacyId(afxData.method_10558(RARITY));
            }
            catch (IllegalArgumentException e) {
                afxData.method_10551(RARITY);
                return RarityRegistry.byLegacyId("empty");
            }
        }
        return RarityRegistry.INSTANCE.emptyHolder();
    }

    public static Collection<DynamicHolder<Affix>> byType(AffixType type) {
        return AffixRegistry.INSTANCE.getTypeMap().get((Object)type);
    }

    public static StepFunction step(float min, int steps, float step) {
        return new StepFunction(min, steps, step);
    }
}

