/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.affix.AttributeAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.CatalyzingAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.CleavingAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.DamageReductionAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.DurableAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.EnlightenedAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.ExecutingAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.FestiveAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.MagicalArrowAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.OmneticAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.PotionAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.PsychicAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.RadialAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.RetreatingAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.SpectralShotAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.TelepathicAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.ThunderstruckAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.SocketAffix;
import dev.shadowsoffire.apotheosis.adventure.client.AdventureModuleClient;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;

public class AffixRegistry
extends DynamicRegistry<Affix> {
    public static final AffixRegistry INSTANCE = new AffixRegistry();
    private Multimap<AffixType, DynamicHolder<Affix>> byType = ImmutableMultimap.of();

    public AffixRegistry() {
        super(AdventureModule.LOGGER, "affixes", true, true);
    }

    protected void beginReload() {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        super.beginReload();
        this.byType = ImmutableMultimap.of();
    }

    protected void onReload() {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        super.onReload();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        this.registry.values().forEach(a -> builder.put((Object)a.type, (Object)this.holder((CodecProvider)a)));
        this.byType = builder.build();
        Preconditions.checkArgument((boolean)(Adventure.Affixes.SOCKET.get() instanceof SocketAffix), (Object)"Socket Affix not registered!");
        Preconditions.checkArgument((boolean)(Adventure.Affixes.DURABLE.get() instanceof DurableAffix), (Object)"Durable Affix not registered!");
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && Apotheosis.enableDebug) {
            AdventureModuleClient.checkAffixLangKeys();
        }
        RarityRegistry.INSTANCE.validateLootRules();
    }

    protected void registerBuiltinCodecs() {
        this.registerCodec(Apotheosis.loc("attribute"), AttributeAffix.CODEC);
        this.registerCodec(Apotheosis.loc("mob_effect"), PotionAffix.CODEC);
        this.registerCodec(Apotheosis.loc("damage_reduction"), DamageReductionAffix.CODEC);
        this.registerCodec(Apotheosis.loc("catalyzing"), CatalyzingAffix.CODEC);
        this.registerCodec(Apotheosis.loc("cleaving"), CleavingAffix.CODEC);
        this.registerCodec(Apotheosis.loc("enlightened"), EnlightenedAffix.CODEC);
        this.registerCodec(Apotheosis.loc("executing"), ExecutingAffix.CODEC);
        this.registerCodec(Apotheosis.loc("festive"), FestiveAffix.CODEC);
        this.registerCodec(Apotheosis.loc("magical"), MagicalArrowAffix.CODEC);
        this.registerCodec(Apotheosis.loc("omnetic"), OmneticAffix.CODEC);
        this.registerCodec(Apotheosis.loc("psychic"), PsychicAffix.CODEC);
        this.registerCodec(Apotheosis.loc("radial"), RadialAffix.CODEC);
        this.registerCodec(Apotheosis.loc("retreating"), RetreatingAffix.CODEC);
        this.registerCodec(Apotheosis.loc("spectral"), SpectralShotAffix.CODEC);
        this.registerCodec(Apotheosis.loc("telepathic"), TelepathicAffix.CODEC);
        this.registerCodec(Apotheosis.loc("thunderstruck"), ThunderstruckAffix.CODEC);
        this.registerCodec(Apotheosis.loc("socket"), SocketAffix.CODEC);
        this.registerCodec(Apotheosis.loc("durable"), DurableAffix.CODEC);
    }

    public Multimap<AffixType, DynamicHolder<Affix>> getTypeMap() {
        return this.byType;
    }
}

